/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.account.model;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the AccountGroupAccountEntryRel service. Represents a row in the &quot;AccountGroupAccountEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.account.model.impl.AccountGroupAccountEntryRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.account.model.impl.AccountGroupAccountEntryRelImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountGroupAccountEntryRel
 * @generated
 */
@ProviderType
public interface AccountGroupAccountEntryRelModel
	extends BaseModel<AccountGroupAccountEntryRel>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a account group account entry rel model instance should use the {@link AccountGroupAccountEntryRel} interface instead.
	 */

	/**
	 * Returns the primary key of this account group account entry rel.
	 *
	 * @return the primary key of this account group account entry rel
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this account group account entry rel.
	 *
	 * @param primaryKey the primary key of this account group account entry rel
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this account group account entry rel.
	 *
	 * @return the mvcc version of this account group account entry rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this account group account entry rel.
	 *
	 * @param mvccVersion the mvcc version of this account group account entry rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the account group account entry rel ID of this account group account entry rel.
	 *
	 * @return the account group account entry rel ID of this account group account entry rel
	 */
	public long getAccountGroupAccountEntryRelId();

	/**
	 * Sets the account group account entry rel ID of this account group account entry rel.
	 *
	 * @param AccountGroupAccountEntryRelId the account group account entry rel ID of this account group account entry rel
	 */
	public void setAccountGroupAccountEntryRelId(
		long AccountGroupAccountEntryRelId);

	/**
	 * Returns the company ID of this account group account entry rel.
	 *
	 * @return the company ID of this account group account entry rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this account group account entry rel.
	 *
	 * @param companyId the company ID of this account group account entry rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the account group ID of this account group account entry rel.
	 *
	 * @return the account group ID of this account group account entry rel
	 */
	public long getAccountGroupId();

	/**
	 * Sets the account group ID of this account group account entry rel.
	 *
	 * @param accountGroupId the account group ID of this account group account entry rel
	 */
	public void setAccountGroupId(long accountGroupId);

	/**
	 * Returns the account entry ID of this account group account entry rel.
	 *
	 * @return the account entry ID of this account group account entry rel
	 */
	public long getAccountEntryId();

	/**
	 * Sets the account entry ID of this account group account entry rel.
	 *
	 * @param accountEntryId the account entry ID of this account group account entry rel
	 */
	public void setAccountEntryId(long accountEntryId);

}