/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.asset.taglib.servlet.taglib;

import com.liferay.asset.taglib.internal.servlet.ServletContextUtil;
import com.liferay.taglib.util.IncludeTag;

import javax.portlet.PortletURL;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

/**
 * @author Julio Camarero
 */
public class CategorizationFilterTag extends IncludeTag {

	public String getAssetType() {
		return _assetType;
	}

	public long[] getGroupIds() {
		return _groupIds;
	}

	public PortletURL getPortletURL() {
		return _portletURL;
	}

	public void setAssetType(String assetType) {
		_assetType = assetType;
	}

	public void setGroupIds(long[] groupIds) {
		_groupIds = groupIds;
	}

	@Override
	public void setPageContext(PageContext pageContext) {
		super.setPageContext(pageContext);

		servletContext = ServletContextUtil.getServletContext();
	}

	public void setPortletURL(PortletURL portletURL) {
		_portletURL = portletURL;
	}

	@Override
	protected void cleanUp() {
		super.cleanUp();

		_assetType = null;
		_groupIds = null;
		_portletURL = null;
	}

	@Override
	protected String getPage() {
		return _PAGE;
	}

	@Override
	protected void setAttributes(HttpServletRequest httpServletRequest) {
		httpServletRequest.setAttribute(
			"liferay-asset:categorization-filter:assetType", _assetType);
		httpServletRequest.setAttribute(
			"liferay-asset:categorization-filter:groupIds", _groupIds);
		httpServletRequest.setAttribute(
			"liferay-asset:categorization-filter:portletURL", _portletURL);
	}

	private static final String _PAGE = "/categorization_filter/page.jsp";

	private String _assetType;
	private long[] _groupIds;
	private PortletURL _portletURL;

}