/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.bom.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceBOMDefinition service. Represents a row in the &quot;CommerceBOMDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.bom.model.impl.CommerceBOMDefinitionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.bom.model.impl.CommerceBOMDefinitionImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMDefinition
 * @generated
 */
@ProviderType
public interface CommerceBOMDefinitionModel
	extends AuditedModel, BaseModel<CommerceBOMDefinition>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce bom definition model instance should use the {@link CommerceBOMDefinition} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce bom definition.
	 *
	 * @return the primary key of this commerce bom definition
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce bom definition.
	 *
	 * @param primaryKey the primary key of this commerce bom definition
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce bom definition ID of this commerce bom definition.
	 *
	 * @return the commerce bom definition ID of this commerce bom definition
	 */
	public long getCommerceBOMDefinitionId();

	/**
	 * Sets the commerce bom definition ID of this commerce bom definition.
	 *
	 * @param commerceBOMDefinitionId the commerce bom definition ID of this commerce bom definition
	 */
	public void setCommerceBOMDefinitionId(long commerceBOMDefinitionId);

	/**
	 * Returns the company ID of this commerce bom definition.
	 *
	 * @return the company ID of this commerce bom definition
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce bom definition.
	 *
	 * @param companyId the company ID of this commerce bom definition
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce bom definition.
	 *
	 * @return the user ID of this commerce bom definition
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce bom definition.
	 *
	 * @param userId the user ID of this commerce bom definition
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce bom definition.
	 *
	 * @return the user uuid of this commerce bom definition
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce bom definition.
	 *
	 * @param userUuid the user uuid of this commerce bom definition
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce bom definition.
	 *
	 * @return the user name of this commerce bom definition
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce bom definition.
	 *
	 * @param userName the user name of this commerce bom definition
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce bom definition.
	 *
	 * @return the create date of this commerce bom definition
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce bom definition.
	 *
	 * @param createDate the create date of this commerce bom definition
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce bom definition.
	 *
	 * @return the modified date of this commerce bom definition
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce bom definition.
	 *
	 * @param modifiedDate the modified date of this commerce bom definition
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce bom folder ID of this commerce bom definition.
	 *
	 * @return the commerce bom folder ID of this commerce bom definition
	 */
	public long getCommerceBOMFolderId();

	/**
	 * Sets the commerce bom folder ID of this commerce bom definition.
	 *
	 * @param commerceBOMFolderId the commerce bom folder ID of this commerce bom definition
	 */
	public void setCommerceBOMFolderId(long commerceBOMFolderId);

	/**
	 * Returns the cp attachment file entry ID of this commerce bom definition.
	 *
	 * @return the cp attachment file entry ID of this commerce bom definition
	 */
	public long getCPAttachmentFileEntryId();

	/**
	 * Sets the cp attachment file entry ID of this commerce bom definition.
	 *
	 * @param CPAttachmentFileEntryId the cp attachment file entry ID of this commerce bom definition
	 */
	public void setCPAttachmentFileEntryId(long CPAttachmentFileEntryId);

	/**
	 * Returns the name of this commerce bom definition.
	 *
	 * @return the name of this commerce bom definition
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this commerce bom definition.
	 *
	 * @param name the name of this commerce bom definition
	 */
	public void setName(String name);

	/**
	 * Returns the friendly url of this commerce bom definition.
	 *
	 * @return the friendly url of this commerce bom definition
	 */
	@AutoEscape
	public String getFriendlyUrl();

	/**
	 * Sets the friendly url of this commerce bom definition.
	 *
	 * @param friendlyUrl the friendly url of this commerce bom definition
	 */
	public void setFriendlyUrl(String friendlyUrl);

}