/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.bom.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommerceBOMFolder service. Represents a row in the &quot;CommerceBOMFolder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.bom.model.impl.CommerceBOMFolderModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.bom.model.impl.CommerceBOMFolderImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommerceBOMFolder
 * @generated
 */
@ProviderType
public interface CommerceBOMFolderModel
	extends AuditedModel, BaseModel<CommerceBOMFolder>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce bom folder model instance should use the {@link CommerceBOMFolder} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce bom folder.
	 *
	 * @return the primary key of this commerce bom folder
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce bom folder.
	 *
	 * @param primaryKey the primary key of this commerce bom folder
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce bom folder ID of this commerce bom folder.
	 *
	 * @return the commerce bom folder ID of this commerce bom folder
	 */
	public long getCommerceBOMFolderId();

	/**
	 * Sets the commerce bom folder ID of this commerce bom folder.
	 *
	 * @param commerceBOMFolderId the commerce bom folder ID of this commerce bom folder
	 */
	public void setCommerceBOMFolderId(long commerceBOMFolderId);

	/**
	 * Returns the company ID of this commerce bom folder.
	 *
	 * @return the company ID of this commerce bom folder
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce bom folder.
	 *
	 * @param companyId the company ID of this commerce bom folder
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce bom folder.
	 *
	 * @return the user ID of this commerce bom folder
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce bom folder.
	 *
	 * @param userId the user ID of this commerce bom folder
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce bom folder.
	 *
	 * @return the user uuid of this commerce bom folder
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce bom folder.
	 *
	 * @param userUuid the user uuid of this commerce bom folder
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce bom folder.
	 *
	 * @return the user name of this commerce bom folder
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce bom folder.
	 *
	 * @param userName the user name of this commerce bom folder
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce bom folder.
	 *
	 * @return the create date of this commerce bom folder
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce bom folder.
	 *
	 * @param createDate the create date of this commerce bom folder
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce bom folder.
	 *
	 * @return the modified date of this commerce bom folder
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce bom folder.
	 *
	 * @param modifiedDate the modified date of this commerce bom folder
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the parent commerce bom folder ID of this commerce bom folder.
	 *
	 * @return the parent commerce bom folder ID of this commerce bom folder
	 */
	public long getParentCommerceBOMFolderId();

	/**
	 * Sets the parent commerce bom folder ID of this commerce bom folder.
	 *
	 * @param parentCommerceBOMFolderId the parent commerce bom folder ID of this commerce bom folder
	 */
	public void setParentCommerceBOMFolderId(long parentCommerceBOMFolderId);

	/**
	 * Returns the name of this commerce bom folder.
	 *
	 * @return the name of this commerce bom folder
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this commerce bom folder.
	 *
	 * @param name the name of this commerce bom folder
	 */
	public void setName(String name);

	/**
	 * Returns the logo ID of this commerce bom folder.
	 *
	 * @return the logo ID of this commerce bom folder
	 */
	public long getLogoId();

	/**
	 * Sets the logo ID of this commerce bom folder.
	 *
	 * @param logoId the logo ID of this commerce bom folder
	 */
	public void setLogoId(long logoId);

	/**
	 * Returns the tree path of this commerce bom folder.
	 *
	 * @return the tree path of this commerce bom folder
	 */
	@AutoEscape
	public String getTreePath();

	/**
	 * Sets the tree path of this commerce bom folder.
	 *
	 * @param treePath the tree path of this commerce bom folder
	 */
	public void setTreePath(String treePath);

}