/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.product.constants;

/**
 * @author Marco Leo
 * @author Alessio Antonio Rendina
 */
public class CPConstants {

	public static final String C_PRODUCT_VERSIONING_SERVICE_NAME =
		"com.liferay.commerce.product.versioning";

	public static final String CP_OPTION_SERVICE_NAME =
		"com.liferay.commerce.product.option";

	public static final String DAILY_SUBSCRIPTION_TYPE = "daily";

	public static final String MONTHLY_SUBSCRIPTION_TYPE = "monthly";

	public static final String[] PRODUCT_OPTION_MULTIPLE_VALUES_FIELD_TYPES = {
		"select", "radio", "checkbox", "checkbox_multiple"
	};

	public static final String[] PRODUCT_OPTION_PRICE_CONTRIBUTOR_FIELD_TYPES =
		{"select", "radio"};

	public static final String PRODUCT_OPTION_PRICE_TYPE_DYNAMIC = "dynamic";

	public static final String PRODUCT_OPTION_PRICE_TYPE_STATIC = "static";

	public static final String[] PRODUCT_OPTION_SKU_CONTRIBUTOR_FIELD_TYPES = {
		"select", "radio"
	};

	public static final String RESOURCE_NAME = "com.liferay.commerce.product";

	public static final String SEPARATOR_ASSET_CATEGORY_URL = "/g/";

	public static final String SEPARATOR_PRODUCT_URL = "/p/";

	public static final String SERVICE_NAME = "com.liferay.commerce.product";

	public static final String SERVICE_NAME_CP_FRIENDLY_URL =
		"com.liferay.commerce.product.friendly.url";

	public static final String WEEKLY_SUBSCRIPTION_TYPE = "weekly";

	public static final String YEARLY_SUBSCRIPTION_TYPE = "yearly";

}