/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.lists.constants;

/**
 * Holds the DDL request attribute keys.
 *
 * @author Rafael Praxedes
 */
public class DDLWebKeys {

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD} is the key to use to retrieve the DDL
	 * Record from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD =
		"DYNAMIC_DATA_LISTS_RECORD";

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD_SET} is the key to use to retrieve the
	 * DDL Record Set from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD_SET =
		"DYNAMIC_DATA_LISTS_RECORD_SET";

	/**
	 * {@value #DYNAMIC_DATA_LISTS_RECORD_VERSION} is the key to use to retrieve
	 * the DDL Record Version from the request attribute.
	 */
	public static final String DYNAMIC_DATA_LISTS_RECORD_VERSION =
		"DYNAMIC_DATA_LISTS_RECORD_VERSION";

}