/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.security.sso.openid.connect.persistence.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OpenIdConnectSession service. Represents a row in the &quot;OpenIdConnectSession&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.portal.security.sso.openid.connect.persistence.model.impl.OpenIdConnectSessionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.portal.security.sso.openid.connect.persistence.model.impl.OpenIdConnectSessionImpl</code>.
 * </p>
 *
 * @author Arthur Chan
 * @see OpenIdConnectSession
 * @generated
 */
@ProviderType
public interface OpenIdConnectSessionModel
	extends BaseModel<OpenIdConnectSession>, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a open ID connect session model instance should use the {@link OpenIdConnectSession} interface instead.
	 */

	/**
	 * Returns the primary key of this open ID connect session.
	 *
	 * @return the primary key of this open ID connect session
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this open ID connect session.
	 *
	 * @param primaryKey the primary key of this open ID connect session
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this open ID connect session.
	 *
	 * @return the mvcc version of this open ID connect session
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this open ID connect session.
	 *
	 * @param mvccVersion the mvcc version of this open ID connect session
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the open ID connect session ID of this open ID connect session.
	 *
	 * @return the open ID connect session ID of this open ID connect session
	 */
	public long getOpenIdConnectSessionId();

	/**
	 * Sets the open ID connect session ID of this open ID connect session.
	 *
	 * @param openIdConnectSessionId the open ID connect session ID of this open ID connect session
	 */
	public void setOpenIdConnectSessionId(long openIdConnectSessionId);

	/**
	 * Returns the company ID of this open ID connect session.
	 *
	 * @return the company ID of this open ID connect session
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this open ID connect session.
	 *
	 * @param companyId the company ID of this open ID connect session
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the modified date of this open ID connect session.
	 *
	 * @return the modified date of this open ID connect session
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this open ID connect session.
	 *
	 * @param modifiedDate the modified date of this open ID connect session
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the access token of this open ID connect session.
	 *
	 * @return the access token of this open ID connect session
	 */
	@AutoEscape
	public String getAccessToken();

	/**
	 * Sets the access token of this open ID connect session.
	 *
	 * @param accessToken the access token of this open ID connect session
	 */
	public void setAccessToken(String accessToken);

	/**
	 * Returns the id token of this open ID connect session.
	 *
	 * @return the id token of this open ID connect session
	 */
	@AutoEscape
	public String getIdToken();

	/**
	 * Sets the id token of this open ID connect session.
	 *
	 * @param idToken the id token of this open ID connect session
	 */
	public void setIdToken(String idToken);

	/**
	 * Returns the provider name of this open ID connect session.
	 *
	 * @return the provider name of this open ID connect session
	 */
	@AutoEscape
	public String getProviderName();

	/**
	 * Sets the provider name of this open ID connect session.
	 *
	 * @param providerName the provider name of this open ID connect session
	 */
	public void setProviderName(String providerName);

	/**
	 * Returns the refresh token of this open ID connect session.
	 *
	 * @return the refresh token of this open ID connect session
	 */
	@AutoEscape
	public String getRefreshToken();

	/**
	 * Sets the refresh token of this open ID connect session.
	 *
	 * @param refreshToken the refresh token of this open ID connect session
	 */
	public void setRefreshToken(String refreshToken);

}