/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@10.1.15/account_selector/AccountSelector.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './AccountSelector.soy', 'frontend-taglib-clay$clay-icon', './OrdersTable.es', './AccountsTable.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.AccountSelector = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

    var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

    var _AccountSelector = _interopRequireDefault(require("./AccountSelector.soy"));

    require("frontend-taglib-clay$clay-icon");

    require("./OrdersTable.es");

    require("./AccountsTable.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var AccountSelector = /*#__PURE__*/function (_Component) {
      _inherits(AccountSelector, _Component);

      function AccountSelector() {
        _classCallCheck(this, AccountSelector);

        return _possibleConstructorReturn(this, _getPrototypeOf(AccountSelector).apply(this, arguments));
      }

      _createClass(AccountSelector, [{
        key: "created",
        value: function created() {
          this._handleClickOutside = this._handleClickOutside.bind(this);
          this._refreshOrderState = this._refreshOrderState.bind(this);
        }
      }, {
        key: "attached",
        value: function attached() {
          window.Liferay.on('orderChanged', this._refreshOrderState, this);
        }
      }, {
        key: "detached",
        value: function detached() {
          window.Liferay.detach('orderChanged', this._refreshOrderState, this);
        }
      }, {
        key: "_refreshOrderState",
        value: function _refreshOrderState(_ref) {
          var _this = this;

          var orderId = _ref.orderId;

          this._getOrders().then(function (orders) {
            _this.orders = orders;

            if (orderId) {
              _this.currentOrder = Array.isArray(_this.orders) ? _this.orders.reduce(function (found, order) {
                return found || (order.id == orderId ? order : null);
              }, null) : orderId;
              _this.currentView = 'orders';
            }
          });
        }
      }, {
        key: "_handleClickOutside",
        value: function _handleClickOutside(e) {
          if (!document.querySelector('#account-manager-curtain').contains(e.target)) {
            this._closeModal();
          }
        }
      }, {
        key: "toggleAccountSelector",
        value: function toggleAccountSelector() {
          if (this.openingState === 'closed') {
            this._openModal();
          }

          if (this.openingState === 'open') {
            this._closeModal();
          }

          return this.openingState;
        }
      }, {
        key: "_openModal",
        value: function _openModal() {
          var _this2 = this;

          if (!this.currentAccount && !this.accounts) {
            this.currentView = 'accounts';

            this._fetchAccounts();
          }

          if (this.currentAccount && !this.orders) {
            this.currentView = 'orders';

            this._getOrders().then(function (orders) {
              _this2.orders = orders;
            });

            this._fetchAccounts();
          }

          this.openingState = 'opening';
          return setTimeout(function () {
            _this2.openingState = 'open';
            window.addEventListener('click', _this2._handleClickOutside);
          }, 200);
        }
      }, {
        key: "_closeModal",
        value: function _closeModal() {
          var _this3 = this;

          this.openingState = 'closing';
          return setTimeout(function () {
            _this3.openingState = 'closed';
            window.removeEventListener('click', _this3._handleClickOutside);
          }, 200);
        }
      }, {
        key: "_handleChangeSelectedView",
        value: function _handleChangeSelectedView(view) {
          if (!this.accounts && view === 'accounts') {
            this._fetchAccounts();
          }

          this.currentView = view;
          return this.currentView;
        }
      }, {
        key: "_handleAccountSelected",
        value: function _handleAccountSelected(selectedAccount) {
          var _this4 = this;

          if (this.currentAccount) {
            if (selectedAccount.accountId === this.currentAccount.accountId) {
              this.currentView = 'orders';
              return this.currentView;
            }

            this.orders = null;
          }

          this.currentAccount = selectedAccount;
          var formData = new FormData();
          formData.append('accountId', this.currentAccount.accountId);
          (0, _frontendJsWeb.fetch)(this.accountsAPI + 'set-current-account' + '?groupId=' + themeDisplay.getScopeGroupId(), {
            body: formData,
            method: 'POST'
          }).then(function () {
            _this4.currentOrder = null;

            _this4.emit('accountSelected', _this4.currentAccount);

            Liferay.fire('accountSelected', _this4.currentAccount);
          });
          this.currentView = 'orders';
          return this._getOrders().then(function (orders) {
            _this4.orders = orders;
          });
        }
      }, {
        key: "_handleGetAccounts",
        value: function _handleGetAccounts() {
          var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

          this._fetchAccounts(query);
        }
      }, {
        key: "_handleOrderSelected",
        value: function _handleOrderSelected(selectedOrder) {
          this.currentOrder = selectedOrder;
          return this.toggleAccountSelector();
        }
      }, {
        key: "_handleGetOrders",
        value: function _handleGetOrders() {
          var _this5 = this;

          var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          return this._getOrders(query).then(function (orders) {
            _this5.orders = orders;
          });
        }
      }, {
        key: "_fetchAccounts",
        value: function _fetchAccounts() {
          var _this6 = this;

          var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          return (0, _frontendJsWeb.fetch)(this.accountsAPI + 'search-accounts' + '?groupId=' + themeDisplay.getScopeGroupId() + '&q=' + query + '&page=1&pageSize=10').then(function (response) {
            return response.json();
          }).then(function (response) {
            _this6.accounts = response.accounts;
            return _this6.accounts;
          });
        }
      }, {
        key: "_getOrders",
        value: function _getOrders() {
          var query = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
          return (0, _frontendJsWeb.fetch)(this.accountsAPI + 'search-accounts/' + this.currentAccount.accountId + '/orders' + '?groupId=' + themeDisplay.getScopeGroupId() + '&q=' + query + '&page=1&pageSize=10').then(function (response) {
            return response.json();
          }).then(function (response) {
            return response.orders;
          });
        }
      }]);

      return AccountSelector;
    }(_metalComponent.default);

    exports.AccountSelector = AccountSelector;

    _metalSoy.default.register(AccountSelector, _AccountSelector.default);

    AccountSelector.STATE = {
      accounts: _metalSoy.Config.arrayOf(_metalSoy.Config.shapeOf({
        accountId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]).required(),
        name: _metalSoy.Config.string(),
        thumbnail: _metalSoy.Config.string()
      })),
      accountsAPI: _metalSoy.Config.string().required(),
      createNewAccountLink: _metalSoy.Config.string(),
      createNewOrderLink: _metalSoy.Config.string(),
      currentAccount: _metalSoy.Config.object(),
      currentOrder: _metalSoy.Config.object(),
      currentView: _metalSoy.Config.oneOf(['accounts', 'orders']).value('accounts'),
      openingState: _metalSoy.Config.oneOf(['closed', 'open', 'closing', 'opening']).value('closed'),
      orders: _metalSoy.Config.arrayOf(_metalSoy.Config.shapeOf({
        addOrderLink: _metalSoy.Config.string(),
        id: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]).required(),
        lastEdit: _metalSoy.Config.string(),
        status: _metalSoy.Config.string()
      })),
      spritemap: _metalSoy.Config.string().required(),
      viewAllAccountsLink: _metalSoy.Config.string().required(),
      viewAllOrdersLink: _metalSoy.Config.string().required()
    };
    var _default = AccountSelector;
    exports.default = _default;
    //# sourceMappingURL=AccountSelector.es.js.map
  }
});
//# sourceMappingURL=AccountSelector.es.js.map