Liferay.Loader.define("data-engine-taglib@2.5.31/data_layout_builder/js/components/field-sets/actions/useSaveFieldSet.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../AppContext.es', '../../../actions.es', '../../../data-layout-builder/DataLayoutBuilderContext.es', '../../../utils/client.es', '../../../utils/dataDefinition.es', '../../../utils/dataLayoutVisitor.es', '../../../utils/toast.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _react = require("frontend-js-react-web$react");

    var _AppContext = _interopRequireDefault(require("../../../AppContext.es"));

    var _actions = require("../../../actions.es");

    var _DataLayoutBuilderContext = _interopRequireDefault(require("../../../data-layout-builder/DataLayoutBuilderContext.es"));

    var _client = require("../../../utils/client.es");

    var _dataDefinition = require("../../../utils/dataDefinition.es");

    var _dataLayoutVisitor = require("../../../utils/dataLayoutVisitor.es");

    var _toast = require("../../../utils/toast.es");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var _default = function _default(_ref) {
      var availableLanguageIds = _ref.availableLanguageIds,
          childrenContext = _ref.childrenContext,
          fieldSet = _ref.fieldSet;

      var _useContext = (0, _react.useContext)(_AppContext.default),
          _useContext2 = _slicedToArray(_useContext, 2),
          context = _useContext2[0],
          dispatch = _useContext2[1];

      var _useContext3 = (0, _react.useContext)(_DataLayoutBuilderContext.default),
          _useContext4 = _slicedToArray(_useContext3, 1),
          dataLayoutBuilder = _useContext4[0];

      var dataDefinition = context.dataDefinition,
          dataLayout = context.dataLayout,
          fieldSets = context.fieldSets;
      var childrenState = childrenContext.state;
      return function (name) {
        var dataDefinitionFields = childrenState.dataDefinition.dataDefinitionFields,
            dataLayoutPages = childrenState.dataLayout.dataLayoutPages;

        var normalizedFieldSet = _objectSpread(_objectSpread({}, fieldSet), {}, {
          availableLanguageIds: availableLanguageIds,
          dataDefinitionFields: dataDefinitionFields,
          defaultDataLayout: _objectSpread(_objectSpread({}, fieldSet.defaultDataLayout), {}, {
            dataLayoutPages: dataLayoutPages
          }),
          name: name
        });

        return (0, _client.updateItem)("/o/data-engine/v2.0/data-definitions/".concat(fieldSet.id), normalizedFieldSet).then(function () {
          var dataDefinitionFieldSet = (0, _dataDefinition.getDataDefinitionFieldSet)(dataDefinition.dataDefinitionFields, fieldSet.id);

          var normalizedDataDefinitionFields = function normalizedDataDefinitionFields() {
            return dataDefinition.dataDefinitionFields.map(function (field) {
              var ddmStructureId = field.customProperties.ddmStructureId;

              if (ddmStructureId == fieldSet.id) {
                return _objectSpread(_objectSpread({}, field), {}, {
                  nestedDataDefinitionFields: dataDefinitionFields
                });
              }

              return field;
            });
          };

          if (dataDefinitionFieldSet) {
            var fieldName = dataDefinitionFieldSet.name;

            if ((0, _dataLayoutVisitor.containsField)(dataLayout.dataLayoutPages, fieldName)) {
              dataLayoutBuilder.dispatch('fieldEditedProperties', {
                defaultLanguageId: fieldSet.defaultLanguageId,
                fieldName: fieldName,
                properties: [{
                  name: 'nestedFields',
                  value: dataDefinitionFields.map(function (_ref2) {
                    var name = _ref2.name;
                    return dataLayoutBuilder.getDDMFormField(childrenState.dataDefinition, name);
                  })
                }, {
                  name: 'rows',
                  value: (0, _dataLayoutVisitor.normalizeDataLayoutRows)(dataLayoutPages)
                }]
              });
            } else {
              dispatch({
                payload: {
                  dataDefinition: _objectSpread(_objectSpread({}, dataDefinition), {}, {
                    dataDefinitionFields: normalizedDataDefinitionFields()
                  })
                },
                type: _actions.UPDATE_DATA_DEFINITION
              });
            }
          }

          return Promise.resolve();
        }).then(function () {
          dispatch({
            payload: {
              fieldSets: fieldSets.map(function (field) {
                if (fieldSet.id === field.id) {
                  return normalizedFieldSet;
                }

                return field;
              })
            },
            type: _actions.UPDATE_FIELDSETS
          });
          (0, _toast.successToast)(Liferay.Language.get('fieldset-saved'));
          return Promise.resolve();
        }).catch(function (_ref3) {
          var message = _ref3.message;
          return (0, _toast.errorToast)(message);
        });
      };
    };

    exports.default = _default;
    //# sourceMappingURL=useSaveFieldSet.es.js.map
  }
});
//# sourceMappingURL=useSaveFieldSet.es.js.map