Liferay.Loader.define("data-engine-taglib@2.5.31/data_layout_builder/js/components/field-types/FieldTypeList.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../collapsable-panel/CollapsablePanel.es', '../empty-state/EmptyState.es', './FieldType.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _CollapsablePanel = _interopRequireDefault(require("../collapsable-panel/CollapsablePanel.es"));

    var _EmptyState = _interopRequireDefault(require("../empty-state/EmptyState.es"));

    var _FieldType = _interopRequireDefault(require("./FieldType.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    var FieldTypeWrapper = function FieldTypeWrapper(_ref) {
      var expanded = _ref.expanded,
          fieldType = _ref.fieldType,
          showArrows = _ref.showArrows,
          otherProps = _objectWithoutProperties(_ref, ["expanded", "fieldType", "showArrows"]);

      return (/*#__PURE__*/_react.default.createElement(_FieldType.default, _extends({}, otherProps, fieldType, {
          icon: function getIcon() {
            if (showArrows) {
              return expanded ? 'angle-down' : 'angle-right';
            }

            return fieldType.icon;
          }()
        }))
      );
    };

    var _default = function _default(_ref2) {
      var deleteLabel = _ref2.deleteLabel,
          emptyState = _ref2.emptyState,
          fieldTypes = _ref2.fieldTypes,
          keywords = _ref2.keywords,
          onClick = _ref2.onClick,
          onDelete = _ref2.onDelete,
          onDoubleClick = _ref2.onDoubleClick,
          _ref2$showEmptyState = _ref2.showEmptyState,
          showEmptyState = _ref2$showEmptyState === void 0 ? true : _ref2$showEmptyState;
      var regex = new RegExp(keywords, 'ig');
      var filteredFieldTypes = fieldTypes.filter(function (_ref3) {
        var system = _ref3.system;
        return !system;
      }).filter(function (_ref4) {
        var description = _ref4.description,
            label = _ref4.label;

        if (!keywords) {
          return true;
        }

        return regex.test(description) || regex.test(label);
      });

      if (showEmptyState && !filteredFieldTypes.length) {
        return (/*#__PURE__*/_react.default.createElement(_EmptyState.default, {
            emptyState: emptyState,
            keywords: keywords,
            small: true
          })
        );
      }

      return filteredFieldTypes.map(function (fieldType, index) {
        var isFieldSet = fieldType.isFieldSet,
            _fieldType$nestedData = fieldType.nestedDataDefinitionFields,
            nestedDataDefinitionFields = _fieldType$nestedData === void 0 ? [] : _fieldType$nestedData;

        var handleOnClick = function handleOnClick(props) {
          if (fieldType.disabled || !onClick) {
            return;
          }

          onClick(props);
        };

        if (nestedDataDefinitionFields.length) {
          var Header = function Header(_ref5) {
            var expanded = _ref5.expanded,
                setExpanded = _ref5.setExpanded;
            return (/*#__PURE__*/_react.default.createElement(FieldTypeWrapper, {
                deleteLabel: deleteLabel,
                expanded: expanded,
                fieldType: _objectSpread(_objectSpread({}, fieldType), {}, {
                  className: "".concat(fieldType.className, " field-type-header")
                }),
                onClick: function onClick(props) {
                  setExpanded(!expanded);
                  handleOnClick(props);
                },
                onDelete: onDelete,
                onDoubleClick: onDoubleClick,
                setExpanded: setExpanded,
                showArrows: true
              })
            );
          };

          return (/*#__PURE__*/_react.default.createElement("div", {
              className: "field-type-list",
              key: index
            }, /*#__PURE__*/_react.default.createElement(_CollapsablePanel.default, {
              Header: Header,
              className: (0, _classnames.default)({
                'field-type-fieldgroup': !isFieldSet,
                'field-type-fieldset': isFieldSet
              })
            }, /*#__PURE__*/_react.default.createElement("div", {
              className: "field-type-item position-relative"
            }, nestedDataDefinitionFields.map(function (nestedFieldType) {
              return (/*#__PURE__*/_react.default.createElement(FieldTypeWrapper, {
                  draggable: false,
                  fieldType: _objectSpread(_objectSpread({}, nestedFieldType), {}, {
                    disabled: fieldType.disabled
                  }),
                  key: "".concat(nestedFieldType.name, "_").concat(index)
                })
              );
            }))))
          );
        }

        return (/*#__PURE__*/_react.default.createElement(FieldTypeWrapper, {
            deleteLabel: deleteLabel,
            fieldType: fieldType,
            key: index,
            onClick: handleOnClick,
            onDelete: onDelete,
            onDoubleClick: onDoubleClick
          })
        );
      });
    };

    exports.default = _default;
    //# sourceMappingURL=FieldTypeList.es.js.map
  }
});
//# sourceMappingURL=FieldTypeList.es.js.map