Liferay.Loader.define("data-engine-taglib@2.5.31/data_layout_builder/js/utils/dataDefinition.es", ['module', 'exports', 'require', './lang.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getOptionLabel = exports.getFieldLabel = exports.getDataDefinitionFieldSet = exports.getDataDefinitionField = exports.containsFieldSet = exports.forEachDataDefinitionField = void 0;

    var _lang = require("./lang.es");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var forEachDataDefinitionField = function forEachDataDefinitionField() {
      var dataDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        dataDefinitionFields: []
      };
      var fn = arguments.length > 1 ? arguments[1] : undefined;
      var _dataDefinition$dataD = dataDefinition.dataDefinitionFields,
          dataDefinitionFields = _dataDefinition$dataD === void 0 ? [] : _dataDefinition$dataD;

      for (var i = 0; i < dataDefinitionFields.length; i++) {
        var field = dataDefinitionFields[i];

        if (fn(field)) {
          return true;
        }

        if (forEachDataDefinitionField({
          dataDefinitionFields: field.nestedDataDefinitionFields || []
        }, fn)) {
          return true;
        }
      }

      return false;
    };

    exports.forEachDataDefinitionField = forEachDataDefinitionField;

    var containsFieldSet = function containsFieldSet(dataDefinition, dataDefinitionId) {
      var hasFieldSet = false;
      forEachDataDefinitionField(dataDefinition, function (dataDefinitionField) {
        var customProperties = dataDefinitionField.customProperties,
            fieldType = dataDefinitionField.fieldType;

        if (fieldType === 'fieldset' && customProperties && customProperties.ddmStructureId == dataDefinitionId) {
          hasFieldSet = true;
        }

        return hasFieldSet;
      });
      return hasFieldSet;
    };

    exports.containsFieldSet = containsFieldSet;

    var getDataDefinitionField = function getDataDefinitionField() {
      var dataDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
        dataDefinitionFields: []
      };
      var fieldName = arguments.length > 1 ? arguments[1] : undefined;
      var field = null;
      forEachDataDefinitionField(dataDefinition, function (currentField) {
        if (currentField.name === fieldName) {
          field = currentField;
          return true;
        }

        return false;
      });
      return field;
    };

    exports.getDataDefinitionField = getDataDefinitionField;

    var getDataDefinitionFieldSet = function getDataDefinitionFieldSet(dataDefinitionFields, fieldSetId) {
      return dataDefinitionFields.find(function (_ref) {
        var ddmStructureId = _ref.customProperties.ddmStructureId;
        return ddmStructureId == fieldSetId;
      });
    };

    exports.getDataDefinitionFieldSet = getDataDefinitionFieldSet;

    var getFieldLabel = function getFieldLabel(dataDefinition, fieldName) {
      var field = getDataDefinitionField(dataDefinition, fieldName);

      if (field) {
        return (0, _lang.getLocalizedValue)(dataDefinition.defaultLanguageId, field.label);
      }

      return fieldName;
    };

    exports.getFieldLabel = getFieldLabel;

    var getOptionLabel = function getOptionLabel() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var value = arguments.length > 1 ? arguments[1] : undefined;
      var defaultLanguageId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : themeDisplay.getDefaultLanguageId();
      var languageId = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : themeDisplay.getLanguageId();

      var getLabel = function getLabel(languageId) {
        if (options[languageId]) {
          var _options$languageId$f;

          return (_options$languageId$f = options[languageId].find(function (option) {
            return option.value === value;
          })) === null || _options$languageId$f === void 0 ? void 0 : _options$languageId$f.label;
        }
      };

      return getLabel(languageId) || getLabel(defaultLanguageId) || value;
    };

    exports.getOptionLabel = getOptionLabel;
    //# sourceMappingURL=dataDefinition.es.js.map
  }
});
//# sourceMappingURL=dataDefinition.es.js.map