Liferay.Loader.define("data-engine-taglib@2.5.31/data_layout_builder/js/utils/settingsForm.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getFilteredSettingsContext = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var getPredefinedValues = function getPredefinedValues(_ref) {
      var locale = _ref.locale,
          localizedValue = _ref.localizedValue,
          options = _ref.options;

      if (Array.isArray(localizedValue[locale])) {
        return localizedValue[locale].filter(function (value) {
          if (options.find(function (option) {
            return value === option.value;
          })) {
            return value;
          }
        });
      }

      return localizedValue[locale];
    };

    var getFilteredSettingsContext = function getFilteredSettingsContext(_ref2) {
      var config = _ref2.config,
          editingLanguageId = _ref2.editingLanguageId,
          fieldType = _ref2.fieldType,
          settingsContext = _ref2.settingsContext;
      var defaultLanguageId = themeDisplay.getDefaultLanguageId();

      var unsupportedTabs = _toConsumableArray(config.disabledTabs);

      var pages = settingsContext.pages.filter(function (page) {
        return !unsupportedTabs.includes(page.title);
      });
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(pages);
      var unsupportedRepeatableFieldset = fieldType === 'fieldset' ? ['repeatable'] : [];
      var unsupportedProperties = [].concat(_toConsumableArray(config.unimplementedProperties), _toConsumableArray(config.disabledProperties), unsupportedRepeatableFieldset);
      return _objectSpread(_objectSpread({}, settingsContext), {}, {
        pages: visitor.mapColumns(function (column) {
          return _objectSpread(_objectSpread({}, column), {}, {
            fields: column.fields.map(function (field) {
              var fieldName = field.fieldName,
                  name = field.name;

              var updatedField = _objectSpread(_objectSpread({}, field), {}, {
                defaultLanguageId: defaultLanguageId,
                editingLanguageId: editingLanguageId
              });

              if (unsupportedProperties.includes(fieldName)) {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  visibilityExpression: 'FALSE',
                  visible: false
                });
              }

              if (fieldName === 'dataSourceType') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  predefinedValue: '["manual"]',
                  readOnly: true,
                  visible: false
                });
              }

              if (fieldName === 'name') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  readOnly: true
                });
              }

              if (fieldName === 'predefinedValue') {
                field.localizedValue[field.locale] = getPredefinedValues(field);
              }

              if (fieldName === 'repeatable') {
                return _objectSpread(_objectSpread({}, updatedField), {}, {
                  name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField),
                  showMaximumRepetitionsInfo: false
                });
              }

              return _objectSpread(_objectSpread({}, updatedField), {}, {
                name: (0, _dynamicDataMappingFormRenderer.generateName)(name, updatedField)
              });
            })
          });
        })
      });
    };

    exports.getFilteredSettingsContext = getFilteredSettingsContext;
    //# sourceMappingURL=settingsForm.es.js.map
  }
});
//# sourceMappingURL=settingsForm.es.js.map