Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/ActionsDropdownRenderer", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/link', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-web', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../DataSetDisplayContext', '../utilities/actionItems/constants', '../utilities/index', '../utilities/modals/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.isLink = isLink;
    exports.handleAction = handleAction;
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataSetDisplayContext = _interopRequireDefault(require("../DataSetDisplayContext"));

    var _constants = require("../utilities/actionItems/constants");

    var _index = require("../utilities/index");

    var _index2 = require("../utilities/modals/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var MODAL_PERMISSIONS = _constants.ACTION_ITEM_TARGETS.MODAL_PERMISSIONS;

    function isLink(target, onClick) {
      return !(target && target !== 'link') && !onClick;
    }

    function handleAction(_ref, _ref2) {
      var event = _ref.event,
          _ref$itemId = _ref.itemId,
          itemId = _ref$itemId === void 0 ? '' : _ref$itemId,
          method = _ref.method,
          _ref$onClick = _ref.onClick,
          onClick = _ref$onClick === void 0 ? '' : _ref$onClick,
          _ref$setLoading = _ref.setLoading,
          setLoading = _ref$setLoading === void 0 ? function () {} : _ref$setLoading,
          _ref$size = _ref.size,
          size = _ref$size === void 0 ? '' : _ref$size,
          _ref$target = _ref.target,
          target = _ref$target === void 0 ? '' : _ref$target,
          _ref$title = _ref.title,
          title = _ref$title === void 0 ? '' : _ref$title,
          successMessage = _ref.successMessage,
          _ref$url = _ref.url,
          url = _ref$url === void 0 ? '' : _ref$url;
      var executeAsyncItemAction = _ref2.executeAsyncItemAction,
          highlightItems = _ref2.highlightItems,
          openModal = _ref2.openModal,
          openSidePanel = _ref2.openSidePanel;

      if (target === null || target === void 0 ? void 0 : target.includes('modal')) {
        event.preventDefault();

        if (target === MODAL_PERMISSIONS) {
          (0, _index2.openPermissionsModal)(url);
        } else {
          openModal({
            size: (0, _index2.resolveModalSize)(target),
            title: title,
            url: url
          });
        }
      } else if (target === 'sidePanel') {
        event.preventDefault();
        highlightItems([itemId]);
        openSidePanel({
          size: size || 'lg',
          title: title,
          url: url
        });
      } else if (target === 'async' || target === 'headless') {
        event.preventDefault();
        setLoading(true);
        executeAsyncItemAction(url, method).then(function () {
          (0, _frontendJsWeb.openToast)({
            message: successMessage || Liferay.Language.get('action-completed'),
            type: 'success'
          });
          setLoading(false);
        }).catch(function (_) {
          setLoading(false);
        });
      } else if (target === 'blank') {
        event.preventDefault();
        window.open(url);
      } else if (onClick) {
        event.preventDefault();
        event.target.setAttribute('onClick', onClick);
        event.target.onclick();
        event.target.removeAttribute('onClick');
      }
    }

    function ActionItem(_ref3) {
      var closeMenu = _ref3.closeMenu,
          data = _ref3.data,
          handleAction = _ref3.handleAction,
          href = _ref3.href,
          icon = _ref3.icon,
          label = _ref3.label,
          method = _ref3.method,
          onClick = _ref3.onClick,
          size = _ref3.size,
          target = _ref3.target,
          title = _ref3.title;
      var context = (0, _react.useContext)(_DataSetDisplayContext.default);

      var link = isLink(target, onClick);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          href: link ? href : null,
          onClick: link ? null : function handleClickOnLink(event) {
            event.preventDefault();
            handleAction({
              event: event,
              method: method,
              onClick: onClick,
              size: size || 'lg',
              successMessage: data === null || data === void 0 ? void 0 : data.successMessage,
              target: target,
              title: title,
              url: href
            }, context);
            closeMenu();
          }
        }, icon && /*#__PURE__*/_react.default.createElement("span", {
          className: "pr-2"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: icon
        })), label)
      );
    }

    function ActionsDropdownRenderer(_ref4) {
      var actions = _ref4.actions,
          itemData = _ref4.itemData,
          itemId = _ref4.itemId;
      var context = (0, _react.useContext)(_DataSetDisplayContext.default);

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          loading = _useState4[0],
          setLoading = _useState4[1];

      var formattedActions = actions ? actions.reduce(function (actions, action) {
        var _action$data;

        if ((_action$data = action.data) === null || _action$data === void 0 ? void 0 : _action$data.permissionKey) {
          if (itemData.actions[action.data.permissionKey]) {
            if (action.target === 'headless') {
              return [].concat(_toConsumableArray(actions), [_objectSpread(_objectSpread({}, action), itemData.actions[action.data.permissionKey])]);
            } else {
              return [].concat(_toConsumableArray(actions), [action]);
            }
          }

          return actions;
        }

        return [].concat(_toConsumableArray(actions), [action]);
      }, []) : [];

      if (!formattedActions || !formattedActions.length) {
        return null;
      }

      if (formattedActions.length === 1) {
        var _formattedActions = _slicedToArray(formattedActions, 1),
            action = _formattedActions[0];

        var actionData = action.data;

        if ((actionData === null || actionData === void 0 ? void 0 : actionData.id) && !(action === null || action === void 0 ? void 0 : action.href)) {
          return null;
        }

        if (loading) {
          return (/*#__PURE__*/_react.default.createElement(_button.default, {
              className: "btn-sm",
              disabled: true,
              monospaced: true
            }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, {
              small: true
            }))
          );
        }

        var content = action.icon ? /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: action.icon
        }) : action.label;
        return isLink(action.target, action.onClick) ? /*#__PURE__*/_react.default.createElement(_link.default, {
          className: "btn btn-secondary btn-sm",
          href: (0, _index.formatActionURL)(action.href, itemData),
          monospaced: Boolean(action.icon)
        }, content) : /*#__PURE__*/_react.default.createElement(_link.default, {
          className: "btn btn-secondary btn-sm",
          "data-senna-off": true,
          href: "#",
          monospaced: Boolean(action.icon),
          onClick: function onClick(event) {
            var _action$method;

            handleAction(_objectSpread({
              event: event,
              itemId: itemId,
              method: (_action$method = action.method) !== null && _action$method !== void 0 ? _action$method : actionData === null || actionData === void 0 ? void 0 : actionData.method,
              setLoading: setLoading,
              successMessage: actionData === null || actionData === void 0 ? void 0 : actionData.successMessage,
              url: (0, _index.formatActionURL)(action.href, itemData)
            }, action), context);
          }
        }, content);
      }

      if (loading) {
        return (/*#__PURE__*/_react.default.createElement(_button.default, {
            className: "btn-sm",
            disabled: true,
            displayType: "secondary",
            monospaced: true
          }, /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, {
            small: true
          }))
        );
      }

      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          onActiveChange: setActive,
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            className: "component-action dropdown-toggle",
            displayType: "unstyled"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "ellipsis-v"
          }))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, function renderItems(items) {
          return items.map(function (_ref5, i) {
            var _item$method, _item$data;

            var _ref5$items = _ref5.items,
                nestedItems = _ref5$items === void 0 ? [] : _ref5$items,
                separator = _ref5.separator,
                type = _ref5.type,
                item = _objectWithoutProperties(_ref5, ["items", "separator", "type"]);

            if (type === 'group') {
              return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Group, item, separator && /*#__PURE__*/_react.default.createElement(_dropDown.default.Divider, null), renderItems(nestedItems))
              );
            }

            return (/*#__PURE__*/_react.default.createElement(ActionItem, _extends({}, item, {
                closeMenu: function closeMenu() {
                  return setActive(false);
                },
                handleAction: handleAction,
                href: item.href && (0, _index.formatActionURL)(item.href, itemData),
                key: i,
                method: (_item$method = item.method) !== null && _item$method !== void 0 ? _item$method : (_item$data = item.data) === null || _item$data === void 0 ? void 0 : _item$data.method
              }))
            );
          });
        }(formattedActions)))
      );
    }

    var _default = ActionsDropdownRenderer;
    exports.default = _default;
    //# sourceMappingURL=ActionsDropdownRenderer.js.map
  }
});
//# sourceMappingURL=ActionsDropdownRenderer.js.map