Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/DefaultRenderer", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../utilities/logError', './TooltipTextRenderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _logError = require("../utilities/logError");

    var _TooltipTextRenderer = _interopRequireDefault(require("./TooltipTextRenderer"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function DefaultRenderer(_ref) {
      var value = _ref.value;

      if (typeof value === 'number' || typeof value === 'string' || value === undefined || value === null) {
        return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value !== null && value !== void 0 ? value : '')
        );
      } else if (value.icon) {
        return (/*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: value.icon
          })
        );
      } else if (!!value.iconSymbol && !!value.text) {
        return (/*#__PURE__*/_react.default.createElement(_TooltipTextRenderer.default, {
            value: value
          })
        );
      } else if (value.label) {
        return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.label)
        );
      }

      (0, _logError.logError)("The object ".concat(JSON.stringify(value), " doesn't match the template schema"));
      return null;
    }

    var _default = DefaultRenderer;
    exports.default = _default;
    //# sourceMappingURL=DefaultRenderer.js.map
  }
});
//# sourceMappingURL=DefaultRenderer.js.map