Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/ListRenderer", ['module', 'exports', 'require', 'frontend-taglib-clay$prop-types', '../utilities/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _index = require("../utilities/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function ListRenderer(props) {
      if (!props.value || props.value.length === 0) {
        return null;
      }

      if (props.options.singleItemLabel && props.value.length === 1) {
        return props.options.singleItemLabel;
      }

      if (props.options.multipleItemsLabel && props.value.length > 1) {
        return props.options.multipleItemsLabel;
      }

      return props.value.map(function (el) {
        return (0, _index.getValueFromItem)(el, props.options.labelKey);
      }).join(props.options.separator || ', ');
    }

    ListRenderer.propTypes = {
      options: _propTypes.default.shape({
        labelKey: _propTypes.default.oneOfType([_propTypes.default.array, _propTypes.default.string]).isRequired,
        multipleItemsLabel: _propTypes.default.string,
        separator: _propTypes.default.string,
        singleItemLabel: _propTypes.default.string
      }),
      value: _propTypes.default.array
    };
    var _default = ListRenderer;
    exports.default = _default;
    //# sourceMappingURL=ListRenderer.js.map
  }
});
//# sourceMappingURL=ListRenderer.js.map