Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/TooltipPriceRenderer", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function TooltipTable(_ref) {
      var value = _ref.value;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "bg-dark"
        }, /*#__PURE__*/_react.default.createElement("table", {
          className: "tooltip-table"
        }, /*#__PURE__*/_react.default.createElement("tbody", null, value.details.map(function (detail, i) {
          return (/*#__PURE__*/_react.default.createElement("tr", {
              key: i
            }, /*#__PURE__*/_react.default.createElement("td", {
              className: "table-column-text-start"
            }, detail.label), /*#__PURE__*/_react.default.createElement("td", {
              className: "table-column-text-end"
            }, Array.isArray(detail.value) ? detail.value.join(' | ') : detail.value))
          );
        }), /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", {
          className: "table-column-text-start"
        }, value.final.label || Liferay.Language.get('final-price')), /*#__PURE__*/_react.default.createElement("td", {
          className: "table-column-text-end"
        }, value.final.value)))))
      );
    }

    function TooltipPriceRenderer(_ref2) {
      var value = _ref2.value;

      if (!value) {
        return null;
      }

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value.final.value, value.details && /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, {
          contentRenderer: function contentRenderer() {
            return (/*#__PURE__*/_react.default.createElement(TooltipTable, {
                value: value
              })
            );
          },
          delay: 0
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "tooltip-provider",
          title: Liferay.Language.get('price-summary')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "info-circle"
        }))))
      );
    }

    var _default = TooltipPriceRenderer;
    exports.default = _default;
    //# sourceMappingURL=TooltipPriceRenderer.js.map
  }
});
//# sourceMappingURL=TooltipPriceRenderer.js.map