Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/TooltipTextRenderer", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function TooltipText(_ref) {
      var text = _ref.text;
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "bg-dark"
        }, /*#__PURE__*/_react.default.createElement("p", null, text))
      );
    }

    function TooltipTextRenderer(_ref2) {
      var value = _ref2.value;
      var iconSymbol = value.iconSymbol,
          text = value.text;
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, {
          contentRenderer: function contentRenderer() {
            return (/*#__PURE__*/_react.default.createElement(TooltipText, {
                text: text
              })
            );
          },
          delay: 0
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "tooltip-provider"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: iconSymbol
        }))))
      );
    }

    TooltipTextRenderer.defaultProps = {
      value: {
        iconSymbol: 'info-circle',
        text: 'This is a sample text'
      }
    };
    var _default = TooltipTextRenderer;
    exports.default = _default;
    //# sourceMappingURL=TooltipTextRenderer.js.map
  }
});
//# sourceMappingURL=TooltipTextRenderer.js.map