Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/data_renderers/index", ['module', 'exports', 'require', '../utilities/modules', './ActionLinkRenderer', './ActionsDropdownRenderer', './BooleanRenderer', './CheckboxRenderer', './DateRenderer', './DefaultRenderer', './ImageRenderer', './LabelRenderer', './LinkRenderer', './ListRenderer', './QuantitySelectorRenderer', './StatusRenderer', './TooltipPriceRenderer'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getDataRendererById = getDataRendererById;
    exports.getDataRendererByURL = getDataRendererByURL;
    exports.fetchedContentRenderers = void 0;

    var _modules = _interopRequireDefault(require("../utilities/modules"));

    var _ActionLinkRenderer = _interopRequireDefault(require("./ActionLinkRenderer"));

    var _ActionsDropdownRenderer = _interopRequireDefault(require("./ActionsDropdownRenderer"));

    var _BooleanRenderer = _interopRequireDefault(require("./BooleanRenderer"));

    var _CheckboxRenderer = _interopRequireDefault(require("./CheckboxRenderer"));

    var _DateRenderer = _interopRequireDefault(require("./DateRenderer"));

    var _DefaultRenderer = _interopRequireDefault(require("./DefaultRenderer"));

    var _ImageRenderer = _interopRequireDefault(require("./ImageRenderer"));

    var _LabelRenderer = _interopRequireDefault(require("./LabelRenderer"));

    var _LinkRenderer = _interopRequireDefault(require("./LinkRenderer"));

    var _ListRenderer = _interopRequireDefault(require("./ListRenderer"));

    var _QuantitySelectorRenderer = _interopRequireDefault(require("./QuantitySelectorRenderer"));

    var _StatusRenderer = _interopRequireDefault(require("./StatusRenderer"));

    var _TooltipPriceRenderer = _interopRequireDefault(require("./TooltipPriceRenderer"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var dataRenderers = {
      actionLink: _ActionLinkRenderer.default,
      actionsDropdown: _ActionsDropdownRenderer.default,
      boolean: _BooleanRenderer.default,
      checkbox: _CheckboxRenderer.default,
      date: _DateRenderer.default,
      default: _DefaultRenderer.default,
      image: _ImageRenderer.default,
      label: _LabelRenderer.default,
      link: _LinkRenderer.default,
      list: _ListRenderer.default,
      quantitySelector: _QuantitySelectorRenderer.default,
      status: _StatusRenderer.default,
      tooltipPrice: _TooltipPriceRenderer.default
    };

    function getDataRendererById(id) {
      return dataRenderers[id] || _DefaultRenderer.default;
    }

    var fetchedContentRenderers = [];
    exports.fetchedContentRenderers = fetchedContentRenderers;

    function getDataRendererByURL(url) {
      return new Promise(function (resolve, reject) {
        var addedDataRenderer = fetchedContentRenderers.find(function (cr) {
          return cr.url === url;
        });

        if (addedDataRenderer) {
          resolve(addedDataRenderer.component);
        }

        return (0, _modules.default)(url).then(function (fetchedComponent) {
          fetchedContentRenderers.push({
            component: fetchedComponent,
            url: url
          });
          return resolve(fetchedComponent);
        }).catch(reject);
      });
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map