Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/management_bar/components/BulkActions", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/link', 'frontend-taglib-clay$classnames', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../DataSetDisplayContext', '../../utilities/eventsDefinitions', '../../utilities/logError', '../../utilities/sidePanels'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

    var _classnames = _interopRequireDefault(require("frontend-taglib-clay$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataSetDisplayContext = _interopRequireDefault(require("../../DataSetDisplayContext"));

    var _eventsDefinitions = require("../../utilities/eventsDefinitions");

    var _logError = require("../../utilities/logError");

    var _sidePanels = require("../../utilities/sidePanels");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function submit(_ref) {
      var action = _ref.action,
          data = _ref.data,
          formId = _ref.formId,
          formRef = _ref.formRef;
      var form = formRef.current;

      if (!form && formId) {
        form = document.getElementById(formId);
      }

      if (form) {
        Liferay.Util.postForm(form, {
          data: data,
          url: action || form.action
        });
      } else {
        (0, _logError.logError)("Form not found.");
      }
    }

    function getQueryString(key) {
      var values = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
      return "?".concat(key, "=").concat(values.join(','));
    }

    function getRichPayload(payload, key) {
      var values = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

      var richPayload = _objectSpread(_objectSpread({}, payload), {}, {
        url: payload.baseURL + getQueryString(key, values)
      });

      return richPayload;
    }

    function BulkActions(_ref2) {
      var bulkActions = _ref2.bulkActions,
          fluid = _ref2.fluid,
          selectAllItems = _ref2.selectAllItems,
          selectedItemsKey = _ref2.selectedItemsKey,
          selectedItemsValue = _ref2.selectedItemsValue,
          total = _ref2.total;

      var _useContext = (0, _react.useContext)(_DataSetDisplayContext.default),
          actionParameterName = _useContext.actionParameterName;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          currentSidePanelActionPayload = _useState2[0],
          setCurrentSidePanelActionPayload = _useState2[1];

      function handleActionClick(actionDefinition, formId, formRef, loadData, sidePanelId) {
        var data = actionDefinition.data,
            href = actionDefinition.href,
            slug = actionDefinition.slug,
            target = actionDefinition.target;

        if (target === 'sidePanel') {
          var sidePanelActionPayload = {
            baseURL: href,
            id: sidePanelId,
            onAfterSubmit: function onAfterSubmit() {
              return loadData();
            },
            slug: slug !== null && slug !== void 0 ? slug : null
          };
          Liferay.fire(_eventsDefinitions.OPEN_SIDE_PANEL, getRichPayload(sidePanelActionPayload, selectedItemsKey, selectedItemsValue));
          setCurrentSidePanelActionPayload(sidePanelActionPayload);
        } else {
          submit({
            action: href,
            data: _objectSpread(_objectSpread({}, data), {}, _defineProperty({}, "".concat(actionParameterName || selectedItemsKey), selectedItemsValue.join(','))),
            formId: formId,
            formRef: formRef
          });
        }
      }

      (0, _react.useEffect)(function () {
        if (!currentSidePanelActionPayload) {
          return;
        }

        var currentOpenedSidePanel = (0, _sidePanels.getOpenedSidePanel)();

        if ((currentOpenedSidePanel === null || currentOpenedSidePanel === void 0 ? void 0 : currentOpenedSidePanel.id) === currentSidePanelActionPayload.id && currentOpenedSidePanel.url.indexOf(currentSidePanelActionPayload.baseURL) > -1) {
          Liferay.fire(_eventsDefinitions.OPEN_SIDE_PANEL, getRichPayload(currentSidePanelActionPayload, selectedItemsValue));
        }
      }, // eslint-disable-next-line react-hooks/exhaustive-deps
      [selectedItemsValue]);
      return selectedItemsValue.length ? /*#__PURE__*/_react.default.createElement(_DataSetDisplayContext.default.Consumer, null, function (_ref3) {
        var formId = _ref3.formId,
            formRef = _ref3.formRef,
            loadData = _ref3.loadData,
            sidePanelId = _ref3.sidePanelId;
        return (/*#__PURE__*/_react.default.createElement("nav", {
            className: "management-bar management-bar-primary navbar navbar-expand-md pb-2 pt-2 subnav-tbar"
          }, /*#__PURE__*/_react.default.createElement("div", {
            className: (0, _classnames.default)('container-fluid container-fluid-max-xl py-1', !fluid && 'px-0')
          }, /*#__PURE__*/_react.default.createElement("ul", {
            className: "navbar-nav"
          }, /*#__PURE__*/_react.default.createElement("li", {
            className: "nav-item"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "text-truncate"
          }, selectedItemsValue.length, ' ', Liferay.Language.get('of'), " ", total, ' ', Liferay.Language.get('items-selected')), /*#__PURE__*/_react.default.createElement(_link.default, {
            className: "ml-3",
            href: "#",
            onClick: function onClick(event) {
              event.preventDefault();
              selectAllItems();
            }
          }, Liferay.Language.get('select-all')))), /*#__PURE__*/_react.default.createElement("div", {
            className: "bulk-actions"
          }, bulkActions.map(function (actionDefinition, i) {
            return (/*#__PURE__*/_react.default.createElement("button", {
                className: (0, _classnames.default)('btn btn-monospaced btn-link', i > 0 && 'ml-1'),
                key: actionDefinition.label,
                onClick: function onClick() {
                  return handleActionClick(actionDefinition, formId, formRef, loadData, sidePanelId);
                },
                type: "button"
              }, /*#__PURE__*/_react.default.createElement(_icon.default, {
                symbol: actionDefinition.icon
              }))
            );
          }))))
        );
      }) : null;
    }

    var _default = BulkActions;
    exports.default = _default;
    //# sourceMappingURL=BulkActions.js.map
  }
});
//# sourceMappingURL=BulkActions.js.map