Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/quantity_selector/QuantitySelector", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-taglib-clay$classnames', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _classnames = _interopRequireDefault(require("frontend-taglib-clay$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function QuantitySelector(_ref) {
      var allowedQuantities = _ref.allowedQuantities,
          appendedIcon = _ref.appendedIcon,
          appendedText = _ref.appendedText,
          disabled = _ref.disabled,
          inputName = _ref.inputName,
          maxQuantity = _ref.maxQuantity,
          minQuantity = _ref.minQuantity,
          multipleQuantity = _ref.multipleQuantity,
          prependedIcon = _ref.prependedIcon,
          prependedText = _ref.prependedText,
          quantity = _ref.quantity,
          size = _ref.size,
          style = _ref.style,
          updateQuantity = _ref.updateQuantity;

      var _useState = (0, _react.useState)(quantity),
          _useState2 = _slicedToArray(_useState, 2),
          currentQuantity = _useState2[0],
          setCurrentQuantity = _useState2[1];

      var _useState3 = (0, _react.useState)(currentQuantity + multipleQuantity <= maxQuantity),
          _useState4 = _slicedToArray(_useState3, 2),
          nextAvailable = _useState4[0],
          setNextAvailable = _useState4[1];

      var _useState5 = (0, _react.useState)(currentQuantity - multipleQuantity >= minQuantity),
          _useState6 = _slicedToArray(_useState5, 2),
          prevAvailable = _useState6[0],
          setPrevAvailable = _useState6[1];

      (0, _react.useEffect)(function () {
        setCurrentQuantity(quantity);
      }, [quantity, setCurrentQuantity]);
      (0, _react.useEffect)(function () {
        if (updateQuantity) {
          updateQuantity(currentQuantity);
        }
      }, [currentQuantity, updateQuantity]);
      (0, _react.useEffect)(function () {
        setNextAvailable(currentQuantity + multipleQuantity <= maxQuantity);
        setPrevAvailable(currentQuantity - multipleQuantity >= minQuantity);
      }, [currentQuantity, maxQuantity, minQuantity, multipleQuantity]);

      function updateCurrentQuantity(newQuantity) {
        if (newQuantity >= minQuantity && newQuantity <= maxQuantity && newQuantity % multipleQuantity === 0) {
          setCurrentQuantity(newQuantity);
        }
      }

      function increaseQuantity() {
        if (nextAvailable) {
          setCurrentQuantity(currentQuantity + multipleQuantity);
        }
      }

      function decreaseQuantity() {
        if (prevAvailable) {
          setCurrentQuantity(currentQuantity - multipleQuantity);
        }
      }

      function handleInputChange(event) {
        return updateCurrentQuantity(parseInt(event.target.value, 10));
      }

      var btnSizeClass;
      var formControlSizeClass;

      if (size === 'large') {
        btnSizeClass = 'btn-lg';
        formControlSizeClass = 'form-control-lg';
      }

      if (size === 'small') {
        btnSizeClass = 'btn-sm';
        formControlSizeClass = 'form-control-sm';
      }

      var content = /*#__PURE__*/_react.default.createElement("div", {
        className: "quantity-selector"
      }, allowedQuantities ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("select", {
        className: (0, _classnames.default)('form-control', formControlSizeClass),
        name: inputName,
        onChange: function handleSelectChange(event) {
          event.preventDefault();
          setCurrentQuantity(event.target.value);
        },
        value: currentQuantity
      }, allowedQuantities.map(function (value) {
        return (/*#__PURE__*/_react.default.createElement("option", {
            key: value,
            value: value
          }, value)
        );
      }))) : style === 'simple' ? /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group input-group-sm simple"
      }, (prependedIcon || prependedText) && /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group-item input-group-item-shrink input-group-prepend"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "input-group-text"
      }, prependedIcon ? /*#__PURE__*/_react.default.createElement(_icon.default, {
        symbol: prependedIcon
      }) : prependedText)), /*#__PURE__*/_react.default.createElement("div", {
        className: (0, _classnames.default)('input-group-item input-group-item-shrink', (appendedIcon || appendedText) && 'input-group-prepend')
      }, /*#__PURE__*/_react.default.createElement("input", {
        className: (0, _classnames.default)('form-control text-center', formControlSizeClass),
        disabled: disabled,
        max: maxQuantity,
        min: minQuantity,
        name: inputName,
        onChange: handleInputChange,
        step: multipleQuantity,
        type: "number",
        value: currentQuantity
      })), (appendedIcon || appendedText) && /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group-append input-group-item input-group-item-shrink"
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "input-group-text"
      }, appendedIcon ? /*#__PURE__*/_react.default.createElement(_icon.default, {
        symbol: appendedIcon
      }) : appendedText))) : /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group justify-content-center"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group-item input-group-item-shrink input-group-prepend"
      }, /*#__PURE__*/_react.default.createElement("button", {
        className: (0, _classnames.default)('btn btn-monospaced btn-secondary', btnSizeClass),
        disabled: disabled || !prevAvailable,
        onClick: decreaseQuantity
      }, /*#__PURE__*/_react.default.createElement(_icon.default, {
        symbol: "hr"
      }))), /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group-item input-group-prepend"
      }, /*#__PURE__*/_react.default.createElement("input", {
        className: (0, _classnames.default)('form-control text-center', formControlSizeClass),
        disabled: disabled,
        name: inputName,
        onChange: handleInputChange,
        onKeyUp: function handleInputKeyUp(event) {
          if (event.keyCode == 38) {
            increaseQuantity();
          } else if (event.keyCode == 40) {
            decreaseQuantity();
          }
        },
        type: "text",
        value: currentQuantity
      })), /*#__PURE__*/_react.default.createElement("div", {
        className: "input-group-append input-group-item input-group-item-shrink"
      }, /*#__PURE__*/_react.default.createElement("button", {
        className: (0, _classnames.default)('btn btn-monospaced btn-secondary', btnSizeClass),
        disabled: disabled || !nextAvailable,
        onClick: increaseQuantity
      }, /*#__PURE__*/_react.default.createElement(_icon.default, {
        symbol: "plus"
      })))));

      return content;
    }

    QuantitySelector.propTypes = {
      allowedQuantities: _propTypes.default.arrayOf(_propTypes.default.number),
      appendedIcon: _propTypes.default.string,
      appendedText: _propTypes.default.string,
      disabled: _propTypes.default.bool,
      inputName: _propTypes.default.string,
      maxQuantity: _propTypes.default.number,
      minQuantity: _propTypes.default.number,
      multipleQuantity: _propTypes.default.number,
      prependedIcon: _propTypes.default.string,
      prependedText: _propTypes.default.string,
      quantity: _propTypes.default.number,
      size: _propTypes.default.oneOf(['large', 'medium', 'small']),
      style: _propTypes.default.oneOf(['default', 'simple']),
      updateQuantity: _propTypes.default.func
    };
    QuantitySelector.defaultProps = {
      disabled: false,
      maxQuantity: 99999999,
      minQuantity: 1,
      multipleQuantity: 1,
      style: 'default'
    };
    var _default = QuantitySelector;
    exports.default = _default;
    //# sourceMappingURL=QuantitySelector.js.map
  }
});
//# sourceMappingURL=QuantitySelector.js.map