Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/utilities/actionItems/index", ['module', 'exports', 'require', '../eventsDefinitions', '../index', '../modals/index', './constants'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.triggerAction = triggerAction;

    var _eventsDefinitions = require("../eventsDefinitions");

    var _index = require("../index");

    var _index2 = require("../modals/index");

    var _constants = require("./constants");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var BLANK = _constants.ACTION_ITEM_TARGETS.BLANK,
        EVENT = _constants.ACTION_ITEM_TARGETS.EVENT,
        MODAL = _constants.ACTION_ITEM_TARGETS.MODAL,
        MODAL_FULL_SCREEN = _constants.ACTION_ITEM_TARGETS.MODAL_FULL_SCREEN,
        MODAL_LARGE = _constants.ACTION_ITEM_TARGETS.MODAL_LARGE,
        MODAL_SMALL = _constants.ACTION_ITEM_TARGETS.MODAL_SMALL,
        SIDE_PANEL = _constants.ACTION_ITEM_TARGETS.SIDE_PANEL;

    function triggerAction(item, context) {
      var actionTargetURL = item.href,
          actionTarget = item.target,
          loadData = context.loadData,
          modalId = context.modalId,
          sidePanelId = context.sidePanelId;

      switch (actionTarget) {
        case BLANK:
          window.open(actionTargetURL);
          break;

        case MODAL:
        case MODAL_FULL_SCREEN:
        case MODAL_LARGE:
        case MODAL_SMALL:
          Liferay.fire(_eventsDefinitions.OPEN_MODAL, {
            id: modalId,
            onClose: loadData,
            size: (0, _index2.resolveModalSize)(actionTarget),
            url: actionTargetURL
          });
          break;

        case SIDE_PANEL:
          Liferay.fire(_eventsDefinitions.OPEN_SIDE_PANEL, {
            id: sidePanelId,
            onAfterSubmit: loadData,
            url: actionTargetURL
          });
          break;

        case EVENT:
          Liferay.fire(actionTargetURL);
          break;

        default:
          (0, _index.liferayNavigate)(actionTargetURL);
          break;
      }
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map