Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/utilities/modals/index", ['module', 'exports', 'require', 'frontend-js-web', './constants'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.resolveModalSize = resolveModalSize;
    exports.resolveModalHeight = resolveModalHeight;
    exports.openPermissionsModal = openPermissionsModal;

    var _frontendJsWeb = require("frontend-js-web");

    var _constants = require("./constants");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function resolveModalSize(modalTarget) {
      var modalSize = modalTarget.split('-')[1];

      if (!modalSize) {
        return _constants.CLAY_MODAL_SIZES_MAP.DEFAULT;
      }

      if (modalSize in _constants.CLAY_MODAL_SIZES_MAP) {
        return _constants.CLAY_MODAL_SIZES_MAP[modalSize];
      }

      return _constants.CLAY_MODAL_SIZES_MAP.FULL_SCREEN;
    }

    function resolveModalHeight(size) {
      return !size || !(size in _constants.MODAL_HEIGHT_MAP) ? _constants.MODAL_HEIGHT_MAP.INITIAL : _constants.MODAL_HEIGHT_MAP[size];
    }

    function openPermissionsModal(url) {
      (0, _frontendJsWeb.openModal)({
        title: Liferay.Language.get('permissions'),
        url: url
      });
    }
    //# sourceMappingURL=index.js.map
  }
});
//# sourceMappingURL=index.js.map