Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/utilities/saveViewSettings", ['module', 'exports', 'require', 'frontend-js-web', './logError'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.saveViewSettings = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _logError = require("./logError");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var saveViewSettings = function saveViewSettings(_ref) {
      var appURL = _ref.appURL,
          id = _ref.id,
          portletId = _ref.portletId,
          settings = _ref.settings;
      var url = new URL("".concat(appURL, "/data-set/").concat(id, "/save-active-view-settings"));
      url.searchParams.append('groupId', themeDisplay.getScopeGroupId());
      url.searchParams.append('plid', themeDisplay.getPlid());
      url.searchParams.append('portletId', portletId);
      return (0, _frontendJsWeb.fetch)(url, {
        body: JSON.stringify(settings),
        headers: {
          Accept: 'application/json',
          'Content-Type': 'application/json'
        },
        method: 'POST'
      }).catch(function (error) {
        (0, _logError.logError)(error);
        (0, _frontendJsWeb.openToast)({
          message: Liferay.Language.get('unexpected-error'),
          type: 'danger'
        });
      });
    };

    exports.saveViewSettings = saveViewSettings;
    //# sourceMappingURL=saveViewSettings.js.map
  }
});
//# sourceMappingURL=saveViewSettings.js.map