Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/views/ViewsContext", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../actions/updateActiveView', '../actions/updateViewComponent', '../actions/updateVisibleFieldNames'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.viewsReducer = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _updateActiveView = require("../actions/updateActiveView");

    var _updateViewComponent = require("../actions/updateViewComponent");

    var _updateVisibleFieldNames = require("../actions/updateVisibleFieldNames");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var viewsReducer = function viewsReducer(state, _ref) {
      var type = _ref.type,
          value = _ref.value;
      var activeView = state.activeView,
          views = state.views;

      if (type === _updateActiveView.ACTION_UPDATE_ACTIVE_VIEW) {
        return _objectSpread(_objectSpread({}, state), {}, {
          activeView: views.find(function (_ref2) {
            var name = _ref2.name;
            return name === value;
          })
        });
      } else if (type === _updateViewComponent.ACTION_UPDATE_VIEW_COMPONENT) {
        var component = value.component,
            name = value.name;
        return _objectSpread(_objectSpread({}, state), {}, {
          activeView: name === (activeView === null || activeView === void 0 ? void 0 : activeView.name) ? _objectSpread(_objectSpread({}, activeView), {}, {
            component: component
          }) : activeView,
          views: views.map(function (view) {
            return view.name === name ? _objectSpread(_objectSpread({}, view), {}, {
              component: component
            }) : view;
          })
        });
      } else if (type === _updateVisibleFieldNames.ACTION_UPDATE_VISIBLE_FIELD_NAMES) {
        return _objectSpread(_objectSpread({}, state), {}, {
          visibleFieldNames: value
        });
      }

      return state;
    };

    exports.viewsReducer = viewsReducer;

    var _default = /*#__PURE__*/_react.default.createContext({
      activeView: null,
      views: [],
      visibleFieldNames: {}
    });

    exports.default = _default;
    //# sourceMappingURL=ViewsContext.js.map
  }
});
//# sourceMappingURL=ViewsContext.js.map