Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/views/selectable_table/SelectableTable", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/table', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../DataSetDisplayContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _form = require("@frontend-taglib-clay$clayui/form");

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _DataSetDisplayContext = _interopRequireDefault(require("../../DataSetDisplayContext"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function SelectableTable(_ref) {
      var itemsProp = _ref.items,
          schema = _ref.schema,
          style = _ref.style;

      var _useContext = (0, _react.useContext)(_DataSetDisplayContext.default),
          namespace = _useContext.namespace;

      var _useContext2 = (0, _react.useContext)(_DataSetDisplayContext.default),
          selectedItemsKey = _useContext2.selectedItemsKey;

      var _useState = (0, _react.useState)(itemsProp),
          _useState2 = _slicedToArray(_useState, 2),
          items = _useState2[0],
          updateItems = _useState2[1];

      (0, _react.useEffect)(function () {
        updateItems(items);
      }, [items]);

      function handleCheckboxChange(itemField, itemId, value) {
        var updatedItems = items.map(function (item) {
          var currentItemId = item[selectedItemsKey];

          if (!itemId || currentItemId === itemId) {
            return _objectSpread(_objectSpread({}, item), {}, {
              fields: item.fields.map(function (currentField) {
                if (itemField !== currentField.name) {
                  return currentField;
                }

                return _objectSpread(_objectSpread({}, currentField), {}, {
                  value: typeof value === 'boolean' ? value : !currentField.value
                });
              })
            });
          }

          return item;
        });
        updateItems(updatedItems);
      }

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "table-style-".concat(style)
        }, /*#__PURE__*/_react.default.createElement(_table.default, {
          borderless: true,
          hover: false,
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_table.default.Head, null, /*#__PURE__*/_react.default.createElement(_table.default.Row, null, /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          className: "table-cell-expand-smaller",
          headingCell: true,
          headingTitle: true
        }, schema.firstColumnLabel), items[0].fields.map(function (columnField) {
          var checkedItems = items.reduce(function (checked, item) {
            var field = item.fields.find(function (itemField) {
              return itemField.name === columnField.name;
            });
            return checked + (field.value ? 1 : 0);
          }, 0);
          return (/*#__PURE__*/_react.default.createElement(_table.default.Cell, {
              className: "table-cell-expand-smaller",
              headingCell: true,
              headingTitle: true,
              key: columnField.name
            }, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
              checked: checkedItems === items.length,
              className: "mr-2",
              indeterminate: checkedItems > 0 && checkedItems < items.length,
              label: columnField.label,
              name: "".concat(columnField.name, "_column"),
              onChange: function onChange() {
                return handleCheckboxChange(columnField.name, null, checkedItems === items.length ? false : true);
              }
            }))
          );
        }))), /*#__PURE__*/_react.default.createElement(_table.default.Body, null, items.map(function (item, i) {
          var itemId = item[selectedItemsKey];
          return (/*#__PURE__*/_react.default.createElement(_table.default.Row, {
              key: i
            }, /*#__PURE__*/_react.default.createElement(_table.default.Cell, null, item[schema.firstColumnName]), item.fields.map(function (field) {
              return (/*#__PURE__*/_react.default.createElement(_table.default.Cell, {
                  key: field.name
                }, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
                  checked: field.value,
                  name: namespace + itemId,
                  onChange: function onChange() {
                    handleCheckboxChange(field.name, itemId);
                  },
                  value: field.name
                }))
              );
            }))
          );
        }))))
      );
    }

    SelectableTable.defaultProps = {
      items: []
    };
    var _default = SelectableTable;
    exports.default = _default;
    //# sourceMappingURL=SelectableTable.js.map
  }
});
//# sourceMappingURL=SelectableTable.js.map