Liferay.Loader.define("frontend-taglib-clay@6.4.1/data_set_display/views/table/TableHeadRow", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/table', 'frontend-taglib-clay$classnames', 'frontend-taglib-clay$prop-types', 'frontend-js-react-web$react', '../../AppContext', '../../DataSetDisplayContext', '../../data_renderers/CheckboxRenderer', '../../thunks/persistVisibleFieldNames', '../ViewsContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = require("@frontend-taglib-clay$clayui/button");

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _table = _interopRequireDefault(require("@frontend-taglib-clay$clayui/table"));

    var _classnames = _interopRequireDefault(require("frontend-taglib-clay$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-taglib-clay$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AppContext = require("../../AppContext");

    var _DataSetDisplayContext = _interopRequireDefault(require("../../DataSetDisplayContext"));

    var _CheckboxRenderer = _interopRequireDefault(require("../../data_renderers/CheckboxRenderer"));

    var _persistVisibleFieldNames = _interopRequireDefault(require("../../thunks/persistVisibleFieldNames"));

    var _ViewsContext = _interopRequireDefault(require("../ViewsContext"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var FieldsSelectorDropdown = function FieldsSelectorDropdown(_ref) {
      var fields = _ref.fields;

      var _useContext = (0, _react.useContext)(_DataSetDisplayContext.default),
          id = _useContext.id;

      var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
          appURL = _useContext2.appURL,
          portletId = _useContext2.portletId;

      var _useContext3 = (0, _react.useContext)(_ViewsContext.default),
          _useContext4 = _slicedToArray(_useContext3, 2),
          visibleFieldNames = _useContext4[0].visibleFieldNames,
          dispatch = _useContext4[1];

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _useState3 = (0, _react.useState)(fields),
          _useState4 = _slicedToArray(_useState3, 2),
          filteredFields = _useState4[0],
          setFilteredFields = _useState4[1];

      var _useState5 = (0, _react.useState)(''),
          _useState6 = _slicedToArray(_useState5, 2),
          query = _useState6[0],
          setQuery = _useState6[1];

      var selectedFieldNames = Object.keys(visibleFieldNames).length ? visibleFieldNames : fields.reduce(function (selectedFieldNames, field) {
        return _objectSpread(_objectSpread({}, selectedFieldNames), {}, _defineProperty({}, field.fieldName, true));
      }, {});
      (0, _react.useEffect)(function () {
        setFilteredFields(fields.filter(function (field) {
          return field.label.toLowerCase().includes(query.toLowerCase());
        }));
      }, [fields, query]);
      return (/*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          className: "data-set-fields-selector-dropdown",
          onActiveChange: setActive,
          trigger: /*#__PURE__*/_react.default.createElement(_button.ClayButtonWithIcon, {
            borderless: true,
            className: "p-0",
            displayType: "secondary",
            monospaced: false,
            symbol: active ? 'caret-top' : 'caret-bottom'
          })
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.Search, {
          onChange: function onChange(event) {
            return setQuery(event.target.value);
          },
          value: query
        }), filteredFields.length ? /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, filteredFields.map(function (_ref2) {
          var fieldName = _ref2.fieldName,
              label = _ref2.label;
          return (/*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
              key: fieldName,
              onClick: function onClick() {
                dispatch((0, _persistVisibleFieldNames.default)({
                  appURL: appURL,
                  id: id,
                  portletId: portletId,
                  visibleFieldNames: _objectSpread(_objectSpread({}, selectedFieldNames), {}, _defineProperty({}, fieldName, !selectedFieldNames[fieldName]))
                }));
              }
            }, selectedFieldNames[fieldName] && /*#__PURE__*/_react.default.createElement(_icon.default, {
              className: "mr-2",
              symbol: "check"
            }), label)
          );
        })) : /*#__PURE__*/_react.default.createElement("div", {
          className: "dropdown-section text-muted"
        }, Liferay.Language.get('no-fields-were-found')))
      );
    };

    function TableHeadCell(_ref3) {
      var contentRenderer = _ref3.contentRenderer,
          expand = _ref3.expand,
          expandableColumns = _ref3.expandableColumns,
          fieldName = _ref3.fieldName,
          label = _ref3.label,
          sortable = _ref3.sortable,
          sorting = _ref3.sorting,
          sortingKeyProp = _ref3.sortingKey,
          updateSorting = _ref3.updateSorting;
      var sortingKey = sortingKeyProp || (Array.isArray(fieldName) ? fieldName[0] : fieldName);
      var sortingMatch = sorting.find(function (element) {
        return element.key === sortingKey;
      });

      return (/*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          className: (0, _classnames.default)(contentRenderer && "content-renderer-".concat(contentRenderer), expandableColumns ? expand && 'table-cell-expand-small' : 'table-cell-expand-smaller'),
          headingCell: true,
          headingTitle: true
        }, sortable ? /*#__PURE__*/_react.default.createElement("a", {
          className: "inline-item text-nowrap text-truncate-inline",
          "data-senna-off": true,
          href: "#",
          onClick: function handleSortingCellClick(event) {
            event.preventDefault();

            if (sortingMatch) {
              var updatedSortedElements = sorting.map(function (element) {
                return element.key === sortingKey ? _objectSpread(_objectSpread({}, element), {}, {
                  direction: element.direction === 'asc' ? 'desc' : 'asc'
                }) : element;
              });
              updateSorting(updatedSortedElements);
            } else {
              updateSorting([{
                fieldName: fieldName,
                key: sortingKey
              }]);
            }
          }
        }, label || '', /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-after sorting-icons-wrapper"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: (0, _classnames.default)('sorting-icon', (sortingMatch === null || sortingMatch === void 0 ? void 0 : sortingMatch.direction) === 'asc' && 'active'),
          draggable: true,
          symbol: "order-arrow-up"
        }), /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: (0, _classnames.default)('sorting-icon', (sortingMatch === null || sortingMatch === void 0 ? void 0 : sortingMatch.direction) === 'desc' && 'active'),
          draggable: true,
          symbol: "order-arrow-down"
        }))) : label || '')
      );
    }

    function TableHeadRow(_ref4) {
      var items = _ref4.items,
          schema = _ref4.schema,
          selectItems = _ref4.selectItems,
          selectable = _ref4.selectable,
          selectedItemsKey = _ref4.selectedItemsKey,
          selectedItemsValue = _ref4.selectedItemsValue,
          selectionType = _ref4.selectionType,
          sorting = _ref4.sorting,
          updateSorting = _ref4.updateSorting,
          visibleFields = _ref4.visibleFields;
      var expandableColumns = visibleFields.some(function (field) {
        return field.expand;
      });

      return (/*#__PURE__*/_react.default.createElement(_table.default.Head, null, /*#__PURE__*/_react.default.createElement(_table.default.Row, null, selectable && /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          headingCell: true
        }, items.length && selectionType === 'multiple' ? /*#__PURE__*/_react.default.createElement(_CheckboxRenderer.default, {
          checked: !!selectedItemsValue.length,
          indeterminate: !!selectedItemsValue.length && items.length !== selectedItemsValue.length,
          name: "table-head-selector",
          onChange: function handleCheckboxClick() {
            if (selectedItemsValue.length === items.length) {
              return selectItems([]);
            }

            return selectItems(items.map(function (item) {
              return item[selectedItemsKey];
            }));
          }
        }) : null), visibleFields.map(function (field, i) {
          return (/*#__PURE__*/_react.default.createElement(TableHeadCell, _extends({}, field, {
              expandableColumns: expandableColumns,
              key: field.sortingKey || i,
              sorting: sorting,
              updateSorting: updateSorting
            }))
          );
        }), /*#__PURE__*/_react.default.createElement(_table.default.Cell, {
          className: "text-right",
          headingCell: true
        }, /*#__PURE__*/_react.default.createElement(FieldsSelectorDropdown, {
          fields: schema.fields
        }))))
      );
    }

    var _default = TableHeadRow;
    exports.default = _default;
    //# sourceMappingURL=TableHeadRow.js.map
  }
});
//# sourceMappingURL=TableHeadRow.js.map