Liferay.Loader.define("ratings-taglib@2.1.14/js/components/RatingsLike", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './AnimatedCounter'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _AnimatedCounter = _interopRequireDefault(require("./AnimatedCounter"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var SCORE_LIKE = 1;
    var SCORE_UNLIKE = -1;

    var RatingsLike = function RatingsLike(_ref) {
      var _ref$disabled = _ref.disabled,
          disabled = _ref$disabled === void 0 ? true : _ref$disabled,
          _ref$initialLiked = _ref.initialLiked,
          initialLiked = _ref$initialLiked === void 0 ? false : _ref$initialLiked,
          inititalTitle = _ref.inititalTitle,
          _ref$positiveVotes = _ref.positiveVotes,
          positiveVotes = _ref$positiveVotes === void 0 ? 0 : _ref$positiveVotes,
          sendVoteRequest = _ref.sendVoteRequest;

      var _useState = (0, _react.useState)(initialLiked),
          _useState2 = _slicedToArray(_useState, 2),
          liked = _useState2[0],
          setLiked = _useState2[1];

      var _useState3 = (0, _react.useState)(positiveVotes),
          _useState4 = _slicedToArray(_useState3, 2),
          totalLikes = _useState4[0],
          setTotalLikes = _useState4[1];

      var _useState5 = (0, _react.useState)(false),
          _useState6 = _slicedToArray(_useState5, 2),
          animatedButton = _useState6[0],
          setAnimatedButton = _useState6[1];

      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      var handleSendVoteRequest = function handleSendVoteRequest(score) {
        sendVoteRequest(score).then(function () {
          var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
              totalScore = _ref2.totalScore;

          if (isMounted() && totalScore) {
            setTotalLikes(Math.round(totalScore));
          }
        });
      };

      return (/*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "ratings-like"
        }, /*#__PURE__*/_react.default.createElement(_button.default, {
          "aria-pressed": liked,
          borderless: true,
          className: (0, _classnames.default)({
            'btn-animated': animatedButton
          }),
          disabled: disabled,
          displayType: "secondary",
          onClick: function toggleLiked() {
            if (!liked) {
              setAnimatedButton(true);
            }

            var score = liked ? SCORE_UNLIKE : SCORE_LIKE;
            setLiked(!liked);
            setTotalLikes(totalLikes + score);
            handleSendVoteRequest(score);
          },
          small: true,
          title: function getTitle() {
            if (inititalTitle !== undefined) {
              return inititalTitle;
            }

            return liked ? Liferay.Language.get('unlike-this') : Liferay.Language.get('like-this');
          }(),
          value: totalLikes
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "c-inner",
          tabIndex: "-1"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "off"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "heart"
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "on",
          onAnimationEnd: function HandleAnimationEnd() {
            setAnimatedButton(false);
          }
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "heart-full"
        }))), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item likes"
        }, /*#__PURE__*/_react.default.createElement(_AnimatedCounter.default, {
          counter: totalLikes
        }))))))
      );
    };

    var _default = RatingsLike;
    exports.default = _default;
    //# sourceMappingURL=RatingsLike.js.map
  }
});
//# sourceMappingURL=RatingsLike.js.map