Liferay.Loader.define("ratings-taglib@2.1.14/js/components/RatingsStackedStars", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../utils/lang'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = RatingsStackedStars;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _lang = _interopRequireDefault(require("../utils/lang"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function RatingsStackedStars(_ref) {
      var averageScore = _ref.averageScore,
          disabled = _ref.disabled,
          getSrAverageMessage = _ref.getSrAverageMessage,
          getTitle = _ref.getTitle,
          numberOfStars = _ref.numberOfStars,
          onVote = _ref.onVote,
          randomNamespace = _ref.randomNamespace,
          score = _ref.score,
          starScores = _ref.starScores,
          totalEntries = _ref.totalEntries;
      return (/*#__PURE__*/_react.default.createElement(_tooltip.ClayTooltipProvider, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "ratings-stacked-stars ratings-stars"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "ratings-stars-average",
          title: averageScore.toFixed(1)
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item inline-item-before"
        }, starScores.map(function (_ref2, index, arr) {
          var score = _ref2.label;
          var previousScore = arr[index - 1] && arr[index - 1].label;
          var symbol = 'star-o';

          if (averageScore >= score) {
            symbol = 'star';
          } else if (averageScore > previousScore) {
            symbol = 'star-half';
          }

          return (/*#__PURE__*/_react.default.createElement(_icon.default, {
              className: "ratings-stars-average-icon",
              key: score,
              symbol: symbol
            })
          );
        })), /*#__PURE__*/_react.default.createElement("span", {
          className: "inline-item ratings-stars-average-text"
        }, !!totalEntries && " (".concat(totalEntries, " ").concat(totalEntries === 1 ? Liferay.Language.get('vote') : Liferay.Language.get('votes'), ")")), /*#__PURE__*/_react.default.createElement("span", {
          className: "sr-only"
        }, getSrAverageMessage())), /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)({
            disabled: disabled
          }, 'ratings-stacked-stars-vote')
        }, /*#__PURE__*/_react.default.createElement("fieldset", {
          title: getTitle()
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "ratings-stacked-stars-vote-stars"
        }, starScores.reverse().map(function (_ref3, index) {
          var label = _ref3.label,
              value = _ref3.value;
          var id = "".concat(randomNamespace, "star").concat(label);
          var srMessage = index === 0 ? Liferay.Language.get('rate-this-x-star-out-of-x') : Liferay.Language.get('rate-this-x-stars-out-of-x');

          return (/*#__PURE__*/_react.default.createElement(_react.Fragment, {
              key: value
            }, /*#__PURE__*/_react.default.createElement("input", {
              checked: label === score,
              className: "sr-only",
              disabled: disabled,
              id: id,
              name: "".concat(randomNamespace, "rating"),
              onChange: function onChange() {
                onVote(index);
              },
              type: "radio",
              value: value
            }), /*#__PURE__*/_react.default.createElement("label", {
              className: label <= score ? 'ratings-stars-star-full' : '',
              htmlFor: id
            }, /*#__PURE__*/_react.default.createElement(_icon.default, {
              className: "ratings-stars-icon-full",
              symbol: 'star'
            }), /*#__PURE__*/_react.default.createElement(_icon.default, {
              className: "ratings-stars-icon-empty",
              symbol: 'star-o'
            }), /*#__PURE__*/_react.default.createElement("span", {
              className: "sr-only"
            }, _lang.default.sub(srMessage, [label, numberOfStars]))))
          );
        }))), score !== 0 && /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "ratings-stacked-stars-delete",
          disabled: disabled,
          displayType: "unstyled",
          onClick: onVote,
          title: Liferay.Language.get('delete')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "lexicon-icon-vertical-align",
          symbol: "times-circle"
        })))))
      );
    }
    //# sourceMappingURL=RatingsStackedStars.js.map
  }
});
//# sourceMappingURL=RatingsStackedStars.js.map