Liferay.Loader.define("frontend-taglib-clay@6.4.1/management_toolbar/ManagementToolbar.es", ['module', 'exports', 'require', 'frontend-taglib-clay$clay-component', 'frontend-taglib-clay$clay-management-toolbar', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './ManagementToolbar.soy'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.ManagementToolbar = void 0;

    var _clayComponent = _interopRequireDefault(require("frontend-taglib-clay$clay-component"));

    var _clayManagementToolbar = require("frontend-taglib-clay$clay-management-toolbar");

    var _metalEvents = require("frontend-js-metal-web$metal-events");

    var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _ManagementToolbar = _interopRequireDefault(require("./ManagementToolbar.soy"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _get(target, property, receiver) {
      if (typeof Reflect !== "undefined" && Reflect.get) {
        _get = Reflect.get;
      } else {
        _get = function _get(target, property, receiver) {
          var base = _superPropBase(target, property);if (!base) return;var desc = Object.getOwnPropertyDescriptor(base, property);if (desc.get) {
            return desc.get.call(receiver);
          }return desc.value;
        };
      }return _get(target, property, receiver || target);
    }

    function _superPropBase(object, property) {
      while (!Object.prototype.hasOwnProperty.call(object, property)) {
        object = _getPrototypeOf(object);if (object === null) break;
      }return object;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * Creates a Metal Management Toolbar component.
     */
    var ManagementToolbar = /*#__PURE__*/function (_ClayComponent) {
      _inherits(ManagementToolbar, _ClayComponent);

      function ManagementToolbar() {
        _classCallCheck(this, ManagementToolbar);

        return _possibleConstructorReturn(this, _getPrototypeOf(ManagementToolbar).apply(this, arguments));
      }

      _createClass(ManagementToolbar, [{
        key: "attached",

        /**
         * @inheritDoc
         */
        value: function attached() {
          var _get2,
              _this = this;

          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          (_get2 = _get(_getPrototypeOf(ManagementToolbar.prototype), "attached", this)).call.apply(_get2, [this].concat(args));

          new _metalEvents.EventEmitterProxy(this.refs.managementToolbar, this);
          Liferay.componentReady(this.searchContainerId).then(function (searchContainer) {
            _this._eventHandler = [searchContainer.on('rowToggled', _this._handleSearchContainerRowToggled, _this)];
            _this._searchContainer = searchContainer;
            var select = searchContainer.select;

            if (select && select.getAllSelectedElements && select.getCurrentPageElements && select.getCurrentPageSelectedElements) {
              var bulkSelection = _this.supportsBulkActions && select.get('bulkSelection');

              _this._setActiveStatus({
                allSelectedElements: select.getAllSelectedElements(),
                currentPageElements: select.getCurrentPageElements(),
                currentPageSelectedElements: select.getCurrentPageSelectedElements()
              }, bulkSelection);
            }
          });

          if (this.infoPanelId) {
            var sidenavToggle = this.refs.managementToolbar.refs.infoButton;

            if (sidenavToggle) {
              Liferay.SideNavigation.initialize(sidenavToggle, {
                container: '#' + this.infoPanelId,
                position: 'right',
                type: 'relative',
                typeMobile: 'fixed',
                width: '320px'
              });
            }
          }
        }
        /**
         * @inheritDoc
         */

      }, {
        key: "disposed",
        value: function disposed() {
          var _get3;

          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }

          (_get3 = _get(_getPrototypeOf(ManagementToolbar.prototype), "disposed", this)).call.apply(_get3, [this].concat(args));

          if (this.infoPanelId) {
            var sidenavToggle = this.refs.managementToolbar.refs.infoButton;

            if (sidenavToggle) {
              Liferay.SideNavigation.destroy(sidenavToggle);
            }
          }

          if (this._eventHandler) {
            this._eventHandler.forEach(function (eventHandler) {
              eventHandler.detach();
            });
          }
        }
      }, {
        key: "isCacheable",
        value: function isCacheable(uri) {
          var cacheable = true;

          if (this._searchContainer && this._searchContainer.select) {
            var keepSelection = this._searchContainer.select.get('keepSelection');

            cacheable = keepSelection.test(uri);
          }

          return cacheable;
        }
        /**
         * Deselects all search container rows.
         *
         * @param {!Event} event The event.
         * @private
         */

      }, {
        key: "_handleClearSelectionButtonClicked",
        value: function _handleClearSelectionButtonClicked() {
          if (this._searchContainer) {
            this._searchContainer.select.toggleAllRows(false, true);
          }
        }
      }, {
        key: "_handleCreationMenuMoreButtonClicked",
        value: function _handleCreationMenuMoreButtonClicked(event) {
          var _this2 = this;

          setTimeout(function extendMenu() {
            if (event.preventedDefault) {
              return;
            }

            var creationMenuPrimaryItemsCount = _this2.creationMenu.primaryItems ? _this2.creationMenu.primaryItems.length : 0;
            var creationMenuFavoriteItems = _this2.creationMenu.secondaryItems && _this2.creationMenu.secondaryItems[0] ? _this2.creationMenu.secondaryItems[0].items : [];
            var creationMenuRestItems = _this2.creationMenu.secondaryItems && _this2.creationMenu.secondaryItems[1] ? _this2.creationMenu.secondaryItems[1].items : [];
            var creationMenuSecondaryItemsCount = creationMenuFavoriteItems.length + creationMenuRestItems.length;
            var creationMenuTotalItemsCount = creationMenuPrimaryItemsCount + creationMenuSecondaryItemsCount;
            _this2.creationMenu.maxPrimaryItems = creationMenuPrimaryItemsCount;
            _this2.creationMenu.maxSecondaryItems = creationMenuSecondaryItemsCount;
            _this2.creationMenu.maxTotalItems = creationMenuTotalItemsCount;
            _this2.refs.managementToolbar.refs.creationMenuDropdown.maxPrimaryItems = creationMenuPrimaryItemsCount;
            _this2.refs.managementToolbar.refs.creationMenuDropdown.maxSecondaryItems = creationMenuSecondaryItemsCount;
            _this2.refs.managementToolbar.refs.creationMenuDropdown.maxTotalItems = creationMenuTotalItemsCount;
          }, 0);
        }
      }, {
        key: "_handleFilterLabelCloseClicked",
        value: function _handleFilterLabelCloseClicked(event) {
          var removeLabelURL = event.data.label.data && event.data.label.data.removeLabelURL;

          if (removeLabelURL) {
            Liferay.Util.navigate(removeLabelURL);
          }
        }
        /**
         * Toggles all search container rows.
         *
         * @param {!Event} event The event.
         * @private
         */

      }, {
        key: "_handleSelectPageCheckboxChanged",
        value: function _handleSelectPageCheckboxChanged(event) {
          if (this._searchContainer) {
            var checkboxStatus = event.data.checked;

            if (checkboxStatus) {
              this._searchContainer.select.toggleAllRows(true);
            } else {
              this._searchContainer.select.toggleAllRows(false);
            }
          }
        }
        /**
         * Selects all search container rows.
         *
         * @param {!Event} event The event.
         * @private
         */

      }, {
        key: "_handleSelectAllButtonClicked",
        value: function _handleSelectAllButtonClicked() {
          if (this._searchContainer) {
            this._searchContainer.select.toggleAllRows(true, true);
          }
        }
        /**
         * Updates the count for the selected items in the management toolbar when
         * the search container element is toggled.
         *
         * @param {object} event The row toggle event from the search container.
         * @private
         */

      }, {
        key: "_handleSearchContainerRowToggled",
        value: function _handleSearchContainerRowToggled(event) {
          var actions = event.actions;

          var bulkSelection = this.supportsBulkActions && this._searchContainer.select.get('bulkSelection');

          this._setActiveStatus(event.elements, bulkSelection);

          if (this.actionItems) {
            this.actionItems = this.actionItems.map(function (actionItem) {
              return Object.assign(actionItem, {
                disabled: actions && actions.indexOf(actionItem.data.action) === -1 && (!bulkSelection || !actionItem.data.enableOnBulk)
              });
            });
          }
        }
        /**
         * Updates the management toolbar's active status checkbox.
         *
         * @param {object} elements The list of elements.
         * @param {bool} bulkSelection Whether bulk selection is enabled.
         * @private
         */

      }, {
        key: "_setActiveStatus",
        value: function _setActiveStatus(elements, bulkSelection) {
          var currentPageElements = elements.currentPageElements.size();
          var currentPageSelectedElements = elements.currentPageSelectedElements.size();
          var currentPageSelected = currentPageElements === currentPageSelectedElements;
          this.selectedItems = bulkSelection ? this.totalItems : elements.allSelectedElements.filter(':enabled').size();
          this.active = this.selectedItems > 0;

          if (currentPageSelectedElements > 0) {
            this.checkboxStatus = currentPageSelected ? 'checked' : 'indeterminate';
          } else {
            this.checkboxStatus = 'unchecked';
          }

          if (this.supportsBulkActions) {
            this.showSelectAllButton = currentPageSelected && this.totalItems > this.selectedItems && !this._searchContainer.select.get('bulkSelection');
          }
        }
      }]);

      return ManagementToolbar;
    }(_clayComponent.default);
    /**
     * State definition.
     *
     * @static
     * @type {!Object}
     */

    exports.ManagementToolbar = ManagementToolbar;
    ManagementToolbar.STATE = {
      /**
       * List of items to display in the actions menu on active state.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(array|undefined)}
       */
      actionItems: _clayManagementToolbar.actionItemsValidator,

      /**
       * Status of the select items checkbox. If the status is checked or
       * indeterminate, the toolbar is in active state.
       *
       * @default unchecked
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      checkboxStatus: _metalState.Config.oneOf(['checked', 'indeterminate', 'unchecked']).value('unchecked'),

      /**
       * URL for the clear results link.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      clearResultsURL: _metalState.Config.string(),

      /**
       * URL for the clear selection link.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      clearSelectionURL: _metalState.Config.string(),

      /**
       * Name of the content renderer to use template variants.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      contentRenderer: _metalState.Config.string(),

      /**
       * Configuration of the creation menu.
       *
       * <ul>
       * <li>
       * Set <code>true</code> to render a plain button that emits an event on
       * click.
       * </li>
       * <li>
       * Set <code>string</code> to use it as link <code>href</code> to render a
       * link styled button.
       * </li>
       * <li>
       * Set <code>object</code> to render a dropdown menu with items.
       * </li>
       * </ul>
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(object|string|bool|undefined)}
       */
      creationMenu: _metalState.Config.shapeOf({
        caption: _metalState.Config.string(),
        helpText: _metalState.Config.string(),
        itemsIconAlignment: _metalState.Config.string(),
        maxPrimaryItems: _metalState.Config.number(),
        maxSecondaryItems: _metalState.Config.number(),
        maxTotalItems: _metalState.Config.number(),
        primaryItems: _clayManagementToolbar.creationMenuItemsValidator,
        secondaryItems: _clayManagementToolbar.creationMenuItemsValidator,
        viewMoreURL: _metalState.Config.string()
      }),

      /**
       * Component wired to handle the available user actions in the Management
       * Toolbar component.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|object|undefined)}
       */
      defaultEventHandler: _metalState.Config.object(),

      /**
       * Flag to indicate if the managment toolbar is disabled.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      disabled: _metalState.Config.bool().value(false),

      /**
       * CSS classes to be applied to the element.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      elementClasses: _metalState.Config.string(),

      /**
       * List of filter menu items.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(array|undefined)}
       */
      filterItems: _clayManagementToolbar.filterItemsValidator,

      /**
       * List of filter label items.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(array|undefined)}
       */
      filterLabels: _clayManagementToolbar.filterLabelsValidator,

      /**
       * ID to apply to the element.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      id: _metalState.Config.string(),

      /**
       * ID to get the info panel node.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?string|undefined}
       */
      infoPanelId: _metalState.Config.string(),

      /**
       * URL of the search form action.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      searchActionURL: _metalState.Config.string(),

      /**
       * ID to get an instance of the search container.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?string|undefined}
       */
      searchContainerId: _metalState.Config.string(),

      /**
       * Map of properties that are rendered as hidden inputs in the search form.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?object}
       */
      searchData: _metalState.Config.object(),

      /**
       * Method of the search form.
       *
       * @default GET
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      searchFormMethod: _metalState.Config.oneOf(['GET', 'POST']).value('GET'),

      /**
       * Name of the search form.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      searchFormName: _metalState.Config.string(),

      /**
       * Name of the search input.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      searchInputName: _metalState.Config.string(),

      /**
       * Value of the search input.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      searchValue: _metalState.Config.string(),

      /**
       * URL for the Select All link.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      selectAllURL: _metalState.Config.string(),

      /**
       * Flag to indicate if the managment toolbar controls the selection of
       * elements.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(bool|undefined)}
       */
      selectable: _metalState.Config.bool().value(false),

      /**
       * Number of selected items.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(number|undefined)}
       */
      selectedItems: _metalState.Config.number(),

      /**
       * Flag to indicate if the advanced search is visible.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showAdvancedSearch: _metalState.Config.bool().value(false),

      /**
       * Flag to indicate if the creation menu button is visible.
       *
       * @default true
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showCreationMenu: _metalState.Config.bool().value(true),

      /**
       * Flag to indicate if the Done button in the filter dropdown is visible.
       *
       * @default true
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showFiltersDoneButton: _metalState.Config.bool().value(true),

      /**
       * Flag to indicate if the Info button is visible.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showInfoButton: _metalState.Config.bool().value(false),

      /**
       * Flag to indicate if the results bar is visible.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showResultsBar: _metalState.Config.bool().value(false),

      /**
       * Flag to indicate if search is visible.
       *
       * @default true
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showSearch: _metalState.Config.bool().value(true),

      /**
       * Flag to indicate if the Select All button is visible.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {?bool}
       */
      showSelectAllButton: _metalState.Config.bool().value(false),

      /**
       * Sorting order.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      sortingOrder: _metalState.Config.oneOf(['asc', 'desc']),

      /**
       * Sorting URL.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      sortingURL: _metalState.Config.string(),

      /**
       * Path to the SVG spritemap file containing the icons.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(string|undefined)}
       */
      spritemap: _metalState.Config.string().required(),

      /**
       * Flag to indicate if the toolbar supports bulk selection.
       *
       * @default false
       * @instance
       * @memberof ManagementToolbar
       * @type {boolean}
       */
      supportsBulkActions: _metalState.Config.bool().value(false),

      /**
       * Total number of items. If <code>0</code>, most of the elements in the
       * toolbar are disabled.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(number|undefined)}
       */
      totalItems: _metalState.Config.number(),

      /**
       * List of view items.
       *
       * @default undefined
       * @instance
       * @memberof ManagementToolbar
       * @type {?(array|undefined)}
       */
      viewTypes: _metalState.Config.arrayOf(_metalState.Config.shapeOf({
        active: _metalState.Config.bool().value(false),
        disabled: _metalState.Config.bool().value(false),
        href: _metalState.Config.string(),
        icon: _metalState.Config.string().required(),
        label: _metalState.Config.string().required()
      }))
    };

    _metalSoy.default.register(ManagementToolbar, _ManagementToolbar.default);

    var _default = ManagementToolbar;
    exports.default = _default;
    //# sourceMappingURL=ManagementToolbar.es.js.map
  }
});
//# sourceMappingURL=ManagementToolbar.es.js.map