Liferay.Loader.define("product-navigation-taglib@5.0.32/personal_menu/js/PersonalMenu.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/sticker', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = require("@frontend-taglib-clay$clayui/drop-down");

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _sticker = _interopRequireDefault(require("@frontend-taglib-clay$clayui/sticker"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function PersonalMenu(_ref) {
      var color = _ref.color,
          isImpersonated = _ref.isImpersonated,
          itemsURL = _ref.itemsURL,
          label = _ref.label,
          size = _ref.size,
          userPortraitURL = _ref.userPortraitURL;

      var _useState = (0, _react.useState)([]),
          _useState2 = _slicedToArray(_useState, 2),
          items = _useState2[0],
          setItems = _useState2[1];

      var preloadPromise = (0, _react.useRef)();

      function preloadItems() {
        if (!preloadPromise.current) {
          preloadPromise.current = (0, _frontendJsWeb.fetch)(itemsURL).then(function (response) {
            return response.json();
          }).then(function (items) {
            return setItems(items);
          });
        }
      }

      return (/*#__PURE__*/_react.default.createElement(_dropDown.ClayDropDownWithItems, {
          items: items,
          menuElementAttrs: {
            className: 'dropdown-menu-personal-menu'
          },
          trigger: label ? /*#__PURE__*/_react.default.createElement("div", {
            dangerouslySetInnerHTML: {
              __html: label
            },
            onFocus: preloadItems,
            onMouseOver: preloadItems
          }) : /*#__PURE__*/_react.default.createElement(_button.default, {
            "aria-label": Liferay.Language.get('personal-menu'),
            displayType: "unstyled",
            onFocus: preloadItems,
            onMouseOver: preloadItems
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "sticker sticker-".concat(size)
          }, /*#__PURE__*/_react.default.createElement(_sticker.default, {
            className: "user-icon-color-".concat(color),
            shape: "circle",
            size: size
          }, userPortraitURL ? /*#__PURE__*/_react.default.createElement("img", {
            className: "sticker-img",
            src: userPortraitURL
          }) : /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "user"
          })), isImpersonated && /*#__PURE__*/_react.default.createElement(_sticker.default, {
            className: "sticker-user-icon",
            id: "impersonate-user-sticker",
            outside: true,
            position: "bottom-right",
            shape: "circle",
            size: size ? 'sm' : ''
          }, /*#__PURE__*/_react.default.createElement("span", {
            id: "impersonate-user-icon"
          }, /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "user"
          })))))
        })
      );
    }

    var _default = PersonalMenu;
    exports.default = _default;
    //# sourceMappingURL=PersonalMenu.es.js.map
  }
});
//# sourceMappingURL=PersonalMenu.es.js.map