Liferay.Loader.define("frontend-taglib@5.6.8/translation_manager/hooks/useRegistry", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = useRegistry;

    var _react = require("frontend-js-react-web$react");

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function useRegistry(_ref) {
      var componentId = _ref.componentId,
          states = _ref.states;
      var currentState = (0, _react.useRef)(_objectSpread({}, states));
      var eventsRef = (0, _react.useRef)([]);
      var previousState = (0, _react.useRef)(_objectSpread({}, states));

      var _detach = function detach(stateName, callback) {
        if (eventsRef.current) {
          var refIndex = eventsRef.current.findIndex(function (event) {
            return stateName === event.stateName && callback === event.callback;
          });

          if (refIndex !== -1) {
            eventsRef.current.splice(refIndex);
          }
        }
      };

      var get = function get(stateName) {
        var stateValue = currentState.current[stateName];

        if (stateValue) {
          return stateValue;
        }
      };

      var on = function on(stateName, callback) {
        eventsRef.current.push({
          callback: callback,
          stateName: stateName
        });
        return {
          detach: function detach() {
            return _detach(stateName, callback);
          }
        };
      };

      if (!Liferay.component(componentId)) {
        Liferay.component(componentId, {
          detach: _detach,
          get: get,
          on: on
        }, {
          destroyOnNavigate: true
        });
      }

      (0, _react.useEffect)(function () {
        currentState.current = _objectSpread({}, states);
      }, [states]);
      (0, _react.useEffect)(function () {
        var stateChanged = [];
        Object.entries(states).forEach(function (_ref2) {
          var _ref3 = _slicedToArray(_ref2, 2),
              key = _ref3[0],
              value = _ref3[1];

          if (value !== previousState.current[key]) {
            stateChanged.push(key);
          }
        });
        eventsRef.current.forEach(function (_ref4) {
          var callback = _ref4.callback,
              stateName = _ref4.stateName;

          if (stateChanged.includes(stateName)) {
            callback({
              newValue: states[stateName],
              previousValue: previousState.current[stateName]
            });
          }
        });
        previousState.current = _objectSpread({}, states);
      }, [states]);
    }
    //# sourceMappingURL=useRegistry.js.map
  }
});
//# sourceMappingURL=useRegistry.js.map