/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */
'use strict';

Liferay.Loader.define("commerce-frontend-taglib@10.1.15/user_invitation_modal/UserInvitationModal.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './UserInvitationModal.soy', 'frontend-taglib-clay$clay-modal', '../user_utils/UserListItem.es', '../user_utils/UserInputItem.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.UserInvitationModal = void 0;

    var _frontendJsWeb = require("frontend-js-web");

    var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

    var _metalSoy = _interopRequireWildcard(require("frontend-js-metal-web$metal-soy"));

    var _UserInvitationModal = _interopRequireDefault(require("./UserInvitationModal.soy"));

    require("frontend-taglib-clay$clay-modal");

    require("../user_utils/UserListItem.es");

    require("../user_utils/UserInputItem.es");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    var EMAIL_REGEX = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;

    var UserInvitationModal = /*#__PURE__*/function (_Component) {
      _inherits(UserInvitationModal, _Component);

      function UserInvitationModal() {
        _classCallCheck(this, UserInvitationModal);

        return _possibleConstructorReturn(this, _getPrototypeOf(UserInvitationModal).apply(this, arguments));
      }

      _createClass(UserInvitationModal, [{
        key: "created",
        value: function created() {
          this._debouncedFetchUser = (0, _frontendJsWeb.debounce)(this._fetchUsers.bind(this), 300);
        }
      }, {
        key: "attached",
        value: function attached() {
          this._fetchUsers();
        }
      }, {
        key: "syncAddedUsers",
        value: function syncAddedUsers() {
          var contentWrapper = this.element.querySelector('.autocomplete-input__content');
          this.element.querySelector('.autocomplete-input__box').focus();

          if (contentWrapper.scrollTo) {
            contentWrapper.scrollTo(0, contentWrapper.offsetHeight);
          }
        }
      }, {
        key: "_handleCloseModal",
        value: function _handleCloseModal(e) {
          e.preventDefault();
          this._modalVisible = false;
        }
      }, {
        key: "syncQuery",
        value: function syncQuery() {
          this._loading = true;
          return this._debouncedFetchUser();
        }
      }, {
        key: "_handleFormSubmit",
        value: function _handleFormSubmit(evt) {
          evt.preventDefault();

          if (this.query.match(EMAIL_REGEX)) {
            this.addedUsers = [].concat(_toConsumableArray(this.addedUsers), [{
              email: this.query
            }]);
            this.query = '';
          }

          return this.query;
        }
      }, {
        key: "_handleInputBox",
        value: function _handleInputBox(evt) {
          if (evt.keyCode === 8 && !this.query.length) {
            this.addedUsers = this.addedUsers.slice(0, -1);
          } else {
            this.query = evt.target.value;
          }

          return evt;
        }
      }, {
        key: "_handleInputName",
        value: function _handleInputName(evt) {
          this.accountName = evt.target.value;
          return evt;
        }
      }, {
        key: "_toggleInvitation",
        value: function _toggleInvitation(userToBeToggled) {
          if (!userToBeToggled.id) {
            this.query = '';
          }

          var userAlreadyAdded = this.addedUsers.reduce(function (alreadyAdded, user) {
            return alreadyAdded || user.email === userToBeToggled.email;
          }, false);
          this.addedUsers = userAlreadyAdded ? this.addedUsers.filter(function (user) {
            return user.email !== userToBeToggled.email;
          }) : [].concat(_toConsumableArray(this.addedUsers), [userToBeToggled]);
          return this.addedUsers;
        }
      }, {
        key: "_fetchUsers",
        value: function _fetchUsers() {
          var _this = this;

          return (0, _frontendJsWeb.fetch)(this.usersAPI + '?groupId=' + themeDisplay.getScopeGroupId() + '&q=' + this.query).then(function (response) {
            return response.json();
          }).then(function (response) {
            _this._loading = false;
            _this.users = response.users;
            return _this.users;
          });
        }
      }, {
        key: "_sendInvitations",
        value: function _sendInvitations() {
          if (this.addedUsers.length) {
            this.emit('inviteUserToAccount', this.addedUsers);
          }

          return this.addedUsers;
        }
      }, {
        key: "toggle",
        value: function toggle() {
          this._modalVisible = !this._modalVisible;
          return this._modalVisible;
        }
      }, {
        key: "open",
        value: function open() {
          this._modalVisible = true;
          return this._modalVisible;
        }
      }, {
        key: "close",
        value: function close() {
          this._modalVisible = false;
          return this._modalVisible;
        }
      }]);

      return UserInvitationModal;
    }(_metalComponent.default);

    exports.UserInvitationModal = UserInvitationModal;

    _metalSoy.default.register(UserInvitationModal, _UserInvitationModal.default);

    var USER_SCHEMA = _metalSoy.Config.shapeOf({
      email: _metalSoy.Config.string().required(),
      name: _metalSoy.Config.string().required(),
      thumbnail: _metalSoy.Config.string().required(),
      userId: _metalSoy.Config.oneOfType([_metalSoy.Config.string(), _metalSoy.Config.number()]).required()
    });

    UserInvitationModal.STATE = {
      _loading: _metalSoy.Config.bool().internal().value(false),
      _modalVisible: _metalSoy.Config.bool().internal().value(false),
      addedUsers: _metalSoy.Config.array(USER_SCHEMA).value([]),
      query: _metalSoy.Config.string().value(''),
      spritemap: _metalSoy.Config.string(),
      users: _metalSoy.Config.array(USER_SCHEMA).value([]),
      usersAPI: _metalSoy.Config.string().value('')
    };
    var _default = UserInvitationModal;
    exports.default = _default;
    //# sourceMappingURL=UserInvitationModal.es.js.map
  }
});
//# sourceMappingURL=UserInvitationModal.es.js.map