Liferay.Loader.define("item-selector-taglib@4.1.42/utils/utils.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.sub = sub;

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Utility function for substituting variables into language keys.
     *
     * Examples:
     * sub(Liferay.Language.get('search-x'), ['all'])
     * => 'search all'
     * sub(Liferay.Language.get('search-x'), [<b>all<b>], false)
     * => 'search <b>all</b>'
     *
     * @param {string} langKey This is the language key used from our properties file
     * @param {string} args Arguments to pass into language key
     * @param {string} join Boolean used to indicate whether to call `.join()` on
     * the array before it is returned. Use `false` if subbing in JSX.
     * @return {(string|Array)}
     */
    function sub(langKey, args) {
      var SPLIT_REGEX = /({\d+})/g;
      var keyArray = langKey.split(SPLIT_REGEX).filter(function (val) {
        return val.length !== 0;
      });

      for (var i = 0; i < args.length; i++) {
        var arg = args[i];
        var indexKey = "{".concat(i, "}");
        var argIndex = keyArray.indexOf(indexKey);

        while (argIndex >= 0) {
          keyArray.splice(argIndex, 1, arg);
          argIndex = keyArray.indexOf(indexKey);
        }
      }

      return keyArray.join('');
    }
    //# sourceMappingURL=utils.es.js.map
  }
});
//# sourceMappingURL=utils.es.js.map