/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.layout.util.template;

import com.liferay.portal.kernel.model.Layout;

import java.util.Locale;

/**
 * @author Eudaldo Alonso
 */
public interface LayoutConverter {

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #convert(Layout, Locale)}
	 */
	@Deprecated
	public LayoutData convert(Layout layout);

	public default LayoutConversionResult convert(
		Layout layout, Locale locale) {

		return LayoutConversionResult.of(convert(layout), new String[0]);
	}

	public default boolean isConvertible(Layout layout) {
		if (layout.isTypeContent()) {
			return false;
		}

		return true;
	}

}