/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.kernel.service;

/**
 * Provides a wrapper for {@link EmailAddressLocalService}.
 *
 * @author Brian Wing Shun Chan
 * @see EmailAddressLocalService
 * @generated
 */
public class EmailAddressLocalServiceWrapper
	implements EmailAddressLocalService,
			   ServiceWrapper<EmailAddressLocalService> {

	public EmailAddressLocalServiceWrapper(
		EmailAddressLocalService emailAddressLocalService) {

		_emailAddressLocalService = emailAddressLocalService;
	}

	/**
	 * Adds the email address to the database. Also notifies the appropriate model listeners.
	 *
	 * @param emailAddress the email address
	 * @return the email address that was added
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress addEmailAddress(
		com.liferay.portal.kernel.model.EmailAddress emailAddress) {

		return _emailAddressLocalService.addEmailAddress(emailAddress);
	}

	@Override
	public com.liferay.portal.kernel.model.EmailAddress addEmailAddress(
			long userId, java.lang.String className, long classPK,
			java.lang.String address, long typeId, boolean primary,
			ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.addEmailAddress(
			userId, className, classPK, address, typeId, primary,
			serviceContext);
	}

	/**
	 * Creates a new email address with the primary key. Does not add the email address to the database.
	 *
	 * @param emailAddressId the primary key for the new email address
	 * @return the new email address
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress createEmailAddress(
		long emailAddressId) {

		return _emailAddressLocalService.createEmailAddress(emailAddressId);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel createPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.createPersistedModel(primaryKeyObj);
	}

	/**
	 * Deletes the email address from the database. Also notifies the appropriate model listeners.
	 *
	 * @param emailAddress the email address
	 * @return the email address that was removed
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress deleteEmailAddress(
		com.liferay.portal.kernel.model.EmailAddress emailAddress) {

		return _emailAddressLocalService.deleteEmailAddress(emailAddress);
	}

	/**
	 * Deletes the email address with the primary key from the database. Also notifies the appropriate model listeners.
	 *
	 * @param emailAddressId the primary key of the email address
	 * @return the email address that was removed
	 * @throws PortalException if a email address with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress deleteEmailAddress(
			long emailAddressId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.deleteEmailAddress(emailAddressId);
	}

	@Override
	public void deleteEmailAddresses(
		long companyId, java.lang.String className, long classPK) {

		_emailAddressLocalService.deleteEmailAddresses(
			companyId, className, classPK);
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel deletePersistedModel(
			com.liferay.portal.kernel.model.PersistedModel persistedModel)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.deletePersistedModel(persistedModel);
	}

	@Override
	public <T> T dslQuery(com.liferay.petra.sql.dsl.query.DSLQuery dslQuery) {
		return _emailAddressLocalService.dslQuery(dslQuery);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery() {
		return _emailAddressLocalService.dynamicQuery();
	}

	/**
	 * Performs a dynamic query on the database and returns the matching rows.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _emailAddressLocalService.dynamicQuery(dynamicQuery);
	}

	/**
	 * Performs a dynamic query on the database and returns a range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.EmailAddressModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @return the range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end) {

		return _emailAddressLocalService.dynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * Performs a dynamic query on the database and returns an ordered range of the matching rows.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.EmailAddressModelImpl</code>.
	 * </p>
	 *
	 * @param dynamicQuery the dynamic query
	 * @param start the lower bound of the range of model instances
	 * @param end the upper bound of the range of model instances (not inclusive)
	 * @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	 * @return the ordered range of matching rows
	 */
	@Override
	public <T> java.util.List<T> dynamicQuery(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery, int start,
		int end,
		com.liferay.portal.kernel.util.OrderByComparator<T> orderByComparator) {

		return _emailAddressLocalService.dynamicQuery(
			dynamicQuery, start, end, orderByComparator);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery) {

		return _emailAddressLocalService.dynamicQueryCount(dynamicQuery);
	}

	/**
	 * Returns the number of rows matching the dynamic query.
	 *
	 * @param dynamicQuery the dynamic query
	 * @param projection the projection to apply to the query
	 * @return the number of rows matching the dynamic query
	 */
	@Override
	public long dynamicQueryCount(
		com.liferay.portal.kernel.dao.orm.DynamicQuery dynamicQuery,
		com.liferay.portal.kernel.dao.orm.Projection projection) {

		return _emailAddressLocalService.dynamicQueryCount(
			dynamicQuery, projection);
	}

	@Override
	public com.liferay.portal.kernel.model.EmailAddress fetchEmailAddress(
		long emailAddressId) {

		return _emailAddressLocalService.fetchEmailAddress(emailAddressId);
	}

	/**
	 * Returns the email address with the matching UUID and company.
	 *
	 * @param uuid the email address's UUID
	 * @param companyId the primary key of the company
	 * @return the matching email address, or <code>null</code> if a matching email address could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress
		fetchEmailAddressByUuidAndCompanyId(
			java.lang.String uuid, long companyId) {

		return _emailAddressLocalService.fetchEmailAddressByUuidAndCompanyId(
			uuid, companyId);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery
		getActionableDynamicQuery() {

		return _emailAddressLocalService.getActionableDynamicQuery();
	}

	/**
	 * Returns the email address with the primary key.
	 *
	 * @param emailAddressId the primary key of the email address
	 * @return the email address
	 * @throws PortalException if a email address with the primary key could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress getEmailAddress(
			long emailAddressId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.getEmailAddress(emailAddressId);
	}

	/**
	 * Returns the email address with the matching UUID and company.
	 *
	 * @param uuid the email address's UUID
	 * @param companyId the primary key of the company
	 * @return the matching email address
	 * @throws PortalException if a matching email address could not be found
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress
			getEmailAddressByUuidAndCompanyId(
				java.lang.String uuid, long companyId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.getEmailAddressByUuidAndCompanyId(
			uuid, companyId);
	}

	@Override
	public java.util.List<com.liferay.portal.kernel.model.EmailAddress>
		getEmailAddresses() {

		return _emailAddressLocalService.getEmailAddresses();
	}

	/**
	 * Returns a range of all the email addresses.
	 *
	 * <p>
	 * Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to <code>com.liferay.portal.kernel.dao.orm.QueryUtil#ALL_POS</code> will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent, then the query will include the default ORDER BY logic from <code>com.liferay.portal.model.impl.EmailAddressModelImpl</code>.
	 * </p>
	 *
	 * @param start the lower bound of the range of email addresses
	 * @param end the upper bound of the range of email addresses (not inclusive)
	 * @return the range of email addresses
	 */
	@Override
	public java.util.List<com.liferay.portal.kernel.model.EmailAddress>
		getEmailAddresses(int start, int end) {

		return _emailAddressLocalService.getEmailAddresses(start, end);
	}

	@Override
	public java.util.List<com.liferay.portal.kernel.model.EmailAddress>
		getEmailAddresses(
			long companyId, java.lang.String className, long classPK) {

		return _emailAddressLocalService.getEmailAddresses(
			companyId, className, classPK);
	}

	/**
	 * Returns the number of email addresses.
	 *
	 * @return the number of email addresses
	 */
	@Override
	public int getEmailAddressesCount() {
		return _emailAddressLocalService.getEmailAddressesCount();
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery
		getExportActionableDynamicQuery(
			com.liferay.exportimport.kernel.lar.PortletDataContext
				portletDataContext) {

		return _emailAddressLocalService.getExportActionableDynamicQuery(
			portletDataContext);
	}

	@Override
	public com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery
		getIndexableActionableDynamicQuery() {

		return _emailAddressLocalService.getIndexableActionableDynamicQuery();
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public java.lang.String getOSGiServiceIdentifier() {
		return _emailAddressLocalService.getOSGiServiceIdentifier();
	}

	/**
	 * @throws PortalException
	 */
	@Override
	public com.liferay.portal.kernel.model.PersistedModel getPersistedModel(
			java.io.Serializable primaryKeyObj)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.getPersistedModel(primaryKeyObj);
	}

	/**
	 * Updates the email address in the database or adds it if it does not yet exist. Also notifies the appropriate model listeners.
	 *
	 * @param emailAddress the email address
	 * @return the email address that was updated
	 */
	@Override
	public com.liferay.portal.kernel.model.EmailAddress updateEmailAddress(
		com.liferay.portal.kernel.model.EmailAddress emailAddress) {

		return _emailAddressLocalService.updateEmailAddress(emailAddress);
	}

	@Override
	public com.liferay.portal.kernel.model.EmailAddress updateEmailAddress(
			long emailAddressId, java.lang.String address, long typeId,
			boolean primary)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _emailAddressLocalService.updateEmailAddress(
			emailAddressId, address, typeId, primary);
	}

	@Override
	public EmailAddressLocalService getWrappedService() {
		return _emailAddressLocalService;
	}

	@Override
	public void setWrappedService(
		EmailAddressLocalService emailAddressLocalService) {

		_emailAddressLocalService = emailAddressLocalService;
	}

	private EmailAddressLocalService _emailAddressLocalService;

}