/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyModel;
import com.liferay.portal.kernel.model.PasswordPolicySoap;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the PasswordPolicy service. Represents a row in the &quot;PasswordPolicy&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>PasswordPolicyModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PasswordPolicyImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see PasswordPolicyImpl
 * @generated
 */
@JSON(strict = true)
public class PasswordPolicyModelImpl
	extends BaseModelImpl<PasswordPolicy> implements PasswordPolicyModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a password policy model instance should use the <code>PasswordPolicy</code> interface instead.
	 */
	public static final String TABLE_NAME = "PasswordPolicy";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"passwordPolicyId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"defaultPolicy", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"changeable", Types.BOOLEAN},
		{"changeRequired", Types.BOOLEAN}, {"minAge", Types.BIGINT},
		{"checkSyntax", Types.BOOLEAN}, {"allowDictionaryWords", Types.BOOLEAN},
		{"minAlphanumeric", Types.INTEGER}, {"minLength", Types.INTEGER},
		{"minLowerCase", Types.INTEGER}, {"minNumbers", Types.INTEGER},
		{"minSymbols", Types.INTEGER}, {"minUpperCase", Types.INTEGER},
		{"regex", Types.VARCHAR}, {"history", Types.BOOLEAN},
		{"historyCount", Types.INTEGER}, {"expireable", Types.BOOLEAN},
		{"maxAge", Types.BIGINT}, {"warningTime", Types.BIGINT},
		{"graceLimit", Types.INTEGER}, {"lockout", Types.BOOLEAN},
		{"maxFailure", Types.INTEGER}, {"lockoutDuration", Types.BIGINT},
		{"requireUnlock", Types.BOOLEAN}, {"resetFailureCount", Types.BIGINT},
		{"resetTicketMaxAge", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("passwordPolicyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultPolicy", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("changeable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("changeRequired", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("minAge", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("checkSyntax", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("allowDictionaryWords", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("minAlphanumeric", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minLowerCase", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minNumbers", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minSymbols", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("minUpperCase", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("regex", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("history", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("historyCount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("expireable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maxAge", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("warningTime", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("graceLimit", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maxFailure", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockoutDuration", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("requireUnlock", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("resetFailureCount", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("resetTicketMaxAge", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table PasswordPolicy (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,passwordPolicyId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,defaultPolicy BOOLEAN,name VARCHAR(75) null,description STRING null,changeable BOOLEAN,changeRequired BOOLEAN,minAge LONG,checkSyntax BOOLEAN,allowDictionaryWords BOOLEAN,minAlphanumeric INTEGER,minLength INTEGER,minLowerCase INTEGER,minNumbers INTEGER,minSymbols INTEGER,minUpperCase INTEGER,regex STRING null,history BOOLEAN,historyCount INTEGER,expireable BOOLEAN,maxAge LONG,warningTime LONG,graceLimit INTEGER,lockout BOOLEAN,maxFailure INTEGER,lockoutDuration LONG,requireUnlock BOOLEAN,resetFailureCount LONG,resetTicketMaxAge LONG)";

	public static final String TABLE_SQL_DROP = "drop table PasswordPolicy";

	public static final String ORDER_BY_JPQL =
		" ORDER BY passwordPolicy.passwordPolicyId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY PasswordPolicy.passwordPolicyId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.entity.cache.enabled.com.liferay.portal.kernel.model.PasswordPolicy"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.finder.cache.enabled.com.liferay.portal.kernel.model.PasswordPolicy"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.column.bitmask.enabled.com.liferay.portal.kernel.model.PasswordPolicy"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long DEFAULTPOLICY_COLUMN_BITMASK = 2L;

	public static final long NAME_COLUMN_BITMASK = 4L;

	public static final long UUID_COLUMN_BITMASK = 8L;

	public static final long PASSWORDPOLICYID_COLUMN_BITMASK = 16L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static PasswordPolicy toModel(PasswordPolicySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		PasswordPolicy model = new PasswordPolicyImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setUuid(soapModel.getUuid());
		model.setPasswordPolicyId(soapModel.getPasswordPolicyId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setDefaultPolicy(soapModel.isDefaultPolicy());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setChangeable(soapModel.isChangeable());
		model.setChangeRequired(soapModel.isChangeRequired());
		model.setMinAge(soapModel.getMinAge());
		model.setCheckSyntax(soapModel.isCheckSyntax());
		model.setAllowDictionaryWords(soapModel.isAllowDictionaryWords());
		model.setMinAlphanumeric(soapModel.getMinAlphanumeric());
		model.setMinLength(soapModel.getMinLength());
		model.setMinLowerCase(soapModel.getMinLowerCase());
		model.setMinNumbers(soapModel.getMinNumbers());
		model.setMinSymbols(soapModel.getMinSymbols());
		model.setMinUpperCase(soapModel.getMinUpperCase());
		model.setRegex(soapModel.getRegex());
		model.setHistory(soapModel.isHistory());
		model.setHistoryCount(soapModel.getHistoryCount());
		model.setExpireable(soapModel.isExpireable());
		model.setMaxAge(soapModel.getMaxAge());
		model.setWarningTime(soapModel.getWarningTime());
		model.setGraceLimit(soapModel.getGraceLimit());
		model.setLockout(soapModel.isLockout());
		model.setMaxFailure(soapModel.getMaxFailure());
		model.setLockoutDuration(soapModel.getLockoutDuration());
		model.setRequireUnlock(soapModel.isRequireUnlock());
		model.setResetFailureCount(soapModel.getResetFailureCount());
		model.setResetTicketMaxAge(soapModel.getResetTicketMaxAge());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<PasswordPolicy> toModels(
		PasswordPolicySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<PasswordPolicy> models = new ArrayList<PasswordPolicy>(
			soapModels.length);

		for (PasswordPolicySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.PasswordPolicy"));

	public PasswordPolicyModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _passwordPolicyId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setPasswordPolicyId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _passwordPolicyId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return PasswordPolicy.class;
	}

	@Override
	public String getModelClassName() {
		return PasswordPolicy.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<PasswordPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PasswordPolicy, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((PasswordPolicy)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<PasswordPolicy, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<PasswordPolicy, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(PasswordPolicy)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<PasswordPolicy, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<PasswordPolicy, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, PasswordPolicy>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			PasswordPolicy.class.getClassLoader(), PasswordPolicy.class,
			ModelWrapper.class);

		try {
			Constructor<PasswordPolicy> constructor =
				(Constructor<PasswordPolicy>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<PasswordPolicy, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<PasswordPolicy, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<PasswordPolicy, Object>>();
		Map<String, BiConsumer<PasswordPolicy, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<PasswordPolicy, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", PasswordPolicy::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMvccVersion);
		attributeGetterFunctions.put("uuid", PasswordPolicy::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setUuid);
		attributeGetterFunctions.put(
			"passwordPolicyId", PasswordPolicy::getPasswordPolicyId);
		attributeSetterBiConsumers.put(
			"passwordPolicyId",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setPasswordPolicyId);
		attributeGetterFunctions.put("companyId", PasswordPolicy::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setCompanyId);
		attributeGetterFunctions.put("userId", PasswordPolicy::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setUserId);
		attributeGetterFunctions.put("userName", PasswordPolicy::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setUserName);
		attributeGetterFunctions.put(
			"createDate", PasswordPolicy::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<PasswordPolicy, Date>)PasswordPolicy::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", PasswordPolicy::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<PasswordPolicy, Date>)PasswordPolicy::setModifiedDate);
		attributeGetterFunctions.put(
			"defaultPolicy", PasswordPolicy::getDefaultPolicy);
		attributeSetterBiConsumers.put(
			"defaultPolicy",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setDefaultPolicy);
		attributeGetterFunctions.put("name", PasswordPolicy::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setName);
		attributeGetterFunctions.put(
			"description", PasswordPolicy::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setDescription);
		attributeGetterFunctions.put(
			"changeable", PasswordPolicy::getChangeable);
		attributeSetterBiConsumers.put(
			"changeable",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setChangeable);
		attributeGetterFunctions.put(
			"changeRequired", PasswordPolicy::getChangeRequired);
		attributeSetterBiConsumers.put(
			"changeRequired",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setChangeRequired);
		attributeGetterFunctions.put("minAge", PasswordPolicy::getMinAge);
		attributeSetterBiConsumers.put(
			"minAge",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMinAge);
		attributeGetterFunctions.put(
			"checkSyntax", PasswordPolicy::getCheckSyntax);
		attributeSetterBiConsumers.put(
			"checkSyntax",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setCheckSyntax);
		attributeGetterFunctions.put(
			"allowDictionaryWords", PasswordPolicy::getAllowDictionaryWords);
		attributeSetterBiConsumers.put(
			"allowDictionaryWords",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setAllowDictionaryWords);
		attributeGetterFunctions.put(
			"minAlphanumeric", PasswordPolicy::getMinAlphanumeric);
		attributeSetterBiConsumers.put(
			"minAlphanumeric",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinAlphanumeric);
		attributeGetterFunctions.put("minLength", PasswordPolicy::getMinLength);
		attributeSetterBiConsumers.put(
			"minLength",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinLength);
		attributeGetterFunctions.put(
			"minLowerCase", PasswordPolicy::getMinLowerCase);
		attributeSetterBiConsumers.put(
			"minLowerCase",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinLowerCase);
		attributeGetterFunctions.put(
			"minNumbers", PasswordPolicy::getMinNumbers);
		attributeSetterBiConsumers.put(
			"minNumbers",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinNumbers);
		attributeGetterFunctions.put(
			"minSymbols", PasswordPolicy::getMinSymbols);
		attributeSetterBiConsumers.put(
			"minSymbols",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMinSymbols);
		attributeGetterFunctions.put(
			"minUpperCase", PasswordPolicy::getMinUpperCase);
		attributeSetterBiConsumers.put(
			"minUpperCase",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setMinUpperCase);
		attributeGetterFunctions.put("regex", PasswordPolicy::getRegex);
		attributeSetterBiConsumers.put(
			"regex",
			(BiConsumer<PasswordPolicy, String>)PasswordPolicy::setRegex);
		attributeGetterFunctions.put("history", PasswordPolicy::getHistory);
		attributeSetterBiConsumers.put(
			"history",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setHistory);
		attributeGetterFunctions.put(
			"historyCount", PasswordPolicy::getHistoryCount);
		attributeSetterBiConsumers.put(
			"historyCount",
			(BiConsumer<PasswordPolicy, Integer>)
				PasswordPolicy::setHistoryCount);
		attributeGetterFunctions.put(
			"expireable", PasswordPolicy::getExpireable);
		attributeSetterBiConsumers.put(
			"expireable",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setExpireable);
		attributeGetterFunctions.put("maxAge", PasswordPolicy::getMaxAge);
		attributeSetterBiConsumers.put(
			"maxAge",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setMaxAge);
		attributeGetterFunctions.put(
			"warningTime", PasswordPolicy::getWarningTime);
		attributeSetterBiConsumers.put(
			"warningTime",
			(BiConsumer<PasswordPolicy, Long>)PasswordPolicy::setWarningTime);
		attributeGetterFunctions.put(
			"graceLimit", PasswordPolicy::getGraceLimit);
		attributeSetterBiConsumers.put(
			"graceLimit",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setGraceLimit);
		attributeGetterFunctions.put("lockout", PasswordPolicy::getLockout);
		attributeSetterBiConsumers.put(
			"lockout",
			(BiConsumer<PasswordPolicy, Boolean>)PasswordPolicy::setLockout);
		attributeGetterFunctions.put(
			"maxFailure", PasswordPolicy::getMaxFailure);
		attributeSetterBiConsumers.put(
			"maxFailure",
			(BiConsumer<PasswordPolicy, Integer>)PasswordPolicy::setMaxFailure);
		attributeGetterFunctions.put(
			"lockoutDuration", PasswordPolicy::getLockoutDuration);
		attributeSetterBiConsumers.put(
			"lockoutDuration",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setLockoutDuration);
		attributeGetterFunctions.put(
			"requireUnlock", PasswordPolicy::getRequireUnlock);
		attributeSetterBiConsumers.put(
			"requireUnlock",
			(BiConsumer<PasswordPolicy, Boolean>)
				PasswordPolicy::setRequireUnlock);
		attributeGetterFunctions.put(
			"resetFailureCount", PasswordPolicy::getResetFailureCount);
		attributeSetterBiConsumers.put(
			"resetFailureCount",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setResetFailureCount);
		attributeGetterFunctions.put(
			"resetTicketMaxAge", PasswordPolicy::getResetTicketMaxAge);
		attributeSetterBiConsumers.put(
			"resetTicketMaxAge",
			(BiConsumer<PasswordPolicy, Long>)
				PasswordPolicy::setResetTicketMaxAge);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getPasswordPolicyId() {
		return _passwordPolicyId;
	}

	@Override
	public void setPasswordPolicyId(long passwordPolicyId) {
		_passwordPolicyId = passwordPolicyId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public boolean getDefaultPolicy() {
		return _defaultPolicy;
	}

	@JSON
	@Override
	public boolean isDefaultPolicy() {
		return _defaultPolicy;
	}

	@Override
	public void setDefaultPolicy(boolean defaultPolicy) {
		_columnBitmask |= DEFAULTPOLICY_COLUMN_BITMASK;

		if (!_setOriginalDefaultPolicy) {
			_setOriginalDefaultPolicy = true;

			_originalDefaultPolicy = _defaultPolicy;
		}

		_defaultPolicy = defaultPolicy;
	}

	public boolean getOriginalDefaultPolicy() {
		return _originalDefaultPolicy;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask |= NAME_COLUMN_BITMASK;

		if (_originalName == null) {
			_originalName = _name;
		}

		_name = name;
	}

	public String getOriginalName() {
		return GetterUtil.getString(_originalName);
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public boolean getChangeable() {
		return _changeable;
	}

	@JSON
	@Override
	public boolean isChangeable() {
		return _changeable;
	}

	@Override
	public void setChangeable(boolean changeable) {
		_changeable = changeable;
	}

	@JSON
	@Override
	public boolean getChangeRequired() {
		return _changeRequired;
	}

	@JSON
	@Override
	public boolean isChangeRequired() {
		return _changeRequired;
	}

	@Override
	public void setChangeRequired(boolean changeRequired) {
		_changeRequired = changeRequired;
	}

	@JSON
	@Override
	public long getMinAge() {
		return _minAge;
	}

	@Override
	public void setMinAge(long minAge) {
		_minAge = minAge;
	}

	@JSON
	@Override
	public boolean getCheckSyntax() {
		return _checkSyntax;
	}

	@JSON
	@Override
	public boolean isCheckSyntax() {
		return _checkSyntax;
	}

	@Override
	public void setCheckSyntax(boolean checkSyntax) {
		_checkSyntax = checkSyntax;
	}

	@JSON
	@Override
	public boolean getAllowDictionaryWords() {
		return _allowDictionaryWords;
	}

	@JSON
	@Override
	public boolean isAllowDictionaryWords() {
		return _allowDictionaryWords;
	}

	@Override
	public void setAllowDictionaryWords(boolean allowDictionaryWords) {
		_allowDictionaryWords = allowDictionaryWords;
	}

	@JSON
	@Override
	public int getMinAlphanumeric() {
		return _minAlphanumeric;
	}

	@Override
	public void setMinAlphanumeric(int minAlphanumeric) {
		_minAlphanumeric = minAlphanumeric;
	}

	@JSON
	@Override
	public int getMinLength() {
		return _minLength;
	}

	@Override
	public void setMinLength(int minLength) {
		_minLength = minLength;
	}

	@JSON
	@Override
	public int getMinLowerCase() {
		return _minLowerCase;
	}

	@Override
	public void setMinLowerCase(int minLowerCase) {
		_minLowerCase = minLowerCase;
	}

	@JSON
	@Override
	public int getMinNumbers() {
		return _minNumbers;
	}

	@Override
	public void setMinNumbers(int minNumbers) {
		_minNumbers = minNumbers;
	}

	@JSON
	@Override
	public int getMinSymbols() {
		return _minSymbols;
	}

	@Override
	public void setMinSymbols(int minSymbols) {
		_minSymbols = minSymbols;
	}

	@JSON
	@Override
	public int getMinUpperCase() {
		return _minUpperCase;
	}

	@Override
	public void setMinUpperCase(int minUpperCase) {
		_minUpperCase = minUpperCase;
	}

	@JSON
	@Override
	public String getRegex() {
		if (_regex == null) {
			return "";
		}
		else {
			return _regex;
		}
	}

	@Override
	public void setRegex(String regex) {
		_regex = regex;
	}

	@JSON
	@Override
	public boolean getHistory() {
		return _history;
	}

	@JSON
	@Override
	public boolean isHistory() {
		return _history;
	}

	@Override
	public void setHistory(boolean history) {
		_history = history;
	}

	@JSON
	@Override
	public int getHistoryCount() {
		return _historyCount;
	}

	@Override
	public void setHistoryCount(int historyCount) {
		_historyCount = historyCount;
	}

	@JSON
	@Override
	public boolean getExpireable() {
		return _expireable;
	}

	@JSON
	@Override
	public boolean isExpireable() {
		return _expireable;
	}

	@Override
	public void setExpireable(boolean expireable) {
		_expireable = expireable;
	}

	@JSON
	@Override
	public long getMaxAge() {
		return _maxAge;
	}

	@Override
	public void setMaxAge(long maxAge) {
		_maxAge = maxAge;
	}

	@JSON
	@Override
	public long getWarningTime() {
		return _warningTime;
	}

	@Override
	public void setWarningTime(long warningTime) {
		_warningTime = warningTime;
	}

	@JSON
	@Override
	public int getGraceLimit() {
		return _graceLimit;
	}

	@Override
	public void setGraceLimit(int graceLimit) {
		_graceLimit = graceLimit;
	}

	@JSON
	@Override
	public boolean getLockout() {
		return _lockout;
	}

	@JSON
	@Override
	public boolean isLockout() {
		return _lockout;
	}

	@Override
	public void setLockout(boolean lockout) {
		_lockout = lockout;
	}

	@JSON
	@Override
	public int getMaxFailure() {
		return _maxFailure;
	}

	@Override
	public void setMaxFailure(int maxFailure) {
		_maxFailure = maxFailure;
	}

	@JSON
	@Override
	public long getLockoutDuration() {
		return _lockoutDuration;
	}

	@Override
	public void setLockoutDuration(long lockoutDuration) {
		_lockoutDuration = lockoutDuration;
	}

	@JSON
	@Override
	public boolean getRequireUnlock() {
		return _requireUnlock;
	}

	@JSON
	@Override
	public boolean isRequireUnlock() {
		return _requireUnlock;
	}

	@Override
	public void setRequireUnlock(boolean requireUnlock) {
		_requireUnlock = requireUnlock;
	}

	@JSON
	@Override
	public long getResetFailureCount() {
		return _resetFailureCount;
	}

	@Override
	public void setResetFailureCount(long resetFailureCount) {
		_resetFailureCount = resetFailureCount;
	}

	@JSON
	@Override
	public long getResetTicketMaxAge() {
		return _resetTicketMaxAge;
	}

	@Override
	public void setResetTicketMaxAge(long resetTicketMaxAge) {
		_resetTicketMaxAge = resetTicketMaxAge;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(PasswordPolicy.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), PasswordPolicy.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public PasswordPolicy toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, PasswordPolicy>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		PasswordPolicyImpl passwordPolicyImpl = new PasswordPolicyImpl();

		passwordPolicyImpl.setMvccVersion(getMvccVersion());
		passwordPolicyImpl.setUuid(getUuid());
		passwordPolicyImpl.setPasswordPolicyId(getPasswordPolicyId());
		passwordPolicyImpl.setCompanyId(getCompanyId());
		passwordPolicyImpl.setUserId(getUserId());
		passwordPolicyImpl.setUserName(getUserName());
		passwordPolicyImpl.setCreateDate(getCreateDate());
		passwordPolicyImpl.setModifiedDate(getModifiedDate());
		passwordPolicyImpl.setDefaultPolicy(isDefaultPolicy());
		passwordPolicyImpl.setName(getName());
		passwordPolicyImpl.setDescription(getDescription());
		passwordPolicyImpl.setChangeable(isChangeable());
		passwordPolicyImpl.setChangeRequired(isChangeRequired());
		passwordPolicyImpl.setMinAge(getMinAge());
		passwordPolicyImpl.setCheckSyntax(isCheckSyntax());
		passwordPolicyImpl.setAllowDictionaryWords(isAllowDictionaryWords());
		passwordPolicyImpl.setMinAlphanumeric(getMinAlphanumeric());
		passwordPolicyImpl.setMinLength(getMinLength());
		passwordPolicyImpl.setMinLowerCase(getMinLowerCase());
		passwordPolicyImpl.setMinNumbers(getMinNumbers());
		passwordPolicyImpl.setMinSymbols(getMinSymbols());
		passwordPolicyImpl.setMinUpperCase(getMinUpperCase());
		passwordPolicyImpl.setRegex(getRegex());
		passwordPolicyImpl.setHistory(isHistory());
		passwordPolicyImpl.setHistoryCount(getHistoryCount());
		passwordPolicyImpl.setExpireable(isExpireable());
		passwordPolicyImpl.setMaxAge(getMaxAge());
		passwordPolicyImpl.setWarningTime(getWarningTime());
		passwordPolicyImpl.setGraceLimit(getGraceLimit());
		passwordPolicyImpl.setLockout(isLockout());
		passwordPolicyImpl.setMaxFailure(getMaxFailure());
		passwordPolicyImpl.setLockoutDuration(getLockoutDuration());
		passwordPolicyImpl.setRequireUnlock(isRequireUnlock());
		passwordPolicyImpl.setResetFailureCount(getResetFailureCount());
		passwordPolicyImpl.setResetTicketMaxAge(getResetTicketMaxAge());

		passwordPolicyImpl.resetOriginalValues();

		return passwordPolicyImpl;
	}

	@Override
	public int compareTo(PasswordPolicy passwordPolicy) {
		long primaryKey = passwordPolicy.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof PasswordPolicy)) {
			return false;
		}

		PasswordPolicy passwordPolicy = (PasswordPolicy)obj;

		long primaryKey = passwordPolicy.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		PasswordPolicyModelImpl passwordPolicyModelImpl = this;

		passwordPolicyModelImpl._originalUuid = passwordPolicyModelImpl._uuid;

		passwordPolicyModelImpl._originalCompanyId =
			passwordPolicyModelImpl._companyId;

		passwordPolicyModelImpl._setOriginalCompanyId = false;

		passwordPolicyModelImpl._setModifiedDate = false;

		passwordPolicyModelImpl._originalDefaultPolicy =
			passwordPolicyModelImpl._defaultPolicy;

		passwordPolicyModelImpl._setOriginalDefaultPolicy = false;

		passwordPolicyModelImpl._originalName = passwordPolicyModelImpl._name;

		passwordPolicyModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<PasswordPolicy> toCacheModel() {
		PasswordPolicyCacheModel passwordPolicyCacheModel =
			new PasswordPolicyCacheModel();

		passwordPolicyCacheModel.mvccVersion = getMvccVersion();

		passwordPolicyCacheModel.uuid = getUuid();

		String uuid = passwordPolicyCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			passwordPolicyCacheModel.uuid = null;
		}

		passwordPolicyCacheModel.passwordPolicyId = getPasswordPolicyId();

		passwordPolicyCacheModel.companyId = getCompanyId();

		passwordPolicyCacheModel.userId = getUserId();

		passwordPolicyCacheModel.userName = getUserName();

		String userName = passwordPolicyCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			passwordPolicyCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			passwordPolicyCacheModel.createDate = createDate.getTime();
		}
		else {
			passwordPolicyCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			passwordPolicyCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			passwordPolicyCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		passwordPolicyCacheModel.defaultPolicy = isDefaultPolicy();

		passwordPolicyCacheModel.name = getName();

		String name = passwordPolicyCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			passwordPolicyCacheModel.name = null;
		}

		passwordPolicyCacheModel.description = getDescription();

		String description = passwordPolicyCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			passwordPolicyCacheModel.description = null;
		}

		passwordPolicyCacheModel.changeable = isChangeable();

		passwordPolicyCacheModel.changeRequired = isChangeRequired();

		passwordPolicyCacheModel.minAge = getMinAge();

		passwordPolicyCacheModel.checkSyntax = isCheckSyntax();

		passwordPolicyCacheModel.allowDictionaryWords =
			isAllowDictionaryWords();

		passwordPolicyCacheModel.minAlphanumeric = getMinAlphanumeric();

		passwordPolicyCacheModel.minLength = getMinLength();

		passwordPolicyCacheModel.minLowerCase = getMinLowerCase();

		passwordPolicyCacheModel.minNumbers = getMinNumbers();

		passwordPolicyCacheModel.minSymbols = getMinSymbols();

		passwordPolicyCacheModel.minUpperCase = getMinUpperCase();

		passwordPolicyCacheModel.regex = getRegex();

		String regex = passwordPolicyCacheModel.regex;

		if ((regex != null) && (regex.length() == 0)) {
			passwordPolicyCacheModel.regex = null;
		}

		passwordPolicyCacheModel.history = isHistory();

		passwordPolicyCacheModel.historyCount = getHistoryCount();

		passwordPolicyCacheModel.expireable = isExpireable();

		passwordPolicyCacheModel.maxAge = getMaxAge();

		passwordPolicyCacheModel.warningTime = getWarningTime();

		passwordPolicyCacheModel.graceLimit = getGraceLimit();

		passwordPolicyCacheModel.lockout = isLockout();

		passwordPolicyCacheModel.maxFailure = getMaxFailure();

		passwordPolicyCacheModel.lockoutDuration = getLockoutDuration();

		passwordPolicyCacheModel.requireUnlock = isRequireUnlock();

		passwordPolicyCacheModel.resetFailureCount = getResetFailureCount();

		passwordPolicyCacheModel.resetTicketMaxAge = getResetTicketMaxAge();

		return passwordPolicyCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<PasswordPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PasswordPolicy, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((PasswordPolicy)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<PasswordPolicy, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<PasswordPolicy, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<PasswordPolicy, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((PasswordPolicy)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, PasswordPolicy>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private String _originalUuid;
	private long _passwordPolicyId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _defaultPolicy;
	private boolean _originalDefaultPolicy;
	private boolean _setOriginalDefaultPolicy;
	private String _name;
	private String _originalName;
	private String _description;
	private boolean _changeable;
	private boolean _changeRequired;
	private long _minAge;
	private boolean _checkSyntax;
	private boolean _allowDictionaryWords;
	private int _minAlphanumeric;
	private int _minLength;
	private int _minLowerCase;
	private int _minNumbers;
	private int _minSymbols;
	private int _minUpperCase;
	private String _regex;
	private boolean _history;
	private int _historyCount;
	private boolean _expireable;
	private long _maxAge;
	private long _warningTime;
	private int _graceLimit;
	private boolean _lockout;
	private int _maxFailure;
	private long _lockoutDuration;
	private boolean _requireUnlock;
	private long _resetFailureCount;
	private long _resetTicketMaxAge;
	private long _columnBitmask;
	private PasswordPolicy _escapedModel;

}