/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserModel;
import com.liferay.portal.kernel.model.UserSoap;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the User service. Represents a row in the &quot;User_&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>UserModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link UserImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see UserImpl
 * @generated
 */
@JSON(strict = true)
public class UserModelImpl extends BaseModelImpl<User> implements UserModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a user model instance should use the <code>User</code> interface instead.
	 */
	public static final String TABLE_NAME = "User_";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"userId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"defaultUser", Types.BOOLEAN}, {"contactId", Types.BIGINT},
		{"password_", Types.VARCHAR}, {"passwordEncrypted", Types.BOOLEAN},
		{"passwordReset", Types.BOOLEAN},
		{"passwordModifiedDate", Types.TIMESTAMP}, {"digest", Types.VARCHAR},
		{"reminderQueryQuestion", Types.VARCHAR},
		{"reminderQueryAnswer", Types.VARCHAR},
		{"graceLoginCount", Types.INTEGER}, {"screenName", Types.VARCHAR},
		{"emailAddress", Types.VARCHAR}, {"facebookId", Types.BIGINT},
		{"googleUserId", Types.VARCHAR}, {"ldapServerId", Types.BIGINT},
		{"openId", Types.VARCHAR}, {"portraitId", Types.BIGINT},
		{"languageId", Types.VARCHAR}, {"timeZoneId", Types.VARCHAR},
		{"greeting", Types.VARCHAR}, {"comments", Types.VARCHAR},
		{"firstName", Types.VARCHAR}, {"middleName", Types.VARCHAR},
		{"lastName", Types.VARCHAR}, {"jobTitle", Types.VARCHAR},
		{"loginDate", Types.TIMESTAMP}, {"loginIP", Types.VARCHAR},
		{"lastLoginDate", Types.TIMESTAMP}, {"lastLoginIP", Types.VARCHAR},
		{"lastFailedLoginDate", Types.TIMESTAMP},
		{"failedLoginAttempts", Types.INTEGER}, {"lockout", Types.BOOLEAN},
		{"lockoutDate", Types.TIMESTAMP}, {"agreedToTermsOfUse", Types.BOOLEAN},
		{"emailAddressVerified", Types.BOOLEAN}, {"status", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("defaultUser", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("contactId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("password_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("passwordEncrypted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("passwordReset", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("passwordModifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("digest", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("reminderQueryQuestion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("reminderQueryAnswer", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("graceLoginCount", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("screenName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("emailAddress", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("facebookId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("googleUserId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("ldapServerId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("openId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("portraitId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("languageId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("timeZoneId", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("greeting", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("comments", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("firstName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("middleName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("jobTitle", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("loginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("loginIP", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastLoginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lastLoginIP", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastFailedLoginDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("failedLoginAttempts", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lockout", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lockoutDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("agreedToTermsOfUse", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("emailAddressVerified", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table User_ (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,userId LONG not null,companyId LONG,createDate DATE null,modifiedDate DATE null,defaultUser BOOLEAN,contactId LONG,password_ VARCHAR(75) null,passwordEncrypted BOOLEAN,passwordReset BOOLEAN,passwordModifiedDate DATE null,digest VARCHAR(255) null,reminderQueryQuestion VARCHAR(75) null,reminderQueryAnswer VARCHAR(75) null,graceLoginCount INTEGER,screenName VARCHAR(75) null,emailAddress VARCHAR(254) null,facebookId LONG,googleUserId VARCHAR(75) null,ldapServerId LONG,openId VARCHAR(1024) null,portraitId LONG,languageId VARCHAR(75) null,timeZoneId VARCHAR(75) null,greeting VARCHAR(255) null,comments STRING null,firstName VARCHAR(75) null,middleName VARCHAR(75) null,lastName VARCHAR(75) null,jobTitle VARCHAR(100) null,loginDate DATE null,loginIP VARCHAR(75) null,lastLoginDate DATE null,lastLoginIP VARCHAR(75) null,lastFailedLoginDate DATE null,failedLoginAttempts INTEGER,lockout BOOLEAN,lockoutDate DATE null,agreedToTermsOfUse BOOLEAN,emailAddressVerified BOOLEAN,status INTEGER,primary key (userId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table User_";

	public static final String ORDER_BY_JPQL = " ORDER BY user.userId ASC";

	public static final String ORDER_BY_SQL = " ORDER BY User_.userId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.entity.cache.enabled.com.liferay.portal.kernel.model.User"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.finder.cache.enabled.com.liferay.portal.kernel.model.User"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.column.bitmask.enabled.com.liferay.portal.kernel.model.User"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long CONTACTID_COLUMN_BITMASK = 2L;

	public static final long CREATEDATE_COLUMN_BITMASK = 4L;

	public static final long DEFAULTUSER_COLUMN_BITMASK = 8L;

	public static final long EMAILADDRESS_COLUMN_BITMASK = 16L;

	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	public static final long FACEBOOKID_COLUMN_BITMASK = 64L;

	public static final long GOOGLEUSERID_COLUMN_BITMASK = 128L;

	public static final long MODIFIEDDATE_COLUMN_BITMASK = 256L;

	public static final long OPENID_COLUMN_BITMASK = 512L;

	public static final long PORTRAITID_COLUMN_BITMASK = 1024L;

	public static final long SCREENNAME_COLUMN_BITMASK = 2048L;

	public static final long STATUS_COLUMN_BITMASK = 4096L;

	public static final long USERID_COLUMN_BITMASK = 8192L;

	public static final long UUID_COLUMN_BITMASK = 16384L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static User toModel(UserSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		User model = new UserImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setUserId(soapModel.getUserId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setDefaultUser(soapModel.isDefaultUser());
		model.setContactId(soapModel.getContactId());
		model.setPassword(soapModel.getPassword());
		model.setPasswordEncrypted(soapModel.isPasswordEncrypted());
		model.setPasswordReset(soapModel.isPasswordReset());
		model.setPasswordModifiedDate(soapModel.getPasswordModifiedDate());
		model.setDigest(soapModel.getDigest());
		model.setReminderQueryQuestion(soapModel.getReminderQueryQuestion());
		model.setReminderQueryAnswer(soapModel.getReminderQueryAnswer());
		model.setGraceLoginCount(soapModel.getGraceLoginCount());
		model.setScreenName(soapModel.getScreenName());
		model.setEmailAddress(soapModel.getEmailAddress());
		model.setFacebookId(soapModel.getFacebookId());
		model.setGoogleUserId(soapModel.getGoogleUserId());
		model.setLdapServerId(soapModel.getLdapServerId());
		model.setOpenId(soapModel.getOpenId());
		model.setPortraitId(soapModel.getPortraitId());
		model.setLanguageId(soapModel.getLanguageId());
		model.setTimeZoneId(soapModel.getTimeZoneId());
		model.setGreeting(soapModel.getGreeting());
		model.setComments(soapModel.getComments());
		model.setFirstName(soapModel.getFirstName());
		model.setMiddleName(soapModel.getMiddleName());
		model.setLastName(soapModel.getLastName());
		model.setJobTitle(soapModel.getJobTitle());
		model.setLoginDate(soapModel.getLoginDate());
		model.setLoginIP(soapModel.getLoginIP());
		model.setLastLoginDate(soapModel.getLastLoginDate());
		model.setLastLoginIP(soapModel.getLastLoginIP());
		model.setLastFailedLoginDate(soapModel.getLastFailedLoginDate());
		model.setFailedLoginAttempts(soapModel.getFailedLoginAttempts());
		model.setLockout(soapModel.isLockout());
		model.setLockoutDate(soapModel.getLockoutDate());
		model.setAgreedToTermsOfUse(soapModel.isAgreedToTermsOfUse());
		model.setEmailAddressVerified(soapModel.isEmailAddressVerified());
		model.setStatus(soapModel.getStatus());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<User> toModels(UserSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<User> models = new ArrayList<User>(soapModels.length);

		for (UserSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final String MAPPING_TABLE_USERS_GROUPS_NAME = "Users_Groups";

	public static final Object[][] MAPPING_TABLE_USERS_GROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_GROUPS_SQL_CREATE =
		"create table Users_Groups (companyId LONG not null,groupId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (groupId, userId, ctCollectionId))";

	public static final boolean FINDER_CACHE_ENABLED_USERS_GROUPS =
		GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Groups"),
			true);

	public static final String MAPPING_TABLE_USERS_ORGS_NAME = "Users_Orgs";

	public static final Object[][] MAPPING_TABLE_USERS_ORGS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"organizationId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_ORGS_SQL_CREATE =
		"create table Users_Orgs (companyId LONG not null,organizationId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (organizationId, userId, ctCollectionId))";

	public static final boolean FINDER_CACHE_ENABLED_USERS_ORGS =
		GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Orgs"),
			true);

	public static final String MAPPING_TABLE_USERS_ROLES_NAME = "Users_Roles";

	public static final Object[][] MAPPING_TABLE_USERS_ROLES_COLUMNS = {
		{"companyId", Types.BIGINT}, {"roleId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_ROLES_SQL_CREATE =
		"create table Users_Roles (companyId LONG not null,roleId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (roleId, userId, ctCollectionId))";

	public static final boolean FINDER_CACHE_ENABLED_USERS_ROLES =
		GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Roles"),
			true);

	public static final String MAPPING_TABLE_USERS_TEAMS_NAME = "Users_Teams";

	public static final Object[][] MAPPING_TABLE_USERS_TEAMS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"teamId", Types.BIGINT},
		{"userId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_TEAMS_SQL_CREATE =
		"create table Users_Teams (companyId LONG not null,teamId LONG not null,userId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (teamId, userId, ctCollectionId))";

	public static final boolean FINDER_CACHE_ENABLED_USERS_TEAMS =
		GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_Teams"),
			true);

	public static final String MAPPING_TABLE_USERS_USERGROUPS_NAME =
		"Users_UserGroups";

	public static final Object[][] MAPPING_TABLE_USERS_USERGROUPS_COLUMNS = {
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userGroupId", Types.BIGINT}
	};

	public static final String MAPPING_TABLE_USERS_USERGROUPS_SQL_CREATE =
		"create table Users_UserGroups (companyId LONG not null,userId LONG not null,userGroupId LONG not null,ctCollectionId LONG default 0 not null,ctChangeType BOOLEAN,primary key (userId, userGroupId, ctCollectionId))";

	public static final boolean FINDER_CACHE_ENABLED_USERS_USERGROUPS =
		GetterUtil.getBoolean(
			com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.Users_UserGroups"),
			true);

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.portal.kernel.model.User"));

	public UserModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _userId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setUserId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _userId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return User.class;
	}

	@Override
	public String getModelClassName() {
		return User.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName, attributeGetterFunction.apply((User)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<User, Object>> attributeSetterBiConsumers =
			getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<User, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept((User)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<User, Object>> getAttributeGetterFunctions() {
		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<User, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, User>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			User.class.getClassLoader(), User.class, ModelWrapper.class);

		try {
			Constructor<User> constructor =
				(Constructor<User>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<User, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<User, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<User, Object>>();
		Map<String, BiConsumer<User, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<User, ?>>();

		attributeGetterFunctions.put("mvccVersion", User::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion", (BiConsumer<User, Long>)User::setMvccVersion);
		attributeGetterFunctions.put("ctCollectionId", User::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId", (BiConsumer<User, Long>)User::setCtCollectionId);
		attributeGetterFunctions.put("uuid", User::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<User, String>)User::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode", User::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<User, String>)User::setExternalReferenceCode);
		attributeGetterFunctions.put("userId", User::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<User, Long>)User::setUserId);
		attributeGetterFunctions.put("companyId", User::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId", (BiConsumer<User, Long>)User::setCompanyId);
		attributeGetterFunctions.put("createDate", User::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate", (BiConsumer<User, Date>)User::setCreateDate);
		attributeGetterFunctions.put("modifiedDate", User::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate", (BiConsumer<User, Date>)User::setModifiedDate);
		attributeGetterFunctions.put("defaultUser", User::getDefaultUser);
		attributeSetterBiConsumers.put(
			"defaultUser", (BiConsumer<User, Boolean>)User::setDefaultUser);
		attributeGetterFunctions.put("contactId", User::getContactId);
		attributeSetterBiConsumers.put(
			"contactId", (BiConsumer<User, Long>)User::setContactId);
		attributeGetterFunctions.put("password", User::getPassword);
		attributeSetterBiConsumers.put(
			"password", (BiConsumer<User, String>)User::setPassword);
		attributeGetterFunctions.put(
			"passwordEncrypted", User::getPasswordEncrypted);
		attributeSetterBiConsumers.put(
			"passwordEncrypted",
			(BiConsumer<User, Boolean>)User::setPasswordEncrypted);
		attributeGetterFunctions.put("passwordReset", User::getPasswordReset);
		attributeSetterBiConsumers.put(
			"passwordReset", (BiConsumer<User, Boolean>)User::setPasswordReset);
		attributeGetterFunctions.put(
			"passwordModifiedDate", User::getPasswordModifiedDate);
		attributeSetterBiConsumers.put(
			"passwordModifiedDate",
			(BiConsumer<User, Date>)User::setPasswordModifiedDate);
		attributeGetterFunctions.put("digest", User::getDigest);
		attributeSetterBiConsumers.put(
			"digest", (BiConsumer<User, String>)User::setDigest);
		attributeGetterFunctions.put(
			"reminderQueryQuestion", User::getReminderQueryQuestion);
		attributeSetterBiConsumers.put(
			"reminderQueryQuestion",
			(BiConsumer<User, String>)User::setReminderQueryQuestion);
		attributeGetterFunctions.put(
			"reminderQueryAnswer", User::getReminderQueryAnswer);
		attributeSetterBiConsumers.put(
			"reminderQueryAnswer",
			(BiConsumer<User, String>)User::setReminderQueryAnswer);
		attributeGetterFunctions.put(
			"graceLoginCount", User::getGraceLoginCount);
		attributeSetterBiConsumers.put(
			"graceLoginCount",
			(BiConsumer<User, Integer>)User::setGraceLoginCount);
		attributeGetterFunctions.put("screenName", User::getScreenName);
		attributeSetterBiConsumers.put(
			"screenName", (BiConsumer<User, String>)User::setScreenName);
		attributeGetterFunctions.put("emailAddress", User::getEmailAddress);
		attributeSetterBiConsumers.put(
			"emailAddress", (BiConsumer<User, String>)User::setEmailAddress);
		attributeGetterFunctions.put("facebookId", User::getFacebookId);
		attributeSetterBiConsumers.put(
			"facebookId", (BiConsumer<User, Long>)User::setFacebookId);
		attributeGetterFunctions.put("googleUserId", User::getGoogleUserId);
		attributeSetterBiConsumers.put(
			"googleUserId", (BiConsumer<User, String>)User::setGoogleUserId);
		attributeGetterFunctions.put("ldapServerId", User::getLdapServerId);
		attributeSetterBiConsumers.put(
			"ldapServerId", (BiConsumer<User, Long>)User::setLdapServerId);
		attributeGetterFunctions.put("openId", User::getOpenId);
		attributeSetterBiConsumers.put(
			"openId", (BiConsumer<User, String>)User::setOpenId);
		attributeGetterFunctions.put("portraitId", User::getPortraitId);
		attributeSetterBiConsumers.put(
			"portraitId", (BiConsumer<User, Long>)User::setPortraitId);
		attributeGetterFunctions.put("languageId", User::getLanguageId);
		attributeSetterBiConsumers.put(
			"languageId", (BiConsumer<User, String>)User::setLanguageId);
		attributeGetterFunctions.put("timeZoneId", User::getTimeZoneId);
		attributeSetterBiConsumers.put(
			"timeZoneId", (BiConsumer<User, String>)User::setTimeZoneId);
		attributeGetterFunctions.put("greeting", User::getGreeting);
		attributeSetterBiConsumers.put(
			"greeting", (BiConsumer<User, String>)User::setGreeting);
		attributeGetterFunctions.put("comments", User::getComments);
		attributeSetterBiConsumers.put(
			"comments", (BiConsumer<User, String>)User::setComments);
		attributeGetterFunctions.put("firstName", User::getFirstName);
		attributeSetterBiConsumers.put(
			"firstName", (BiConsumer<User, String>)User::setFirstName);
		attributeGetterFunctions.put("middleName", User::getMiddleName);
		attributeSetterBiConsumers.put(
			"middleName", (BiConsumer<User, String>)User::setMiddleName);
		attributeGetterFunctions.put("lastName", User::getLastName);
		attributeSetterBiConsumers.put(
			"lastName", (BiConsumer<User, String>)User::setLastName);
		attributeGetterFunctions.put("jobTitle", User::getJobTitle);
		attributeSetterBiConsumers.put(
			"jobTitle", (BiConsumer<User, String>)User::setJobTitle);
		attributeGetterFunctions.put("loginDate", User::getLoginDate);
		attributeSetterBiConsumers.put(
			"loginDate", (BiConsumer<User, Date>)User::setLoginDate);
		attributeGetterFunctions.put("loginIP", User::getLoginIP);
		attributeSetterBiConsumers.put(
			"loginIP", (BiConsumer<User, String>)User::setLoginIP);
		attributeGetterFunctions.put("lastLoginDate", User::getLastLoginDate);
		attributeSetterBiConsumers.put(
			"lastLoginDate", (BiConsumer<User, Date>)User::setLastLoginDate);
		attributeGetterFunctions.put("lastLoginIP", User::getLastLoginIP);
		attributeSetterBiConsumers.put(
			"lastLoginIP", (BiConsumer<User, String>)User::setLastLoginIP);
		attributeGetterFunctions.put(
			"lastFailedLoginDate", User::getLastFailedLoginDate);
		attributeSetterBiConsumers.put(
			"lastFailedLoginDate",
			(BiConsumer<User, Date>)User::setLastFailedLoginDate);
		attributeGetterFunctions.put(
			"failedLoginAttempts", User::getFailedLoginAttempts);
		attributeSetterBiConsumers.put(
			"failedLoginAttempts",
			(BiConsumer<User, Integer>)User::setFailedLoginAttempts);
		attributeGetterFunctions.put("lockout", User::getLockout);
		attributeSetterBiConsumers.put(
			"lockout", (BiConsumer<User, Boolean>)User::setLockout);
		attributeGetterFunctions.put("lockoutDate", User::getLockoutDate);
		attributeSetterBiConsumers.put(
			"lockoutDate", (BiConsumer<User, Date>)User::setLockoutDate);
		attributeGetterFunctions.put(
			"agreedToTermsOfUse", User::getAgreedToTermsOfUse);
		attributeSetterBiConsumers.put(
			"agreedToTermsOfUse",
			(BiConsumer<User, Boolean>)User::setAgreedToTermsOfUse);
		attributeGetterFunctions.put(
			"emailAddressVerified", User::getEmailAddressVerified);
		attributeSetterBiConsumers.put(
			"emailAddressVerified",
			(BiConsumer<User, Boolean>)User::setEmailAddressVerified);
		attributeGetterFunctions.put("status", User::getStatus);
		attributeSetterBiConsumers.put(
			"status", (BiConsumer<User, Integer>)User::setStatus);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		_columnBitmask |= EXTERNALREFERENCECODE_COLUMN_BITMASK;

		if (_originalExternalReferenceCode == null) {
			_originalExternalReferenceCode = _externalReferenceCode;
		}

		_externalReferenceCode = externalReferenceCode;
	}

	public String getOriginalExternalReferenceCode() {
		return GetterUtil.getString(_originalExternalReferenceCode);
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask |= CREATEDATE_COLUMN_BITMASK;

		if (_originalCreateDate == null) {
			_originalCreateDate = _createDate;
		}

		_createDate = createDate;
	}

	public Date getOriginalCreateDate() {
		return _originalCreateDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_columnBitmask |= MODIFIEDDATE_COLUMN_BITMASK;

		if (_originalModifiedDate == null) {
			_originalModifiedDate = _modifiedDate;
		}

		_modifiedDate = modifiedDate;
	}

	public Date getOriginalModifiedDate() {
		return _originalModifiedDate;
	}

	@JSON
	@Override
	public boolean getDefaultUser() {
		return _defaultUser;
	}

	@JSON
	@Override
	public boolean isDefaultUser() {
		return _defaultUser;
	}

	@Override
	public void setDefaultUser(boolean defaultUser) {
		_columnBitmask |= DEFAULTUSER_COLUMN_BITMASK;

		if (!_setOriginalDefaultUser) {
			_setOriginalDefaultUser = true;

			_originalDefaultUser = _defaultUser;
		}

		_defaultUser = defaultUser;
	}

	public boolean getOriginalDefaultUser() {
		return _originalDefaultUser;
	}

	@JSON
	@Override
	public long getContactId() {
		return _contactId;
	}

	@Override
	public void setContactId(long contactId) {
		_columnBitmask |= CONTACTID_COLUMN_BITMASK;

		if (!_setOriginalContactId) {
			_setOriginalContactId = true;

			_originalContactId = _contactId;
		}

		_contactId = contactId;
	}

	public long getOriginalContactId() {
		return _originalContactId;
	}

	@JSON(include = false)
	@Override
	public String getPassword() {
		if (_password == null) {
			return "";
		}
		else {
			return _password;
		}
	}

	@Override
	public void setPassword(String password) {
		_password = password;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public boolean isPasswordEncrypted() {
		return _passwordEncrypted;
	}

	@Override
	public void setPasswordEncrypted(boolean passwordEncrypted) {
		_passwordEncrypted = passwordEncrypted;
	}

	@JSON(include = false)
	@Override
	public boolean getPasswordReset() {
		return _passwordReset;
	}

	@Override
	public boolean isPasswordReset() {
		return _passwordReset;
	}

	@Override
	public void setPasswordReset(boolean passwordReset) {
		_passwordReset = passwordReset;
	}

	@JSON(include = false)
	@Override
	public Date getPasswordModifiedDate() {
		return _passwordModifiedDate;
	}

	@Override
	public void setPasswordModifiedDate(Date passwordModifiedDate) {
		_passwordModifiedDate = passwordModifiedDate;
	}

	@JSON(include = false)
	@Override
	public String getDigest() {
		if (_digest == null) {
			return "";
		}
		else {
			return _digest;
		}
	}

	@Override
	public void setDigest(String digest) {
		_digest = digest;
	}

	@JSON
	@Override
	public String getReminderQueryQuestion() {
		if (_reminderQueryQuestion == null) {
			return "";
		}
		else {
			return _reminderQueryQuestion;
		}
	}

	@Override
	public void setReminderQueryQuestion(String reminderQueryQuestion) {
		_reminderQueryQuestion = reminderQueryQuestion;
	}

	@JSON
	@Override
	public String getReminderQueryAnswer() {
		if (_reminderQueryAnswer == null) {
			return "";
		}
		else {
			return _reminderQueryAnswer;
		}
	}

	@Override
	public void setReminderQueryAnswer(String reminderQueryAnswer) {
		_reminderQueryAnswer = reminderQueryAnswer;
	}

	@JSON
	@Override
	public int getGraceLoginCount() {
		return _graceLoginCount;
	}

	@Override
	public void setGraceLoginCount(int graceLoginCount) {
		_graceLoginCount = graceLoginCount;
	}

	@JSON
	@Override
	public String getScreenName() {
		if (_screenName == null) {
			return "";
		}
		else {
			return _screenName;
		}
	}

	@Override
	public void setScreenName(String screenName) {
		_columnBitmask |= SCREENNAME_COLUMN_BITMASK;

		if (_originalScreenName == null) {
			_originalScreenName = _screenName;
		}

		_screenName = screenName;
	}

	public String getOriginalScreenName() {
		return GetterUtil.getString(_originalScreenName);
	}

	@JSON
	@Override
	public String getEmailAddress() {
		if (_emailAddress == null) {
			return "";
		}
		else {
			return _emailAddress;
		}
	}

	@Override
	public void setEmailAddress(String emailAddress) {
		_columnBitmask |= EMAILADDRESS_COLUMN_BITMASK;

		if (_originalEmailAddress == null) {
			_originalEmailAddress = _emailAddress;
		}

		_emailAddress = emailAddress;
	}

	public String getOriginalEmailAddress() {
		return GetterUtil.getString(_originalEmailAddress);
	}

	@JSON
	@Override
	public long getFacebookId() {
		return _facebookId;
	}

	@Override
	public void setFacebookId(long facebookId) {
		_columnBitmask |= FACEBOOKID_COLUMN_BITMASK;

		if (!_setOriginalFacebookId) {
			_setOriginalFacebookId = true;

			_originalFacebookId = _facebookId;
		}

		_facebookId = facebookId;
	}

	public long getOriginalFacebookId() {
		return _originalFacebookId;
	}

	@JSON
	@Override
	public String getGoogleUserId() {
		if (_googleUserId == null) {
			return "";
		}
		else {
			return _googleUserId;
		}
	}

	@Override
	public void setGoogleUserId(String googleUserId) {
		_columnBitmask |= GOOGLEUSERID_COLUMN_BITMASK;

		if (_originalGoogleUserId == null) {
			_originalGoogleUserId = _googleUserId;
		}

		_googleUserId = googleUserId;
	}

	public String getOriginalGoogleUserId() {
		return GetterUtil.getString(_originalGoogleUserId);
	}

	@JSON
	@Override
	public long getLdapServerId() {
		return _ldapServerId;
	}

	@Override
	public void setLdapServerId(long ldapServerId) {
		_ldapServerId = ldapServerId;
	}

	@JSON
	@Override
	public String getOpenId() {
		if (_openId == null) {
			return "";
		}
		else {
			return _openId;
		}
	}

	@Override
	public void setOpenId(String openId) {
		_columnBitmask |= OPENID_COLUMN_BITMASK;

		if (_originalOpenId == null) {
			_originalOpenId = _openId;
		}

		_openId = openId;
	}

	public String getOriginalOpenId() {
		return GetterUtil.getString(_originalOpenId);
	}

	@JSON
	@Override
	public long getPortraitId() {
		return _portraitId;
	}

	@Override
	public void setPortraitId(long portraitId) {
		_columnBitmask |= PORTRAITID_COLUMN_BITMASK;

		if (!_setOriginalPortraitId) {
			_setOriginalPortraitId = true;

			_originalPortraitId = _portraitId;
		}

		_portraitId = portraitId;
	}

	public long getOriginalPortraitId() {
		return _originalPortraitId;
	}

	@JSON
	@Override
	public String getLanguageId() {
		if (_languageId == null) {
			return "";
		}
		else {
			return _languageId;
		}
	}

	@Override
	public void setLanguageId(String languageId) {
		_languageId = languageId;
	}

	@JSON
	@Override
	public String getTimeZoneId() {
		if (_timeZoneId == null) {
			return "";
		}
		else {
			return _timeZoneId;
		}
	}

	@Override
	public void setTimeZoneId(String timeZoneId) {
		_timeZoneId = timeZoneId;
	}

	@JSON
	@Override
	public String getGreeting() {
		if (_greeting == null) {
			return "";
		}
		else {
			return _greeting;
		}
	}

	@Override
	public void setGreeting(String greeting) {
		_greeting = greeting;
	}

	@JSON
	@Override
	public String getComments() {
		if (_comments == null) {
			return "";
		}
		else {
			return _comments;
		}
	}

	@Override
	public void setComments(String comments) {
		_comments = comments;
	}

	@JSON
	@Override
	public String getFirstName() {
		if (_firstName == null) {
			return "";
		}
		else {
			return _firstName;
		}
	}

	@Override
	public void setFirstName(String firstName) {
		_firstName = firstName;
	}

	@JSON
	@Override
	public String getMiddleName() {
		if (_middleName == null) {
			return "";
		}
		else {
			return _middleName;
		}
	}

	@Override
	public void setMiddleName(String middleName) {
		_middleName = middleName;
	}

	@JSON
	@Override
	public String getLastName() {
		if (_lastName == null) {
			return "";
		}
		else {
			return _lastName;
		}
	}

	@Override
	public void setLastName(String lastName) {
		_lastName = lastName;
	}

	@JSON
	@Override
	public String getJobTitle() {
		if (_jobTitle == null) {
			return "";
		}
		else {
			return _jobTitle;
		}
	}

	@Override
	public void setJobTitle(String jobTitle) {
		_jobTitle = jobTitle;
	}

	@JSON
	@Override
	public Date getLoginDate() {
		return _loginDate;
	}

	@Override
	public void setLoginDate(Date loginDate) {
		_loginDate = loginDate;
	}

	@JSON
	@Override
	public String getLoginIP() {
		if (_loginIP == null) {
			return "";
		}
		else {
			return _loginIP;
		}
	}

	@Override
	public void setLoginIP(String loginIP) {
		_loginIP = loginIP;
	}

	@JSON
	@Override
	public Date getLastLoginDate() {
		return _lastLoginDate;
	}

	@Override
	public void setLastLoginDate(Date lastLoginDate) {
		_lastLoginDate = lastLoginDate;
	}

	@JSON
	@Override
	public String getLastLoginIP() {
		if (_lastLoginIP == null) {
			return "";
		}
		else {
			return _lastLoginIP;
		}
	}

	@Override
	public void setLastLoginIP(String lastLoginIP) {
		_lastLoginIP = lastLoginIP;
	}

	@JSON
	@Override
	public Date getLastFailedLoginDate() {
		return _lastFailedLoginDate;
	}

	@Override
	public void setLastFailedLoginDate(Date lastFailedLoginDate) {
		_lastFailedLoginDate = lastFailedLoginDate;
	}

	@JSON
	@Override
	public int getFailedLoginAttempts() {
		return _failedLoginAttempts;
	}

	@Override
	public void setFailedLoginAttempts(int failedLoginAttempts) {
		_failedLoginAttempts = failedLoginAttempts;
	}

	@JSON
	@Override
	public boolean getLockout() {
		return _lockout;
	}

	@JSON
	@Override
	public boolean isLockout() {
		return _lockout;
	}

	@Override
	public void setLockout(boolean lockout) {
		_lockout = lockout;
	}

	@JSON
	@Override
	public Date getLockoutDate() {
		return _lockoutDate;
	}

	@Override
	public void setLockoutDate(Date lockoutDate) {
		_lockoutDate = lockoutDate;
	}

	@JSON
	@Override
	public boolean getAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@JSON
	@Override
	public boolean isAgreedToTermsOfUse() {
		return _agreedToTermsOfUse;
	}

	@Override
	public void setAgreedToTermsOfUse(boolean agreedToTermsOfUse) {
		_agreedToTermsOfUse = agreedToTermsOfUse;
	}

	@JSON
	@Override
	public boolean getEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@JSON
	@Override
	public boolean isEmailAddressVerified() {
		return _emailAddressVerified;
	}

	@Override
	public void setEmailAddressVerified(boolean emailAddressVerified) {
		_emailAddressVerified = emailAddressVerified;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(User.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), User.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public User toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, User>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		UserImpl userImpl = new UserImpl();

		userImpl.setMvccVersion(getMvccVersion());
		userImpl.setCtCollectionId(getCtCollectionId());
		userImpl.setUuid(getUuid());
		userImpl.setExternalReferenceCode(getExternalReferenceCode());
		userImpl.setUserId(getUserId());
		userImpl.setCompanyId(getCompanyId());
		userImpl.setCreateDate(getCreateDate());
		userImpl.setModifiedDate(getModifiedDate());
		userImpl.setDefaultUser(isDefaultUser());
		userImpl.setContactId(getContactId());
		userImpl.setPassword(getPassword());
		userImpl.setPasswordEncrypted(isPasswordEncrypted());
		userImpl.setPasswordReset(isPasswordReset());
		userImpl.setPasswordModifiedDate(getPasswordModifiedDate());
		userImpl.setDigest(getDigest());
		userImpl.setReminderQueryQuestion(getReminderQueryQuestion());
		userImpl.setReminderQueryAnswer(getReminderQueryAnswer());
		userImpl.setGraceLoginCount(getGraceLoginCount());
		userImpl.setScreenName(getScreenName());
		userImpl.setEmailAddress(getEmailAddress());
		userImpl.setFacebookId(getFacebookId());
		userImpl.setGoogleUserId(getGoogleUserId());
		userImpl.setLdapServerId(getLdapServerId());
		userImpl.setOpenId(getOpenId());
		userImpl.setPortraitId(getPortraitId());
		userImpl.setLanguageId(getLanguageId());
		userImpl.setTimeZoneId(getTimeZoneId());
		userImpl.setGreeting(getGreeting());
		userImpl.setComments(getComments());
		userImpl.setFirstName(getFirstName());
		userImpl.setMiddleName(getMiddleName());
		userImpl.setLastName(getLastName());
		userImpl.setJobTitle(getJobTitle());
		userImpl.setLoginDate(getLoginDate());
		userImpl.setLoginIP(getLoginIP());
		userImpl.setLastLoginDate(getLastLoginDate());
		userImpl.setLastLoginIP(getLastLoginIP());
		userImpl.setLastFailedLoginDate(getLastFailedLoginDate());
		userImpl.setFailedLoginAttempts(getFailedLoginAttempts());
		userImpl.setLockout(isLockout());
		userImpl.setLockoutDate(getLockoutDate());
		userImpl.setAgreedToTermsOfUse(isAgreedToTermsOfUse());
		userImpl.setEmailAddressVerified(isEmailAddressVerified());
		userImpl.setStatus(getStatus());

		userImpl.resetOriginalValues();

		return userImpl;
	}

	@Override
	public int compareTo(User user) {
		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof User)) {
			return false;
		}

		User user = (User)obj;

		long primaryKey = user.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		UserModelImpl userModelImpl = this;

		userModelImpl._originalUuid = userModelImpl._uuid;

		userModelImpl._originalExternalReferenceCode =
			userModelImpl._externalReferenceCode;

		userModelImpl._originalUserId = userModelImpl._userId;

		userModelImpl._setOriginalUserId = false;

		userModelImpl._originalCompanyId = userModelImpl._companyId;

		userModelImpl._setOriginalCompanyId = false;

		userModelImpl._originalCreateDate = userModelImpl._createDate;

		userModelImpl._originalModifiedDate = userModelImpl._modifiedDate;

		userModelImpl._setModifiedDate = false;

		userModelImpl._originalDefaultUser = userModelImpl._defaultUser;

		userModelImpl._setOriginalDefaultUser = false;

		userModelImpl._originalContactId = userModelImpl._contactId;

		userModelImpl._setOriginalContactId = false;

		userModelImpl._originalScreenName = userModelImpl._screenName;

		userModelImpl._originalEmailAddress = userModelImpl._emailAddress;

		userModelImpl._originalFacebookId = userModelImpl._facebookId;

		userModelImpl._setOriginalFacebookId = false;

		userModelImpl._originalGoogleUserId = userModelImpl._googleUserId;

		userModelImpl._originalOpenId = userModelImpl._openId;

		userModelImpl._originalPortraitId = userModelImpl._portraitId;

		userModelImpl._setOriginalPortraitId = false;

		userModelImpl._originalStatus = userModelImpl._status;

		userModelImpl._setOriginalStatus = false;

		userModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<User> toCacheModel() {
		UserCacheModel userCacheModel = new UserCacheModel();

		userCacheModel.mvccVersion = getMvccVersion();

		userCacheModel.ctCollectionId = getCtCollectionId();

		userCacheModel.uuid = getUuid();

		String uuid = userCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			userCacheModel.uuid = null;
		}

		userCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode = userCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			userCacheModel.externalReferenceCode = null;
		}

		userCacheModel.userId = getUserId();

		userCacheModel.companyId = getCompanyId();

		Date createDate = getCreateDate();

		if (createDate != null) {
			userCacheModel.createDate = createDate.getTime();
		}
		else {
			userCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			userCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			userCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.defaultUser = isDefaultUser();

		userCacheModel.contactId = getContactId();

		userCacheModel.password = getPassword();

		String password = userCacheModel.password;

		if ((password != null) && (password.length() == 0)) {
			userCacheModel.password = null;
		}

		userCacheModel.passwordEncrypted = isPasswordEncrypted();

		userCacheModel.passwordReset = isPasswordReset();

		Date passwordModifiedDate = getPasswordModifiedDate();

		if (passwordModifiedDate != null) {
			userCacheModel.passwordModifiedDate =
				passwordModifiedDate.getTime();
		}
		else {
			userCacheModel.passwordModifiedDate = Long.MIN_VALUE;
		}

		userCacheModel.digest = getDigest();

		String digest = userCacheModel.digest;

		if ((digest != null) && (digest.length() == 0)) {
			userCacheModel.digest = null;
		}

		userCacheModel.reminderQueryQuestion = getReminderQueryQuestion();

		String reminderQueryQuestion = userCacheModel.reminderQueryQuestion;

		if ((reminderQueryQuestion != null) &&
			(reminderQueryQuestion.length() == 0)) {

			userCacheModel.reminderQueryQuestion = null;
		}

		userCacheModel.reminderQueryAnswer = getReminderQueryAnswer();

		String reminderQueryAnswer = userCacheModel.reminderQueryAnswer;

		if ((reminderQueryAnswer != null) &&
			(reminderQueryAnswer.length() == 0)) {

			userCacheModel.reminderQueryAnswer = null;
		}

		userCacheModel.graceLoginCount = getGraceLoginCount();

		userCacheModel.screenName = getScreenName();

		String screenName = userCacheModel.screenName;

		if ((screenName != null) && (screenName.length() == 0)) {
			userCacheModel.screenName = null;
		}

		userCacheModel.emailAddress = getEmailAddress();

		String emailAddress = userCacheModel.emailAddress;

		if ((emailAddress != null) && (emailAddress.length() == 0)) {
			userCacheModel.emailAddress = null;
		}

		userCacheModel.facebookId = getFacebookId();

		userCacheModel.googleUserId = getGoogleUserId();

		String googleUserId = userCacheModel.googleUserId;

		if ((googleUserId != null) && (googleUserId.length() == 0)) {
			userCacheModel.googleUserId = null;
		}

		userCacheModel.ldapServerId = getLdapServerId();

		userCacheModel.openId = getOpenId();

		String openId = userCacheModel.openId;

		if ((openId != null) && (openId.length() == 0)) {
			userCacheModel.openId = null;
		}

		userCacheModel.portraitId = getPortraitId();

		userCacheModel.languageId = getLanguageId();

		String languageId = userCacheModel.languageId;

		if ((languageId != null) && (languageId.length() == 0)) {
			userCacheModel.languageId = null;
		}

		userCacheModel.timeZoneId = getTimeZoneId();

		String timeZoneId = userCacheModel.timeZoneId;

		if ((timeZoneId != null) && (timeZoneId.length() == 0)) {
			userCacheModel.timeZoneId = null;
		}

		userCacheModel.greeting = getGreeting();

		String greeting = userCacheModel.greeting;

		if ((greeting != null) && (greeting.length() == 0)) {
			userCacheModel.greeting = null;
		}

		userCacheModel.comments = getComments();

		String comments = userCacheModel.comments;

		if ((comments != null) && (comments.length() == 0)) {
			userCacheModel.comments = null;
		}

		userCacheModel.firstName = getFirstName();

		String firstName = userCacheModel.firstName;

		if ((firstName != null) && (firstName.length() == 0)) {
			userCacheModel.firstName = null;
		}

		userCacheModel.middleName = getMiddleName();

		String middleName = userCacheModel.middleName;

		if ((middleName != null) && (middleName.length() == 0)) {
			userCacheModel.middleName = null;
		}

		userCacheModel.lastName = getLastName();

		String lastName = userCacheModel.lastName;

		if ((lastName != null) && (lastName.length() == 0)) {
			userCacheModel.lastName = null;
		}

		userCacheModel.jobTitle = getJobTitle();

		String jobTitle = userCacheModel.jobTitle;

		if ((jobTitle != null) && (jobTitle.length() == 0)) {
			userCacheModel.jobTitle = null;
		}

		Date loginDate = getLoginDate();

		if (loginDate != null) {
			userCacheModel.loginDate = loginDate.getTime();
		}
		else {
			userCacheModel.loginDate = Long.MIN_VALUE;
		}

		userCacheModel.loginIP = getLoginIP();

		String loginIP = userCacheModel.loginIP;

		if ((loginIP != null) && (loginIP.length() == 0)) {
			userCacheModel.loginIP = null;
		}

		Date lastLoginDate = getLastLoginDate();

		if (lastLoginDate != null) {
			userCacheModel.lastLoginDate = lastLoginDate.getTime();
		}
		else {
			userCacheModel.lastLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.lastLoginIP = getLastLoginIP();

		String lastLoginIP = userCacheModel.lastLoginIP;

		if ((lastLoginIP != null) && (lastLoginIP.length() == 0)) {
			userCacheModel.lastLoginIP = null;
		}

		Date lastFailedLoginDate = getLastFailedLoginDate();

		if (lastFailedLoginDate != null) {
			userCacheModel.lastFailedLoginDate = lastFailedLoginDate.getTime();
		}
		else {
			userCacheModel.lastFailedLoginDate = Long.MIN_VALUE;
		}

		userCacheModel.failedLoginAttempts = getFailedLoginAttempts();

		userCacheModel.lockout = isLockout();

		Date lockoutDate = getLockoutDate();

		if (lockoutDate != null) {
			userCacheModel.lockoutDate = lockoutDate.getTime();
		}
		else {
			userCacheModel.lockoutDate = Long.MIN_VALUE;
		}

		userCacheModel.agreedToTermsOfUse = isAgreedToTermsOfUse();

		userCacheModel.emailAddressVerified = isEmailAddressVerified();

		userCacheModel.status = getStatus();

		return userCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((User)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<User, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<User, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<User, Object> attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((User)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, User>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _originalUuid;
	private String _externalReferenceCode;
	private String _originalExternalReferenceCode;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private Date _createDate;
	private Date _originalCreateDate;
	private Date _modifiedDate;
	private Date _originalModifiedDate;
	private boolean _setModifiedDate;
	private boolean _defaultUser;
	private boolean _originalDefaultUser;
	private boolean _setOriginalDefaultUser;
	private long _contactId;
	private long _originalContactId;
	private boolean _setOriginalContactId;
	private String _password;
	private boolean _passwordEncrypted;
	private boolean _passwordReset;
	private Date _passwordModifiedDate;
	private String _digest;
	private String _reminderQueryQuestion;
	private String _reminderQueryAnswer;
	private int _graceLoginCount;
	private String _screenName;
	private String _originalScreenName;
	private String _emailAddress;
	private String _originalEmailAddress;
	private long _facebookId;
	private long _originalFacebookId;
	private boolean _setOriginalFacebookId;
	private String _googleUserId;
	private String _originalGoogleUserId;
	private long _ldapServerId;
	private String _openId;
	private String _originalOpenId;
	private long _portraitId;
	private long _originalPortraitId;
	private boolean _setOriginalPortraitId;
	private String _languageId;
	private String _timeZoneId;
	private String _greeting;
	private String _comments;
	private String _firstName;
	private String _middleName;
	private String _lastName;
	private String _jobTitle;
	private Date _loginDate;
	private String _loginIP;
	private Date _lastLoginDate;
	private String _lastLoginIP;
	private Date _lastFailedLoginDate;
	private int _failedLoginAttempts;
	private boolean _lockout;
	private Date _lockoutDate;
	private boolean _agreedToTermsOfUse;
	private boolean _emailAddressVerified;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private long _columnBitmask;
	private User _escapedModel;

}