/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryModel;
import com.liferay.document.library.kernel.model.DLFileEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the DLFileEntry service. Represents a row in the &quot;DLFileEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>DLFileEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLFileEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLFileEntryImpl
 * @generated
 */
@JSON(strict = true)
public class DLFileEntryModelImpl
	extends BaseModelImpl<DLFileEntry> implements DLFileEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library file entry model instance should use the <code>DLFileEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "DLFileEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"fileEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"classNameId", Types.BIGINT}, {"classPK", Types.BIGINT},
		{"repositoryId", Types.BIGINT}, {"folderId", Types.BIGINT},
		{"treePath", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"fileName", Types.VARCHAR}, {"extension", Types.VARCHAR},
		{"mimeType", Types.VARCHAR}, {"title", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"extraSettings", Types.CLOB},
		{"fileEntryTypeId", Types.BIGINT}, {"version", Types.VARCHAR},
		{"size_", Types.BIGINT}, {"smallImageId", Types.BIGINT},
		{"largeImageId", Types.BIGINT}, {"custom1ImageId", Types.BIGINT},
		{"custom2ImageId", Types.BIGINT},
		{"manualCheckInRequired", Types.BOOLEAN},
		{"lastPublishDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("folderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fileName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extension", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("title", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extraSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("fileEntryTypeId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("size_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("smallImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("largeImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("custom1ImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("custom2ImageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("manualCheckInRequired", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("lastPublishDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table DLFileEntry (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,fileEntryId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,repositoryId LONG,folderId LONG,treePath STRING null,name VARCHAR(255) null,fileName VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,title VARCHAR(255) null,description STRING null,extraSettings TEXT null,fileEntryTypeId LONG,version VARCHAR(75) null,size_ LONG,smallImageId LONG,largeImageId LONG,custom1ImageId LONG,custom2ImageId LONG,manualCheckInRequired BOOLEAN,lastPublishDate DATE null,primary key (fileEntryId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table DLFileEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY dlFileEntry.folderId ASC, dlFileEntry.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY DLFileEntry.folderId ASC, DLFileEntry.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.entity.cache.enabled.com.liferay.document.library.kernel.model.DLFileEntry"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.finder.cache.enabled.com.liferay.document.library.kernel.model.DLFileEntry"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.portal.util.PropsUtil.get(
			"value.object.column.bitmask.enabled.com.liferay.document.library.kernel.model.DLFileEntry"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long CUSTOM1IMAGEID_COLUMN_BITMASK = 2L;

	public static final long CUSTOM2IMAGEID_COLUMN_BITMASK = 4L;

	public static final long FILEENTRYTYPEID_COLUMN_BITMASK = 8L;

	public static final long FILENAME_COLUMN_BITMASK = 16L;

	public static final long FOLDERID_COLUMN_BITMASK = 32L;

	public static final long GROUPID_COLUMN_BITMASK = 64L;

	public static final long LARGEIMAGEID_COLUMN_BITMASK = 128L;

	public static final long MIMETYPE_COLUMN_BITMASK = 256L;

	public static final long NAME_COLUMN_BITMASK = 512L;

	public static final long REPOSITORYID_COLUMN_BITMASK = 1024L;

	public static final long SMALLIMAGEID_COLUMN_BITMASK = 2048L;

	public static final long TITLE_COLUMN_BITMASK = 4096L;

	public static final long USERID_COLUMN_BITMASK = 8192L;

	public static final long UUID_COLUMN_BITMASK = 16384L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static DLFileEntry toModel(DLFileEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		DLFileEntry model = new DLFileEntryImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setCtCollectionId(soapModel.getCtCollectionId());
		model.setUuid(soapModel.getUuid());
		model.setFileEntryId(soapModel.getFileEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setRepositoryId(soapModel.getRepositoryId());
		model.setFolderId(soapModel.getFolderId());
		model.setTreePath(soapModel.getTreePath());
		model.setName(soapModel.getName());
		model.setFileName(soapModel.getFileName());
		model.setExtension(soapModel.getExtension());
		model.setMimeType(soapModel.getMimeType());
		model.setTitle(soapModel.getTitle());
		model.setDescription(soapModel.getDescription());
		model.setExtraSettings(soapModel.getExtraSettings());
		model.setFileEntryTypeId(soapModel.getFileEntryTypeId());
		model.setVersion(soapModel.getVersion());
		model.setSize(soapModel.getSize());
		model.setSmallImageId(soapModel.getSmallImageId());
		model.setLargeImageId(soapModel.getLargeImageId());
		model.setCustom1ImageId(soapModel.getCustom1ImageId());
		model.setCustom2ImageId(soapModel.getCustom2ImageId());
		model.setManualCheckInRequired(soapModel.isManualCheckInRequired());
		model.setLastPublishDate(soapModel.getLastPublishDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<DLFileEntry> toModels(DLFileEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<DLFileEntry> models = new ArrayList<DLFileEntry>(
			soapModels.length);

		for (DLFileEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.portal.util.PropsUtil.get(
			"lock.expiration.time.com.liferay.document.library.kernel.model.DLFileEntry"));

	public DLFileEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _fileEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setFileEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _fileEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return DLFileEntry.class;
	}

	@Override
	public String getModelClassName() {
		return DLFileEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<DLFileEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((DLFileEntry)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<DLFileEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<DLFileEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(DLFileEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<DLFileEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<DLFileEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, DLFileEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			DLFileEntry.class.getClassLoader(), DLFileEntry.class,
			ModelWrapper.class);

		try {
			Constructor<DLFileEntry> constructor =
				(Constructor<DLFileEntry>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<DLFileEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<DLFileEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<DLFileEntry, Object>>();
		Map<String, BiConsumer<DLFileEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<DLFileEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", DLFileEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setMvccVersion);
		attributeGetterFunctions.put(
			"ctCollectionId", DLFileEntry::getCtCollectionId);
		attributeSetterBiConsumers.put(
			"ctCollectionId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCtCollectionId);
		attributeGetterFunctions.put("uuid", DLFileEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<DLFileEntry, String>)DLFileEntry::setUuid);
		attributeGetterFunctions.put(
			"fileEntryId", DLFileEntry::getFileEntryId);
		attributeSetterBiConsumers.put(
			"fileEntryId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFileEntryId);
		attributeGetterFunctions.put("groupId", DLFileEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId", (BiConsumer<DLFileEntry, Long>)DLFileEntry::setGroupId);
		attributeGetterFunctions.put("companyId", DLFileEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCompanyId);
		attributeGetterFunctions.put("userId", DLFileEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<DLFileEntry, Long>)DLFileEntry::setUserId);
		attributeGetterFunctions.put("userName", DLFileEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setUserName);
		attributeGetterFunctions.put("createDate", DLFileEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<DLFileEntry, Date>)DLFileEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", DLFileEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<DLFileEntry, Date>)DLFileEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", DLFileEntry::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setClassNameId);
		attributeGetterFunctions.put("classPK", DLFileEntry::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK", (BiConsumer<DLFileEntry, Long>)DLFileEntry::setClassPK);
		attributeGetterFunctions.put(
			"repositoryId", DLFileEntry::getRepositoryId);
		attributeSetterBiConsumers.put(
			"repositoryId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setRepositoryId);
		attributeGetterFunctions.put("folderId", DLFileEntry::getFolderId);
		attributeSetterBiConsumers.put(
			"folderId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFolderId);
		attributeGetterFunctions.put("treePath", DLFileEntry::getTreePath);
		attributeSetterBiConsumers.put(
			"treePath",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setTreePath);
		attributeGetterFunctions.put("name", DLFileEntry::getName);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<DLFileEntry, String>)DLFileEntry::setName);
		attributeGetterFunctions.put("fileName", DLFileEntry::getFileName);
		attributeSetterBiConsumers.put(
			"fileName",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setFileName);
		attributeGetterFunctions.put("extension", DLFileEntry::getExtension);
		attributeSetterBiConsumers.put(
			"extension",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setExtension);
		attributeGetterFunctions.put("mimeType", DLFileEntry::getMimeType);
		attributeSetterBiConsumers.put(
			"mimeType",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setMimeType);
		attributeGetterFunctions.put("title", DLFileEntry::getTitle);
		attributeSetterBiConsumers.put(
			"title", (BiConsumer<DLFileEntry, String>)DLFileEntry::setTitle);
		attributeGetterFunctions.put(
			"description", DLFileEntry::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setDescription);
		attributeGetterFunctions.put(
			"extraSettings", DLFileEntry::getExtraSettings);
		attributeSetterBiConsumers.put(
			"extraSettings",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setExtraSettings);
		attributeGetterFunctions.put(
			"fileEntryTypeId", DLFileEntry::getFileEntryTypeId);
		attributeSetterBiConsumers.put(
			"fileEntryTypeId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setFileEntryTypeId);
		attributeGetterFunctions.put("version", DLFileEntry::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<DLFileEntry, String>)DLFileEntry::setVersion);
		attributeGetterFunctions.put("size", DLFileEntry::getSize);
		attributeSetterBiConsumers.put(
			"size", (BiConsumer<DLFileEntry, Long>)DLFileEntry::setSize);
		attributeGetterFunctions.put(
			"smallImageId", DLFileEntry::getSmallImageId);
		attributeSetterBiConsumers.put(
			"smallImageId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setSmallImageId);
		attributeGetterFunctions.put(
			"largeImageId", DLFileEntry::getLargeImageId);
		attributeSetterBiConsumers.put(
			"largeImageId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setLargeImageId);
		attributeGetterFunctions.put(
			"custom1ImageId", DLFileEntry::getCustom1ImageId);
		attributeSetterBiConsumers.put(
			"custom1ImageId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCustom1ImageId);
		attributeGetterFunctions.put(
			"custom2ImageId", DLFileEntry::getCustom2ImageId);
		attributeSetterBiConsumers.put(
			"custom2ImageId",
			(BiConsumer<DLFileEntry, Long>)DLFileEntry::setCustom2ImageId);
		attributeGetterFunctions.put(
			"manualCheckInRequired", DLFileEntry::getManualCheckInRequired);
		attributeSetterBiConsumers.put(
			"manualCheckInRequired",
			(BiConsumer<DLFileEntry, Boolean>)
				DLFileEntry::setManualCheckInRequired);
		attributeGetterFunctions.put(
			"lastPublishDate", DLFileEntry::getLastPublishDate);
		attributeSetterBiConsumers.put(
			"lastPublishDate",
			(BiConsumer<DLFileEntry, Date>)DLFileEntry::setLastPublishDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getFileEntryId() {
		return _fileEntryId;
	}

	@Override
	public void setFileEntryId(long fileEntryId) {
		_fileEntryId = fileEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_classNameId = classNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_classPK = classPK;
	}

	@JSON
	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		_columnBitmask |= REPOSITORYID_COLUMN_BITMASK;

		if (!_setOriginalRepositoryId) {
			_setOriginalRepositoryId = true;

			_originalRepositoryId = _repositoryId;
		}

		_repositoryId = repositoryId;
	}

	public long getOriginalRepositoryId() {
		return _originalRepositoryId;
	}

	@JSON
	@Override
	public long getFolderId() {
		return _folderId;
	}

	@Override
	public void setFolderId(long folderId) {
		_columnBitmask = -1L;

		if (!_setOriginalFolderId) {
			_setOriginalFolderId = true;

			_originalFolderId = _folderId;
		}

		_folderId = folderId;
	}

	public long getOriginalFolderId() {
		return _originalFolderId;
	}

	@JSON
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		_treePath = treePath;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		if (_originalName == null) {
			_originalName = _name;
		}

		_name = name;
	}

	public String getOriginalName() {
		return GetterUtil.getString(_originalName);
	}

	@JSON
	@Override
	public String getFileName() {
		if (_fileName == null) {
			return "";
		}
		else {
			return _fileName;
		}
	}

	@Override
	public void setFileName(String fileName) {
		_columnBitmask |= FILENAME_COLUMN_BITMASK;

		if (_originalFileName == null) {
			_originalFileName = _fileName;
		}

		_fileName = fileName;
	}

	public String getOriginalFileName() {
		return GetterUtil.getString(_originalFileName);
	}

	@JSON
	@Override
	public String getExtension() {
		if (_extension == null) {
			return "";
		}
		else {
			return _extension;
		}
	}

	@Override
	public void setExtension(String extension) {
		_extension = extension;
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return "";
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		_columnBitmask |= MIMETYPE_COLUMN_BITMASK;

		if (_originalMimeType == null) {
			_originalMimeType = _mimeType;
		}

		_mimeType = mimeType;
	}

	public String getOriginalMimeType() {
		return GetterUtil.getString(_originalMimeType);
	}

	@JSON
	@Override
	public String getTitle() {
		if (_title == null) {
			return "";
		}
		else {
			return _title;
		}
	}

	@Override
	public void setTitle(String title) {
		_columnBitmask |= TITLE_COLUMN_BITMASK;

		if (_originalTitle == null) {
			_originalTitle = _title;
		}

		_title = title;
	}

	public String getOriginalTitle() {
		return GetterUtil.getString(_originalTitle);
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getExtraSettings() {
		if (_extraSettings == null) {
			return "";
		}
		else {
			return _extraSettings;
		}
	}

	@Override
	public void setExtraSettings(String extraSettings) {
		_extraSettings = extraSettings;
	}

	@JSON
	@Override
	public long getFileEntryTypeId() {
		return _fileEntryTypeId;
	}

	@Override
	public void setFileEntryTypeId(long fileEntryTypeId) {
		_columnBitmask |= FILEENTRYTYPEID_COLUMN_BITMASK;

		if (!_setOriginalFileEntryTypeId) {
			_setOriginalFileEntryTypeId = true;

			_originalFileEntryTypeId = _fileEntryTypeId;
		}

		_fileEntryTypeId = fileEntryTypeId;
	}

	public long getOriginalFileEntryTypeId() {
		return _originalFileEntryTypeId;
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		_version = version;
	}

	@JSON
	@Override
	public long getSize() {
		return _size;
	}

	@Override
	public void setSize(long size) {
		_size = size;
	}

	@JSON
	@Override
	public long getSmallImageId() {
		return _smallImageId;
	}

	@Override
	public void setSmallImageId(long smallImageId) {
		_columnBitmask |= SMALLIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalSmallImageId) {
			_setOriginalSmallImageId = true;

			_originalSmallImageId = _smallImageId;
		}

		_smallImageId = smallImageId;
	}

	public long getOriginalSmallImageId() {
		return _originalSmallImageId;
	}

	@JSON
	@Override
	public long getLargeImageId() {
		return _largeImageId;
	}

	@Override
	public void setLargeImageId(long largeImageId) {
		_columnBitmask |= LARGEIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalLargeImageId) {
			_setOriginalLargeImageId = true;

			_originalLargeImageId = _largeImageId;
		}

		_largeImageId = largeImageId;
	}

	public long getOriginalLargeImageId() {
		return _originalLargeImageId;
	}

	@JSON
	@Override
	public long getCustom1ImageId() {
		return _custom1ImageId;
	}

	@Override
	public void setCustom1ImageId(long custom1ImageId) {
		_columnBitmask |= CUSTOM1IMAGEID_COLUMN_BITMASK;

		if (!_setOriginalCustom1ImageId) {
			_setOriginalCustom1ImageId = true;

			_originalCustom1ImageId = _custom1ImageId;
		}

		_custom1ImageId = custom1ImageId;
	}

	public long getOriginalCustom1ImageId() {
		return _originalCustom1ImageId;
	}

	@JSON
	@Override
	public long getCustom2ImageId() {
		return _custom2ImageId;
	}

	@Override
	public void setCustom2ImageId(long custom2ImageId) {
		_columnBitmask |= CUSTOM2IMAGEID_COLUMN_BITMASK;

		if (!_setOriginalCustom2ImageId) {
			_setOriginalCustom2ImageId = true;

			_originalCustom2ImageId = _custom2ImageId;
		}

		_custom2ImageId = custom2ImageId;
	}

	public long getOriginalCustom2ImageId() {
		return _originalCustom2ImageId;
	}

	@JSON
	@Override
	public boolean getManualCheckInRequired() {
		return _manualCheckInRequired;
	}

	@JSON
	@Override
	public boolean isManualCheckInRequired() {
		return _manualCheckInRequired;
	}

	@Override
	public void setManualCheckInRequired(boolean manualCheckInRequired) {
		_manualCheckInRequired = manualCheckInRequired;
	}

	@JSON
	@Override
	public Date getLastPublishDate() {
		return _lastPublishDate;
	}

	@Override
	public void setLastPublishDate(Date lastPublishDate) {
		_lastPublishDate = lastPublishDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(DLFileEntry.class.getName()),
			getClassNameId());
	}

	@Override
	public int getStatus() {
		return 0;
	}

	@Override
	public com.liferay.trash.kernel.model.TrashEntry getTrashEntry()
		throws PortalException {

		if (!isInTrash()) {
			return null;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return trashEntry;
		}

		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if (Validator.isNotNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			ContainerModel containerModel = null;

			try {
				containerModel = trashHandler.getParentContainerModel(this);
			}
			catch (NoSuchModelException noSuchModelException) {
				return null;
			}

			while (containerModel != null) {
				if (containerModel instanceof TrashedModel) {
					TrashedModel trashedModel = (TrashedModel)containerModel;

					return trashedModel.getTrashEntry();
				}

				trashHandler =
					com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
						getTrashHandler(
							trashHandler.getContainerModelClassName(
								containerModel.getContainerModelId()));

				if (trashHandler == null) {
					return null;
				}

				containerModel = trashHandler.getContainerModel(
					containerModel.getParentContainerModelId());
			}
		}

		return null;
	}

	@Override
	public long getTrashEntryClassPK() {
		return getPrimaryKey();
	}

	/**
	 * @deprecated As of Judson (7.1.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
		return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.
			getTrashHandler(getModelClassName());
	}

	@Override
	public boolean isInTrash() {
		if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInTrashContainer() {
		com.liferay.portal.kernel.trash.TrashHandler trashHandler =
			getTrashHandler();

		if ((trashHandler == null) ||
			Validator.isNull(
				trashHandler.getContainerModelClassName(getPrimaryKey()))) {

			return false;
		}

		try {
			ContainerModel containerModel =
				trashHandler.getParentContainerModel(this);

			if (containerModel == null) {
				return false;
			}

			if (containerModel instanceof TrashedModel) {
				return ((TrashedModel)containerModel).isInTrash();
			}
		}
		catch (Exception exception) {
		}

		return false;
	}

	@Override
	public boolean isInTrashExplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return true;
		}

		return false;
	}

	@Override
	public boolean isInTrashImplicitly() {
		if (!isInTrash()) {
			return false;
		}

		com.liferay.trash.kernel.model.TrashEntry trashEntry =
			com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.
				fetchEntry(getModelClassName(), getTrashEntryClassPK());

		if (trashEntry != null) {
			return false;
		}

		return true;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), DLFileEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public DLFileEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, DLFileEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		DLFileEntryImpl dlFileEntryImpl = new DLFileEntryImpl();

		dlFileEntryImpl.setMvccVersion(getMvccVersion());
		dlFileEntryImpl.setCtCollectionId(getCtCollectionId());
		dlFileEntryImpl.setUuid(getUuid());
		dlFileEntryImpl.setFileEntryId(getFileEntryId());
		dlFileEntryImpl.setGroupId(getGroupId());
		dlFileEntryImpl.setCompanyId(getCompanyId());
		dlFileEntryImpl.setUserId(getUserId());
		dlFileEntryImpl.setUserName(getUserName());
		dlFileEntryImpl.setCreateDate(getCreateDate());
		dlFileEntryImpl.setModifiedDate(getModifiedDate());
		dlFileEntryImpl.setClassNameId(getClassNameId());
		dlFileEntryImpl.setClassPK(getClassPK());
		dlFileEntryImpl.setRepositoryId(getRepositoryId());
		dlFileEntryImpl.setFolderId(getFolderId());
		dlFileEntryImpl.setTreePath(getTreePath());
		dlFileEntryImpl.setName(getName());
		dlFileEntryImpl.setFileName(getFileName());
		dlFileEntryImpl.setExtension(getExtension());
		dlFileEntryImpl.setMimeType(getMimeType());
		dlFileEntryImpl.setTitle(getTitle());
		dlFileEntryImpl.setDescription(getDescription());
		dlFileEntryImpl.setExtraSettings(getExtraSettings());
		dlFileEntryImpl.setFileEntryTypeId(getFileEntryTypeId());
		dlFileEntryImpl.setVersion(getVersion());
		dlFileEntryImpl.setSize(getSize());
		dlFileEntryImpl.setSmallImageId(getSmallImageId());
		dlFileEntryImpl.setLargeImageId(getLargeImageId());
		dlFileEntryImpl.setCustom1ImageId(getCustom1ImageId());
		dlFileEntryImpl.setCustom2ImageId(getCustom2ImageId());
		dlFileEntryImpl.setManualCheckInRequired(isManualCheckInRequired());
		dlFileEntryImpl.setLastPublishDate(getLastPublishDate());

		dlFileEntryImpl.resetOriginalValues();

		return dlFileEntryImpl;
	}

	@Override
	public int compareTo(DLFileEntry dlFileEntry) {
		int value = 0;

		if (getFolderId() < dlFileEntry.getFolderId()) {
			value = -1;
		}
		else if (getFolderId() > dlFileEntry.getFolderId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		value = getName().compareTo(dlFileEntry.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof DLFileEntry)) {
			return false;
		}

		DLFileEntry dlFileEntry = (DLFileEntry)obj;

		long primaryKey = dlFileEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		DLFileEntryModelImpl dlFileEntryModelImpl = this;

		dlFileEntryModelImpl._originalUuid = dlFileEntryModelImpl._uuid;

		dlFileEntryModelImpl._originalGroupId = dlFileEntryModelImpl._groupId;

		dlFileEntryModelImpl._setOriginalGroupId = false;

		dlFileEntryModelImpl._originalCompanyId =
			dlFileEntryModelImpl._companyId;

		dlFileEntryModelImpl._setOriginalCompanyId = false;

		dlFileEntryModelImpl._originalUserId = dlFileEntryModelImpl._userId;

		dlFileEntryModelImpl._setOriginalUserId = false;

		dlFileEntryModelImpl._setModifiedDate = false;

		dlFileEntryModelImpl._originalRepositoryId =
			dlFileEntryModelImpl._repositoryId;

		dlFileEntryModelImpl._setOriginalRepositoryId = false;

		dlFileEntryModelImpl._originalFolderId = dlFileEntryModelImpl._folderId;

		dlFileEntryModelImpl._setOriginalFolderId = false;

		dlFileEntryModelImpl._originalName = dlFileEntryModelImpl._name;

		dlFileEntryModelImpl._originalFileName = dlFileEntryModelImpl._fileName;

		dlFileEntryModelImpl._originalMimeType = dlFileEntryModelImpl._mimeType;

		dlFileEntryModelImpl._originalTitle = dlFileEntryModelImpl._title;

		dlFileEntryModelImpl._originalFileEntryTypeId =
			dlFileEntryModelImpl._fileEntryTypeId;

		dlFileEntryModelImpl._setOriginalFileEntryTypeId = false;

		dlFileEntryModelImpl._originalSmallImageId =
			dlFileEntryModelImpl._smallImageId;

		dlFileEntryModelImpl._setOriginalSmallImageId = false;

		dlFileEntryModelImpl._originalLargeImageId =
			dlFileEntryModelImpl._largeImageId;

		dlFileEntryModelImpl._setOriginalLargeImageId = false;

		dlFileEntryModelImpl._originalCustom1ImageId =
			dlFileEntryModelImpl._custom1ImageId;

		dlFileEntryModelImpl._setOriginalCustom1ImageId = false;

		dlFileEntryModelImpl._originalCustom2ImageId =
			dlFileEntryModelImpl._custom2ImageId;

		dlFileEntryModelImpl._setOriginalCustom2ImageId = false;

		dlFileEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<DLFileEntry> toCacheModel() {
		DLFileEntryCacheModel dlFileEntryCacheModel =
			new DLFileEntryCacheModel();

		dlFileEntryCacheModel.mvccVersion = getMvccVersion();

		dlFileEntryCacheModel.ctCollectionId = getCtCollectionId();

		dlFileEntryCacheModel.uuid = getUuid();

		String uuid = dlFileEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			dlFileEntryCacheModel.uuid = null;
		}

		dlFileEntryCacheModel.fileEntryId = getFileEntryId();

		dlFileEntryCacheModel.groupId = getGroupId();

		dlFileEntryCacheModel.companyId = getCompanyId();

		dlFileEntryCacheModel.userId = getUserId();

		dlFileEntryCacheModel.userName = getUserName();

		String userName = dlFileEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			dlFileEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			dlFileEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			dlFileEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			dlFileEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			dlFileEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		dlFileEntryCacheModel.classNameId = getClassNameId();

		dlFileEntryCacheModel.classPK = getClassPK();

		dlFileEntryCacheModel.repositoryId = getRepositoryId();

		dlFileEntryCacheModel.folderId = getFolderId();

		dlFileEntryCacheModel.treePath = getTreePath();

		String treePath = dlFileEntryCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			dlFileEntryCacheModel.treePath = null;
		}

		dlFileEntryCacheModel.name = getName();

		String name = dlFileEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			dlFileEntryCacheModel.name = null;
		}

		dlFileEntryCacheModel.fileName = getFileName();

		String fileName = dlFileEntryCacheModel.fileName;

		if ((fileName != null) && (fileName.length() == 0)) {
			dlFileEntryCacheModel.fileName = null;
		}

		dlFileEntryCacheModel.extension = getExtension();

		String extension = dlFileEntryCacheModel.extension;

		if ((extension != null) && (extension.length() == 0)) {
			dlFileEntryCacheModel.extension = null;
		}

		dlFileEntryCacheModel.mimeType = getMimeType();

		String mimeType = dlFileEntryCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			dlFileEntryCacheModel.mimeType = null;
		}

		dlFileEntryCacheModel.title = getTitle();

		String title = dlFileEntryCacheModel.title;

		if ((title != null) && (title.length() == 0)) {
			dlFileEntryCacheModel.title = null;
		}

		dlFileEntryCacheModel.description = getDescription();

		String description = dlFileEntryCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			dlFileEntryCacheModel.description = null;
		}

		dlFileEntryCacheModel.extraSettings = getExtraSettings();

		String extraSettings = dlFileEntryCacheModel.extraSettings;

		if ((extraSettings != null) && (extraSettings.length() == 0)) {
			dlFileEntryCacheModel.extraSettings = null;
		}

		dlFileEntryCacheModel.fileEntryTypeId = getFileEntryTypeId();

		dlFileEntryCacheModel.version = getVersion();

		String version = dlFileEntryCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			dlFileEntryCacheModel.version = null;
		}

		dlFileEntryCacheModel.size = getSize();

		dlFileEntryCacheModel.smallImageId = getSmallImageId();

		dlFileEntryCacheModel.largeImageId = getLargeImageId();

		dlFileEntryCacheModel.custom1ImageId = getCustom1ImageId();

		dlFileEntryCacheModel.custom2ImageId = getCustom2ImageId();

		dlFileEntryCacheModel.manualCheckInRequired = isManualCheckInRequired();

		Date lastPublishDate = getLastPublishDate();

		if (lastPublishDate != null) {
			dlFileEntryCacheModel.lastPublishDate = lastPublishDate.getTime();
		}
		else {
			dlFileEntryCacheModel.lastPublishDate = Long.MIN_VALUE;
		}

		return dlFileEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			4 * attributeGetterFunctions.size() + 2);

		sb.append("{");

		for (Map.Entry<String, Function<DLFileEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append(attributeName);
			sb.append("=");
			sb.append(attributeGetterFunction.apply((DLFileEntry)this));
			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<DLFileEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			5 * attributeGetterFunctions.size() + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<DLFileEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<DLFileEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((DLFileEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, DLFileEntry>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private String _originalUuid;
	private long _fileEntryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _repositoryId;
	private long _originalRepositoryId;
	private boolean _setOriginalRepositoryId;
	private long _folderId;
	private long _originalFolderId;
	private boolean _setOriginalFolderId;
	private String _treePath;
	private String _name;
	private String _originalName;
	private String _fileName;
	private String _originalFileName;
	private String _extension;
	private String _mimeType;
	private String _originalMimeType;
	private String _title;
	private String _originalTitle;
	private String _description;
	private String _extraSettings;
	private long _fileEntryTypeId;
	private long _originalFileEntryTypeId;
	private boolean _setOriginalFileEntryTypeId;
	private String _version;
	private long _size;
	private long _smallImageId;
	private long _originalSmallImageId;
	private boolean _setOriginalSmallImageId;
	private long _largeImageId;
	private long _originalLargeImageId;
	private boolean _setOriginalLargeImageId;
	private long _custom1ImageId;
	private long _originalCustom1ImageId;
	private boolean _setOriginalCustom1ImageId;
	private long _custom2ImageId;
	private long _originalCustom2ImageId;
	private boolean _setOriginalCustom2ImageId;
	private boolean _manualCheckInRequired;
	private Date _lastPublishDate;
	private long _columnBitmask;
	private DLFileEntry _escapedModel;

}