/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.alloy;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.model.BaseModel;
import java.lang.reflect.Method;
import java.util.List;

public class AlloyServiceInvoker {
    protected Method dynamicQueryCountMethod;
    protected Method dynamicQueryMethod;
    protected Method fetchModelMethod;
    protected Method getModelsCountMethod;
    protected Method getModelsMethod;

    public AlloyServiceInvoker(String className) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        int pos = className.indexOf(".model.");
        String simpleClassName = className.substring(pos + 7);
        String serviceClassName = String.valueOf(className.substring(0, pos)) + ".service." + simpleClassName + "LocalServiceUtil";
        try {
            Class<?> serviceClass = classLoader.loadClass(serviceClassName);
            this.dynamicQueryCountMethod = serviceClass.getMethod("dynamicQueryCount", DynamicQuery.class);
            this.dynamicQueryMethod = serviceClass.getMethod("dynamicQuery", DynamicQuery.class);
            this.fetchModelMethod = serviceClass.getMethod("fetch" + simpleClassName, Long.TYPE);
            this.getModelsCountMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName) + "Count", new Class[0]);
            this.getModelsMethod = serviceClass.getMethod("get" + TextFormatter.formatPlural((String)simpleClassName), Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List dynamicQuery(DynamicQuery dynamicQuery) throws Exception {
        return (List)this.dynamicQueryMethod.invoke((Object)false, dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) throws Exception {
        return (Long)this.dynamicQueryCountMethod.invoke((Object)false, dynamicQuery);
    }

    public BaseModel<?> fetchModel(long classPK) throws Exception {
        return (BaseModel)this.fetchModelMethod.invoke((Object)false, classPK);
    }

    public List getModels(int start, int end) throws Exception {
        return (List)this.getModelsMethod.invoke((Object)false, start, end);
    }

    public int getModelsCount() throws Exception {
        return (Integer)this.getModelsCountMethod.invoke((Object)false, new Object[0]);
    }
}

