/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.jsf.common;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class JSFPortletUtil {
    private static Log _log = LogFactoryUtil.getLog(JSFPortletUtil.class);

    public static long getCompanyId(FacesContext facesContext) {
        return JSFPortletUtil.getCompanyId(JSFPortletUtil.getPortletRequest(facesContext));
    }

    public static long getCompanyId(PortletRequest portletRequest) {
        long companyId = 0L;
        Map userInfo = (Map)portletRequest.getAttribute("javax.portlet.userinfo");
        if (userInfo != null) {
            companyId = GetterUtil.getLong((String)((String)userInfo.get("liferay.company.id")));
        }
        return companyId;
    }

    public static Locale getLocale(FacesContext facesContext) {
        Locale locale = facesContext.getViewRoot().getLocale();
        if (locale == null) {
            locale = facesContext.getApplication().getDefaultLocale();
        }
        return locale;
    }

    public static PortletPreferences getPortletPreferences(FacesContext facesContext) {
        return JSFPortletUtil.getPortletRequest(facesContext).getPreferences();
    }

    public static PortletRequest getPortletRequest(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        if (request == null) {
            return null;
        }
        if (request instanceof PortletRequest) {
            return (PortletRequest)request;
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Object portletArtifactHack = httpServletRequest.getAttribute("com.icesoft.faces.portletHack");
            if (portletArtifactHack == null) {
                return null;
            }
            try {
                Object value;
                Class<?> portletArtifactHackClass = portletArtifactHack.getClass();
                Method method = portletArtifactHackClass.getMethod("getPortletRequest", new Class[0]);
                if (method != null && (value = method.invoke(portletArtifactHack, new Object[0])) != null && value instanceof PortletRequest) {
                    return (PortletRequest)value;
                }
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return null;
    }

    public static String getPreferenceValue(FacesContext facesContext, String preferenceName) {
        return JSFPortletUtil.getPreferenceValue(facesContext, preferenceName, null);
    }

    public static String getPreferenceValue(FacesContext facesContext, String preferenceName, String defaultValue) {
        return JSFPortletUtil.getPreferenceValue(JSFPortletUtil.getPortletPreferences(facesContext), preferenceName, defaultValue);
    }

    public static String getPreferenceValue(PortletPreferences portletPreferences, String preferenceName) {
        return JSFPortletUtil.getPreferenceValue(portletPreferences, preferenceName, null);
    }

    public static String getPreferenceValue(PortletPreferences portletPreferences, String preferenceName, String defaultValue) {
        String value = defaultValue;
        if (portletPreferences != null) {
            value = portletPreferences.getValue(preferenceName, defaultValue);
        }
        return value;
    }
}

