/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.bridges.jsf.icefaces;

import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.bridges.jsf.common.FacesMessageUtil;
import java.text.DecimalFormat;
import java.util.EventObject;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;

public class FileUploadManagedBean
implements Renderable {
    private static Log _log = LogFactoryUtil.getLog(FileUploadManagedBean.class);
    private InputFile _inputFile;
    private int _percent;
    private RenderManager _renderManager;
    private PersistentFacesState _state = PersistentFacesState.getInstance();

    public void actionListener(ActionEvent actionEvent) {
        InputFile inputFile = (InputFile)actionEvent.getSource();
        int status = inputFile.getStatus();
        try {
            if (status == 3) {
                this.addErrorMessage("file-type-is-invalid");
                this._percent = 100;
            } else if (status == 2) {
                this._percent = 100;
            } else if (status == 4) {
                long maxFileSizeInBytes = this._inputFile.getSizeMax();
                DecimalFormat decimalFormat = new DecimalFormat();
                decimalFormat.setGroupingUsed(false);
                decimalFormat.setMaximumFractionDigits(2);
                decimalFormat.setMinimumFractionDigits(0);
                String maxFileSizeInMegs = decimalFormat.format((double)maxFileSizeInBytes / 1024.0 / 1024.0);
                this.addErrorMessage("file-size-is-larger-than-x-megabytes", maxFileSizeInMegs);
                this._percent = 100;
            } else if (status == 5) {
                this.addErrorMessage("file-size-was-not-specified-in-the-request");
                this._percent = 100;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            this.addErrorMessage(e.getMessage());
        }
    }

    public InputFile getInputFile() {
        return this._inputFile;
    }

    public int getPercent() {
        return this._percent;
    }

    public PersistentFacesState getState() {
        return this._state;
    }

    public boolean isComplete() {
        return this._percent == 100;
    }

    public void progressListener(EventObject eventObject) {
        InputFile inputFile = (InputFile)eventObject.getSource();
        this._percent = inputFile.getFileInfo().getPercent();
        this._renderManager.requestRender((Renderable)this);
    }

    public void renderingException(RenderingException renderingException) {
        _log.error((Object)renderingException.getMessage());
    }

    public void setInputFile(InputFile inputFile) {
        this._inputFile = inputFile;
    }

    public void setPercent(int percent) {
        this._percent = percent;
    }

    public void setRenderManager(RenderManager renderManager) {
        this._renderManager = renderManager;
    }

    protected void addErrorMessage(String key) {
        this.addErrorMessage(key, null);
    }

    protected void addErrorMessage(String key, String argument) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (this._inputFile == null) {
            FacesMessageUtil.error(facesContext, key, (Object)argument);
        } else {
            FacesMessageUtil.error(this._inputFile.getClientId(facesContext), facesContext, key, argument);
        }
    }
}

