/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portletmvc4spring.test.mock.web.portlet;

import com.liferay.portletmvc4spring.test.mock.web.portlet.MockPortalContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortalContext;
import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.springframework.util.Assert;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MockPortletResponse
implements PortletResponse {
    private final PortalContext portalContext;
    private final Map<String, String[]> properties = new LinkedHashMap<String, String[]>();
    private String namespace = "";
    private final Set<Cookie> cookies = new LinkedHashSet<Cookie>();
    private final Map<String, Element[]> xmlProperties = new LinkedHashMap<String, Element[]>();
    private Document xmlDocument;

    public MockPortletResponse() {
        this(null);
    }

    public MockPortletResponse(PortalContext portalContext) {
        this.portalContext = portalContext != null ? portalContext : new MockPortalContext();
    }

    public void addProperty(Cookie cookie) {
        Assert.notNull((Object)cookie, (String)"Cookie must not be null");
        this.cookies.add(cookie);
    }

    public void addProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        String[] oldArr = this.properties.get(key);
        if (oldArr != null) {
            String[] newArr = new String[oldArr.length + 1];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            newArr[oldArr.length] = value;
            this.properties.put(key, newArr);
        } else {
            this.properties.put(key, new String[]{value});
        }
    }

    public void addProperty(String key, Element value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        Element[] oldArr = this.xmlProperties.get(key);
        if (oldArr != null) {
            Element[] newArr = new Element[oldArr.length + 1];
            System.arraycopy(oldArr, 0, newArr, 0, oldArr.length);
            newArr[oldArr.length] = value;
            this.xmlProperties.put(key, newArr);
        } else {
            this.xmlProperties.put(key, new Element[]{value});
        }
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.xmlDocument == null) {
            try {
                this.xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException ex) {
                throw new DOMException(11, ex.toString());
            }
        }
        return this.xmlDocument.createElement(tagName);
    }

    public String encodeURL(String path) {
        return path;
    }

    public Cookie getCookie(String name) {
        Assert.notNull((Object)name, (String)"Cookie name must not be null");
        for (Cookie cookie : this.cookies) {
            if (!name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PortalContext getPortalContext() {
        return this.portalContext;
    }

    public String[] getProperties(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        return this.properties.get(key);
    }

    public String getProperty(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        String[] arr = this.properties.get(key);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public Collection<String> getPropertyValues(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        return Arrays.asList((Object[])this.properties.get(key));
    }

    public Element[] getXmlProperties(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        return this.xmlProperties.get(key);
    }

    public Element getXmlProperty(String key) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        Element[] arr = this.xmlProperties.get(key);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public Set<String> getXmlPropertyNames() {
        return Collections.unmodifiableSet(this.xmlProperties.keySet());
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setProperty(String key, String value) {
        Assert.notNull((Object)key, (String)"Property key must not be null");
        this.properties.put(key, new String[]{value});
    }
}

