/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.registry.impl;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.pattern.Patterns;
import com.lightbend.lagom.internal.javadsl.registry.RegisteredService;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistry;
import com.lightbend.lagom.internal.javadsl.registry.ServiceRegistryService;
import com.lightbend.lagom.javadsl.api.ServiceCall;
import com.lightbend.lagom.javadsl.api.transport.NotFound;
import com.lightbend.lagom.registry.impl.ServiceRegistryActor;
import com.lightbend.lagom.registry.impl.ServiceRegistryActor$GetRegisteredServices$;
import java.net.URI;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import org.pcollections.PSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistryImpl.class);
    private final Duration timeout = Duration.ofSeconds(5L);
    private final ActorRef registry;

    @Inject
    public ServiceRegistryImpl(@Named(value="serviceRegistryActor") ActorRef actorRef) {
        this.registry = actorRef;
    }

    public ServiceCall<ServiceRegistryService, NotUsed> register(String string) {
        return serviceRegistryService -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("register invoked, name=[" + string + "], request=[" + serviceRegistryService + "]");
            }
            return Patterns.ask((ActorRef)this.registry, (Object)new ServiceRegistryActor.Register(string, (ServiceRegistryService)serviceRegistryService), (Duration)this.timeout).thenApply(object -> NotUsed.getInstance());
        };
    }

    public ServiceCall<NotUsed, NotUsed> unregister(String string) {
        return notUsed -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unregister invoked, name=[" + string + "], request=[" + notUsed + "]");
            }
            this.registry.tell((Object)new ServiceRegistryActor.Remove(string), null);
            return CompletableFuture.completedFuture(NotUsed.getInstance());
        };
    }

    public ServiceCall<NotUsed, URI> lookup(String string, Optional<String> optional) {
        return notUsed -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("locate invoked, name=[" + string + "] and portName=[" + optional + "] . request=[" + notUsed + "]");
            }
            return Patterns.ask((ActorRef)this.registry, (Object)new ServiceRegistryActor.Lookup(string, (Option<String>)OptionConverters.toScala((Optional)optional)), (Duration)this.timeout).thenApply(object -> {
                Optional optional2 = OptionConverters.toJava((Option)((Option)object));
                this.logServiceLookupResult(string, optional2);
                if (optional2.isPresent()) {
                    return (URI)optional2.get();
                }
                throw new NotFound("Can't find service " + string + " with port" + optional);
            });
        };
    }

    public ServiceCall<NotUsed, PSequence<RegisteredService>> registeredServices() {
        return notUsed -> Patterns.ask((ActorRef)this.registry, (Object)ServiceRegistryActor$GetRegisteredServices$.MODULE$, (Duration)this.timeout).thenApply(object -> {
            ServiceRegistryActor.RegisteredServices registeredServices = (ServiceRegistryActor.RegisteredServices)object;
            return registeredServices.services();
        });
    }

    private void logServiceLookupResult(String string, Optional<URI> optional) {
        if (LOGGER.isDebugEnabled()) {
            if (optional.isPresent()) {
                LOGGER.debug("Location of service name=[" + string + "] is " + optional.get());
            } else {
                LOGGER.debug("Service name=[" + string + "] has not been registered");
            }
        }
    }
}

