/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.internal.javadsl.registry;

import akka.util.ByteString;
import com.lightbend.lagom.javadsl.api.deser.DeserializationException;
import com.lightbend.lagom.javadsl.api.deser.MessageSerializer;
import com.lightbend.lagom.javadsl.api.deser.SerializationException;
import com.lightbend.lagom.javadsl.api.deser.StrictMessageSerializer;
import com.lightbend.lagom.javadsl.api.transport.MessageProtocol;
import com.lightbend.lagom.javadsl.api.transport.NotAcceptable;
import com.lightbend.lagom.javadsl.api.transport.UnsupportedMediaType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

class CustomSerializers {
    public static final StrictMessageSerializer<URI> URI = new StrictMessageSerializer<URI>(){
        MessageProtocol defaultProtocol = new MessageProtocol(Optional.of("text/plain"), Optional.of("utf-8"), Optional.empty());

        public MessageSerializer.NegotiatedSerializer<URI, ByteString> serializerForRequest() {
            return new URISerializer(this.defaultProtocol);
        }

        public MessageSerializer.NegotiatedDeserializer<URI, ByteString> deserializer(MessageProtocol messageProtocol) throws UnsupportedMediaType {
            if (messageProtocol.contentType().orElse("text/plain").equals("text/plain")) {
                return new URIDeserializer(messageProtocol.charset().orElse("utf-8"));
            }
            throw new UnsupportedMediaType(messageProtocol, this.defaultProtocol);
        }

        public MessageSerializer.NegotiatedSerializer<URI, ByteString> serializerForResponse(List<MessageProtocol> list) throws NotAcceptable {
            if (list.isEmpty()) {
                return this.serializerForRequest();
            }
            for (MessageProtocol messageProtocol : list) {
                String string = messageProtocol.contentType().orElse("text/plain");
                if (!string.equals("text/plain") && !string.equals("text/*") && !string.equals("*/*") && !string.equals("*")) continue;
                return new URISerializer(messageProtocol.withContentType("text/plain"));
            }
            throw new NotAcceptable(list, this.defaultProtocol);
        }

        class URIDeserializer
        implements MessageSerializer.NegotiatedDeserializer<URI, ByteString> {
            private final String charset;

            URIDeserializer(String string) {
                this.charset = string;
            }

            public URI deserialize(ByteString byteString) throws DeserializationException {
                try {
                    return new URI(byteString.decodeString(this.charset));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DeserializationException((Throwable)uRISyntaxException);
                }
            }
        }

        class URISerializer
        implements MessageSerializer.NegotiatedSerializer<URI, ByteString> {
            private final MessageProtocol protocol;

            URISerializer(MessageProtocol messageProtocol) {
                this.protocol = messageProtocol;
            }

            public MessageProtocol protocol() {
                return this.protocol;
            }

            public ByteString serialize(URI uRI) throws SerializationException {
                return ByteString.fromString((String)uRI.toString(), (String)this.protocol.charset().orElse("utf-8"));
            }
        }
    };

    CustomSerializers() {
    }
}

