/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.linecorp.armeria.common.thrift.text.BaseContext;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

class PairContext
extends BaseContext {
    @Nullable
    private final Iterator<Map.Entry<String, JsonNode>> children;
    private boolean lhs;
    @Nullable
    private Map.Entry<String, JsonNode> currentChild;

    protected PairContext(@Nullable JsonNode json) {
        this.children = null != json ? json.fields() : null;
    }

    @Override
    protected final void write() {
        this.lhs = !this.lhs;
    }

    @Override
    protected final void read() {
        boolean bl = this.lhs = !this.lhs;
        if (this.isLhs()) {
            assert (this.children != null);
            if (!this.children.hasNext()) {
                throw new RuntimeException("Called PairContext.read() too many times!");
            }
            this.currentChild = this.children.next();
        }
    }

    @Override
    protected final JsonNode getCurrentChild() {
        assert (this.currentChild != null);
        if (this.lhs) {
            return new TextNode(this.currentChild.getKey());
        }
        return this.currentChild.getValue();
    }

    @Override
    protected final boolean hasMoreChildren() {
        assert (this.children != null);
        return this.children.hasNext();
    }

    protected final boolean isLhs() {
        return this.lhs;
    }
}

