/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.thrift.text.BaseContext;
import com.linecorp.armeria.common.thrift.text.MapContext;
import com.linecorp.armeria.common.thrift.text.SequenceContext;
import com.linecorp.armeria.common.thrift.text.StructContext;
import com.linecorp.armeria.common.thrift.text.TypedParser;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Stack;
import javax.annotation.Nullable;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

final class TTextProtocol
extends TProtocol {
    private static final String SEQUENCE_AS_KEY_ILLEGAL = "Can't have a sequence (list or set) as a key in a map!";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    private static final TStruct ANONYMOUS_STRUCT = new TStruct();
    private static final int READ_BUFFER_SIZE = 1024;
    private static final byte UNUSED_TYPE = 0;
    private final Stack<WriterByteArrayOutputStream> writers = new Stack();
    private final Stack<BaseContext> contextStack = new Stack();
    private final Stack<Class<?>> currentFieldClass = new Stack();
    private final boolean useNamedEnums;
    @Nullable
    private JsonNode root;

    TTextProtocol(TTransport trans) {
        this(trans, false);
    }

    TTextProtocol(TTransport trans, boolean useNamedEnums) {
        super(trans);
        this.useNamedEnums = useNamedEnums;
        this.reset();
    }

    public Class<? extends IScheme> getScheme() {
        return StandardScheme.class;
    }

    public void reset() {
        this.root = null;
        this.writers.clear();
        this.pushWriter(new TTransportOutputStream());
        this.contextStack.clear();
        this.contextStack.push(new BaseContext());
        this.currentFieldClass.clear();
    }

    public void writeMessageBegin(TMessage message) throws TException {
        try {
            this.getCurrentWriter().writeStartObject();
            this.getCurrentWriter().writeFieldName("method");
            this.getCurrentWriter().writeString(message.name);
            this.getCurrentWriter().writeFieldName("type");
            TypedParser.TMESSAGE_TYPE.writeValue(this.getCurrentWriter(), message.type);
            this.getCurrentWriter().writeFieldName("seqid");
            this.getCurrentWriter().writeNumber(message.seqid);
            this.getCurrentWriter().writeFieldName("args");
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    public void writeMessageEnd() throws TException {
        try {
            this.getCurrentWriter().writeEndObject();
            this.getCurrentWriter().flush();
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    public void writeStructBegin(TStruct struct) throws TException {
        this.writeJsonObjectBegin(new StructContext(null));
    }

    public void writeStructEnd() throws TException {
        this.writeJsonObjectEnd();
    }

    public void writeFieldBegin(TField field) throws TException {
        try {
            this.getCurrentWriter().writeFieldName(field.name);
        }
        catch (IOException ex) {
            throw new TException((Throwable)ex);
        }
        this.currentFieldClass.push(this.getCurrentContext().getClassByFieldName(field.name));
    }

    public void writeFieldEnd() throws TException {
        this.currentFieldClass.pop();
    }

    public void writeFieldStop() throws TException {
    }

    public void writeMapBegin(TMap map) throws TException {
        this.writeJsonObjectBegin(new MapContext(null));
    }

    public void writeMapEnd() throws TException {
        this.writeJsonObjectEnd();
    }

    private void writeJsonObjectBegin(BaseContext context) throws TException {
        this.getCurrentContext().write();
        if (this.getCurrentContext().isMapKey()) {
            this.pushWriter(new ByteArrayOutputStream());
        }
        this.pushContext(context);
        try {
            this.getCurrentWriter().writeStartObject();
        }
        catch (IOException ex) {
            throw new TException((Throwable)ex);
        }
    }

    private void writeJsonObjectEnd() throws TException {
        try {
            this.getCurrentWriter().writeEndObject();
            this.popContext();
            if (this.getCurrentContext().isMapKey()) {
                String writerString = this.getWriterString();
                this.popWriter();
                this.getCurrentWriter().writeFieldName(writerString);
            }
            if (1 == this.contextStack.size()) {
                this.getCurrentWriter().flush();
            }
        }
        catch (IOException ex) {
            throw new TException((Throwable)ex);
        }
    }

    public void writeListBegin(TList list) throws TException {
        this.writeSequenceBegin();
    }

    public void writeListEnd() throws TException {
        this.writeSequenceEnd();
    }

    public void writeSetBegin(TSet set) throws TException {
        this.writeSequenceBegin();
    }

    public void writeSetEnd() throws TException {
        this.writeListEnd();
    }

    private void writeSequenceBegin() throws TException {
        this.getCurrentContext().write();
        if (this.getCurrentContext().isMapKey()) {
            throw new TException(SEQUENCE_AS_KEY_ILLEGAL);
        }
        this.pushContext(new SequenceContext(null));
        try {
            this.getCurrentWriter().writeStartArray();
        }
        catch (IOException ex) {
            throw new TTransportException((Throwable)ex);
        }
    }

    private void writeSequenceEnd() throws TException {
        try {
            this.getCurrentWriter().writeEndArray();
        }
        catch (IOException ex) {
            throw new TTransportException((Throwable)ex);
        }
        this.popContext();
    }

    public void writeBool(boolean b) throws TException {
        this.writeNameOrValue(TypedParser.BOOLEAN, b);
    }

    public void writeByte(byte b) throws TException {
        this.writeNameOrValue(TypedParser.BYTE, b);
    }

    public void writeI16(short i16) throws TException {
        this.writeNameOrValue(TypedParser.SHORT, i16);
    }

    public void writeI32(int i32) throws TException {
        if (!this.useNamedEnums) {
            this.writeNameOrValue(TypedParser.INTEGER, i32);
            return;
        }
        Class<?> fieldClass = this.getCurrentFieldClassIfIs(TEnum.class);
        if (fieldClass == null) {
            this.writeNameOrValue(TypedParser.INTEGER, i32);
            return;
        }
        try {
            Method method = fieldClass.getMethod("findByValue", Integer.TYPE);
            String str = method.invoke(null, i32).toString();
            this.writeNameOrValue(TypedParser.STRING, str);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new TTransportException("invalid value for enum field " + fieldClass.getSimpleName() + ':' + i32);
        }
    }

    public void writeI64(long i64) throws TException {
        this.writeNameOrValue(TypedParser.LONG, i64);
    }

    public void writeDouble(double dub) throws TException {
        this.writeNameOrValue(TypedParser.DOUBLE, dub);
    }

    public void writeString(String str) throws TException {
        this.writeNameOrValue(TypedParser.STRING, str);
    }

    public void writeBinary(ByteBuffer buf) throws TException {
        this.writeNameOrValue(TypedParser.BINARY, buf);
    }

    private <T> void writeNameOrValue(TypedParser<T> helper, T val) throws TException {
        this.getCurrentContext().write();
        try {
            if (this.getCurrentContext().isMapKey()) {
                this.getCurrentWriter().writeFieldName(val.toString());
            } else {
                helper.writeValue(this.getCurrentWriter(), val);
            }
        }
        catch (IOException ex) {
            throw new TException((Throwable)ex);
        }
    }

    public TMessage readMessageBegin() throws TException {
        this.root = null;
        try {
            this.readRoot();
        }
        catch (IOException e) {
            throw new TException("Could not parse input, is it valid json?", (Throwable)e);
        }
        if (!this.root.isObject()) {
            throw new TException("The top level of the input must be a json object with method and args!");
        }
        if (!this.root.has("method")) {
            throw new TException("Object must have field 'method' with the rpc method name!");
        }
        String methodName = this.root.get("method").asText();
        if (!this.root.has("type")) {
            throw new TException("Object must have field 'type' with the message type (CALL, REPLY, EXCEPTION, ONEWAY)!");
        }
        Byte messageType = TypedParser.TMESSAGE_TYPE.readFromJsonElement(this.root.get("type"));
        if (!this.root.has("args") || !this.root.get("args").isObject()) {
            throw new TException("Object must have field 'args' with the rpc method args!");
        }
        int sequenceId = this.root.has("seqid") ? this.root.get("seqid").asInt() : 0;
        this.root = this.root.get("args");
        return new TMessage(methodName, messageType.byteValue(), sequenceId);
    }

    public void readMessageEnd() throws TException {
        this.root = null;
    }

    public TStruct readStructBegin() throws TException {
        JsonNode structElem;
        this.getCurrentContext().read();
        if (1 == this.contextStack.size()) {
            try {
                this.readRoot();
            }
            catch (IOException e) {
                throw new TException("Could not parse input, is it valid json?", (Throwable)e);
            }
            if (this.root == null) {
                throw new TException("parser.next() has nothing to parse!");
            }
            structElem = this.root;
        } else {
            structElem = this.getCurrentContext().getCurrentChild();
        }
        if (this.getCurrentContext().isMapKey()) {
            try {
                structElem = OBJECT_MAPPER.readTree(structElem.asText());
            }
            catch (IOException e) {
                throw new TException("Could not parse map key, is it valid json?", (Throwable)e);
            }
        }
        if (!structElem.isObject()) {
            throw new TException("Expected Json Object!");
        }
        Class<?> fieldClass = this.getCurrentFieldClassIfIs(TBase.class);
        if (fieldClass != null) {
            this.pushContext(new StructContext(structElem, fieldClass));
        } else {
            this.pushContext(new StructContext(structElem));
        }
        return ANONYMOUS_STRUCT;
    }

    public void readStructEnd() throws TException {
        this.popContext();
    }

    public TField readFieldBegin() throws TException {
        if (!this.getCurrentContext().hasMoreChildren()) {
            return new TField("", 0, 0);
        }
        this.getCurrentContext().read();
        JsonNode jsonName = this.getCurrentContext().getCurrentChild();
        if (!jsonName.isTextual()) {
            throw new RuntimeException("Expected String for a field name");
        }
        String fieldName = jsonName.asText();
        this.currentFieldClass.push(this.getCurrentContext().getClassByFieldName(fieldName));
        return this.getCurrentContext().getTFieldByName(fieldName);
    }

    public void readFieldEnd() throws TException {
        this.currentFieldClass.pop();
    }

    public TMap readMapBegin() throws TException {
        this.getCurrentContext().read();
        JsonNode curElem = this.getCurrentContext().getCurrentChild();
        if (this.getCurrentContext().isMapKey()) {
            try {
                curElem = OBJECT_MAPPER.readTree(curElem.asText());
            }
            catch (IOException e) {
                throw new TException("Could not parse map key, is it valid json?", (Throwable)e);
            }
        }
        if (!curElem.isObject()) {
            throw new TException("Expected JSON Object!");
        }
        this.pushContext(new MapContext(curElem));
        return new TMap(0, 0, curElem.size());
    }

    public void readMapEnd() throws TException {
        this.popContext();
    }

    public TList readListBegin() throws TException {
        int size = this.readSequenceBegin();
        return new TList(0, size);
    }

    public void readListEnd() throws TException {
        this.readSequenceEnd();
    }

    public TSet readSetBegin() throws TException {
        int size = this.readSequenceBegin();
        return new TSet(0, size);
    }

    public void readSetEnd() throws TException {
        this.readSequenceEnd();
    }

    private int readSequenceBegin() throws TException {
        this.getCurrentContext().read();
        if (this.getCurrentContext().isMapKey()) {
            throw new TException(SEQUENCE_AS_KEY_ILLEGAL);
        }
        JsonNode curElem = this.getCurrentContext().getCurrentChild();
        if (!curElem.isArray()) {
            throw new TException("Expected JSON Array!");
        }
        this.pushContext(new SequenceContext(curElem));
        return curElem.size();
    }

    private void readSequenceEnd() {
        this.popContext();
    }

    public boolean readBool() throws TException {
        return this.readNameOrValue(TypedParser.BOOLEAN);
    }

    public byte readByte() throws TException {
        return this.readNameOrValue(TypedParser.BYTE);
    }

    public short readI16() throws TException {
        return this.readNameOrValue(TypedParser.SHORT);
    }

    public int readI32() throws TException {
        Class<?> fieldClass = this.getCurrentFieldClassIfIs(TEnum.class);
        if (fieldClass != null) {
            this.getCurrentContext().read();
            JsonNode elem = this.getCurrentContext().getCurrentChild();
            if (elem.isInt()) {
                return TypedParser.INTEGER.readFromJsonElement(elem);
            }
            if (elem.isTextual()) {
                TEnum tEnum = (TEnum)Enum.valueOf(fieldClass, TypedParser.STRING.readFromJsonElement(elem));
                return tEnum.getValue();
            }
            throw new TTransportException("invalid value type for enum field: " + elem.getNodeType() + " (" + elem + ')');
        }
        return this.readNameOrValue(TypedParser.INTEGER);
    }

    public long readI64() throws TException {
        return this.readNameOrValue(TypedParser.LONG);
    }

    public double readDouble() throws TException {
        return this.readNameOrValue(TypedParser.DOUBLE);
    }

    public String readString() throws TException {
        return this.readNameOrValue(TypedParser.STRING);
    }

    public ByteBuffer readBinary() throws TException {
        return this.readNameOrValue(TypedParser.BINARY);
    }

    private <T> T readNameOrValue(TypedParser<T> ch) {
        this.getCurrentContext().read();
        JsonNode elem = this.getCurrentContext().getCurrentChild();
        if (this.getCurrentContext().isMapKey()) {
            return ch.readFromString(elem.asText());
        }
        return ch.readFromJsonElement(elem);
    }

    private void readRoot() throws IOException {
        ByteArrayOutputStream content;
        block4: {
            if (this.root != null) {
                return;
            }
            content = new ByteArrayOutputStream();
            byte[] buffer = TemporaryThreadLocals.get().byteArray(1024);
            try {
                while (this.trans_.read(buffer, 0, 1024) > 0) {
                    content.write(buffer);
                }
            }
            catch (TTransportException e) {
                if (4 == e.getType()) break block4;
                throw new IOException(e);
            }
        }
        this.root = OBJECT_MAPPER.readTree(content.toByteArray());
    }

    private BaseContext getCurrentContext() {
        return this.contextStack.peek();
    }

    private void pushContext(BaseContext c) {
        this.contextStack.push(c);
    }

    private void popContext() {
        this.contextStack.pop();
    }

    private JsonGenerator getCurrentWriter() {
        return this.writers.peek().writer;
    }

    private String getWriterString() throws TException {
        String ret;
        WriterByteArrayOutputStream wbaos = this.writers.peek();
        try {
            wbaos.writer.flush();
            ret = new String(wbaos.baos.toByteArray());
            wbaos.writer.close();
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        return ret;
    }

    @Nullable
    private Class<?> getCurrentFieldClassIfIs(Class<?> classToMatch) {
        if (this.currentFieldClass.isEmpty() || this.currentFieldClass.peek() == null) {
            return null;
        }
        Class<?> classToCheck = this.currentFieldClass.peek();
        if (classToMatch.isAssignableFrom(classToCheck)) {
            return classToCheck;
        }
        return null;
    }

    private void pushWriter(ByteArrayOutputStream baos) {
        JsonGenerator generator;
        try {
            generator = OBJECT_MAPPER.getFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8).useDefaultPrettyPrinter();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        WriterByteArrayOutputStream wbaos = new WriterByteArrayOutputStream(generator, baos);
        this.writers.push(wbaos);
    }

    private void popWriter() {
        this.writers.pop();
    }

    private class TTransportOutputStream
    extends ByteArrayOutputStream {
        private TTransportOutputStream() {
        }

        @Override
        public void close() throws IOException {
            this.flush();
            super.close();
            TTextProtocol.this.trans_.close();
        }

        @Override
        public void flush() throws IOException {
            try {
                super.flush();
                byte[] bytes = this.toByteArray();
                TTextProtocol.this.trans_.write(bytes);
                TTextProtocol.this.trans_.flush();
            }
            catch (TTransportException ex) {
                throw new IOException(ex);
            }
            this.reset();
        }
    }

    private static final class WriterByteArrayOutputStream {
        final JsonGenerator writer;
        final ByteArrayOutputStream baos;

        private WriterByteArrayOutputStream(JsonGenerator writer, ByteArrayOutputStream baos) {
            this.writer = writer;
            this.baos = baos;
        }
    }
}

