/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.thrift.text;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class TypedParser<T> {
    static final TypedParser<Boolean> BOOLEAN = new TypedParser<Boolean>(){

        @Override
        public Boolean readFromString(String s) {
            return Boolean.parseBoolean(s);
        }

        @Override
        public Boolean readFromJsonElement(JsonNode elem) {
            return elem.asBoolean();
        }

        @Override
        public void writeValue(JsonGenerator jw, Boolean val) throws IOException {
            jw.writeBoolean(val.booleanValue());
        }
    };
    static final TypedParser<Byte> BYTE = new TypedParser<Byte>(){

        @Override
        public Byte readFromString(String s) {
            return Byte.parseByte(s);
        }

        @Override
        public Byte readFromJsonElement(JsonNode elem) {
            return (byte)elem.asInt();
        }

        @Override
        public void writeValue(JsonGenerator jw, Byte val) throws IOException {
            jw.writeNumber((short)val.byteValue());
        }
    };
    static final TypedParser<Short> SHORT = new TypedParser<Short>(){

        @Override
        public Short readFromString(String s) {
            return Short.parseShort(s);
        }

        @Override
        public Short readFromJsonElement(JsonNode elem) {
            return (short)elem.asInt();
        }

        @Override
        public void writeValue(JsonGenerator jw, Short val) throws IOException {
            jw.writeNumber(val.shortValue());
        }
    };
    static final TypedParser<Integer> INTEGER = new TypedParser<Integer>(){

        @Override
        public Integer readFromString(String s) {
            return Integer.parseInt(s);
        }

        @Override
        public Integer readFromJsonElement(JsonNode elem) {
            return elem.asInt();
        }

        @Override
        public void writeValue(JsonGenerator jw, Integer val) throws IOException {
            jw.writeNumber(val.intValue());
        }
    };
    static final TypedParser<Long> LONG = new TypedParser<Long>(){

        @Override
        public Long readFromString(String s) {
            return Long.parseLong(s);
        }

        @Override
        public Long readFromJsonElement(JsonNode elem) {
            return elem.asLong();
        }

        @Override
        public void writeValue(JsonGenerator jw, Long val) throws IOException {
            jw.writeNumber(val.longValue());
        }
    };
    static final TypedParser<Double> DOUBLE = new TypedParser<Double>(){

        @Override
        public Double readFromString(String s) {
            return Double.parseDouble(s);
        }

        @Override
        public Double readFromJsonElement(JsonNode elem) {
            return elem.asDouble();
        }

        @Override
        public void writeValue(JsonGenerator jw, Double val) throws IOException {
            jw.writeNumber(val.doubleValue());
        }
    };
    static final TypedParser<String> STRING = new TypedParser<String>(){

        @Override
        public String readFromString(String s) {
            return s;
        }

        @Override
        public String readFromJsonElement(JsonNode elem) {
            return elem.asText();
        }

        @Override
        public void writeValue(JsonGenerator jw, String val) throws IOException {
            jw.writeString(val);
        }
    };
    static final TypedParser<ByteBuffer> BINARY = new TypedParser<ByteBuffer>(){

        @Override
        public ByteBuffer readFromString(String s) {
            return ByteBuffer.wrap(Base64Variants.getDefaultVariant().decode(s));
        }

        @Override
        public ByteBuffer readFromJsonElement(JsonNode elem) {
            try {
                return ByteBuffer.wrap(elem.binaryValue());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error decoding binary value, is it valid base64?", e);
            }
        }

        @Override
        public void writeValue(JsonGenerator jw, ByteBuffer val) throws IOException {
            jw.writeBinary(val.array());
        }
    };
    static final TypedParser<Byte> TMESSAGE_TYPE = new TypedParser<Byte>(){

        @Override
        Byte readFromString(String s) {
            switch (s) {
                case "CALL": {
                    return (byte)1;
                }
                case "REPLY": {
                    return (byte)2;
                }
                case "EXCEPTION": {
                    return (byte)3;
                }
                case "ONEWAY": {
                    return (byte)4;
                }
            }
            throw new IllegalArgumentException("Unsupported message type: " + s);
        }

        @Override
        Byte readFromJsonElement(JsonNode elem) {
            return this.readFromString(elem.asText());
        }

        @Override
        void writeValue(JsonGenerator jw, Byte val) throws IOException {
            String serialized;
            switch (val) {
                case 1: {
                    serialized = "CALL";
                    break;
                }
                case 2: {
                    serialized = "REPLY";
                    break;
                }
                case 3: {
                    serialized = "EXCEPTION";
                    break;
                }
                case 4: {
                    serialized = "ONEWAY";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported message type: " + val);
                }
            }
            jw.writeString(serialized);
        }
    };

    TypedParser() {
    }

    abstract T readFromString(String var1);

    abstract T readFromJsonElement(JsonNode var1);

    abstract void writeValue(JsonGenerator var1, T var2) throws IOException;
}

