/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.thrift;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.thrift.ThriftSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimaps;
import com.linecorp.armeria.server.RpcService;
import com.linecorp.armeria.server.thrift.THttpService;
import com.linecorp.armeria.server.thrift.ThriftCallService;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class THttpServiceBuilder {
    private static final SerializationFormat[] EMPTY_FORMATS = new SerializationFormat[0];
    private final ImmutableListMultimap.Builder<String, Object> implementationsBuilder = ImmutableListMultimap.builder();
    private SerializationFormat defaultSerializationFormat = ThriftSerializationFormats.BINARY;
    private Set<SerializationFormat> otherSerializationFormats = ThriftSerializationFormats.values();
    private boolean createOtherSerializations = true;
    @Nullable
    private Function<? super RpcService, ? extends RpcService> decoratorFunction;

    THttpServiceBuilder() {
    }

    private static SerializationFormat[] newAllowedSerializationFormats(SerializationFormat defaultSerializationFormat, Iterable<SerializationFormat> otherAllowedSerializationFormats) {
        Objects.requireNonNull(defaultSerializationFormat, "defaultSerializationFormat");
        Objects.requireNonNull(otherAllowedSerializationFormats, "otherAllowedSerializationFormats");
        LinkedHashSet<SerializationFormat> set = new LinkedHashSet<SerializationFormat>();
        set.add(defaultSerializationFormat);
        Iterables.addAll(set, otherAllowedSerializationFormats);
        return set.toArray(EMPTY_FORMATS);
    }

    public THttpServiceBuilder addService(String name, Object implementation) {
        this.implementationsBuilder.put((Object)name, implementation);
        return this;
    }

    public THttpServiceBuilder addService(Object implementation) {
        return this.addService("", implementation);
    }

    public THttpServiceBuilder otherSerializationFormats(SerializationFormat otherSerializationFormat) {
        Objects.requireNonNull(otherSerializationFormat, "otherSerializationFormat");
        return this.otherSerializationFormats((Iterable<SerializationFormat>)ImmutableList.of((Object)otherSerializationFormat));
    }

    public THttpServiceBuilder otherSerializationFormats(Iterable<SerializationFormat> otherSerializationFormats) {
        Objects.requireNonNull(otherSerializationFormats, "otherSerializationFormats");
        if (this.createOtherSerializations) {
            this.otherSerializationFormats = new LinkedHashSet<SerializationFormat>();
            this.createOtherSerializations = false;
        }
        otherSerializationFormats.forEach(this.otherSerializationFormats::add);
        return this;
    }

    public THttpServiceBuilder defaultSerializationFormat(SerializationFormat defaultSerializationFormat) {
        Objects.requireNonNull(defaultSerializationFormat, "defaultSerializationFormat");
        this.defaultSerializationFormat = defaultSerializationFormat;
        return this;
    }

    public THttpServiceBuilder decorate(Function<? super RpcService, ? extends RpcService> decoratorFunction) {
        Objects.requireNonNull(decoratorFunction, "decoratorFunction");
        this.decoratorFunction = this.decoratorFunction == null ? decoratorFunction : this.decoratorFunction.andThen(decoratorFunction);
        return this;
    }

    private RpcService decorate(RpcService service) {
        if (this.decoratorFunction != null) {
            return (RpcService)service.decorate(this.decoratorFunction);
        }
        return service;
    }

    public THttpService build() {
        Map implementations = Multimaps.asMap((ListMultimap)this.implementationsBuilder.build());
        ThriftCallService tcs = ThriftCallService.of(implementations);
        return new THttpService(this.decorate(tcs), THttpServiceBuilder.newAllowedSerializationFormats(this.defaultSerializationFormat, this.otherSerializationFormats));
    }
}

