/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.booleval;

import com.linkare.booleval.utils.WildcardToRegexUtility;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ExpressionParser {
    private static final String EMPTY_STRING = "";
    private static final String ONE_SPACE = " ";
    private static final String EQUAL_CHAR = "=";
    private static final String XOR_CHAR = "^";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String NOT_CHAR = "!";
    private static final String AND_CHAR = "&";
    private static final String OR_CHAR = "|";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String OPEN_PARENTHESIS = "(";
    private static final Set<Character> OPERATORS = new HashSet<Character>();

    private ExpressionParser() {
    }

    private static synchronized String convertToBooleanExpressionAux(String value, String expression) {
        String element = EMPTY_STRING;
        String operator = EMPTY_STRING;
        String result = EMPTY_STRING;
        String booleanResult = EMPTY_STRING;
        for (int i = 0; i != expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c == ' ') {
                if (operator.length() > 0) {
                    booleanResult = booleanResult + operator + ONE_SPACE;
                    operator = EMPTY_STRING;
                    continue;
                }
                if (element.length() <= 0) continue;
                booleanResult = ExpressionParser.appendBooleanMatch(value, element, booleanResult);
                element = EMPTY_STRING;
                continue;
            }
            if (ExpressionParser.isOpenParenthesis(c) || ExpressionParser.isCloseParenthesis(c)) {
                if (ExpressionParser.isOpenParenthesis(c)) {
                    if (element.length() > 0 && operator.length() == 0) {
                        element = element + c;
                        continue;
                    }
                    result = result + c;
                    booleanResult = booleanResult + c + ONE_SPACE;
                    continue;
                }
                if (!ExpressionParser.isCloseParenthesis(c)) continue;
                if (element.length() > 0 && element.contains(OPEN_PARENTHESIS) && operator.length() == 0) {
                    result = result + c;
                    element = element + c;
                    booleanResult = ExpressionParser.appendBooleanMatch(value, element, booleanResult);
                    element = EMPTY_STRING;
                    operator = EMPTY_STRING;
                    continue;
                }
                if (element.length() > 0) {
                    booleanResult = ExpressionParser.appendBooleanMatch(value, element, booleanResult);
                }
                element = EMPTY_STRING;
                result = result + c;
                booleanResult = booleanResult + c + ONE_SPACE;
                continue;
            }
            if (ExpressionParser.isOperator(c)) {
                if (c == '!') {
                    booleanResult = booleanResult + c + ONE_SPACE;
                    continue;
                }
                if (operator.length() > 0) {
                    if (operator.charAt(0) != c) continue;
                    result = result + c;
                    booleanResult = booleanResult + operator + c + ONE_SPACE;
                    operator = EMPTY_STRING;
                    continue;
                }
                operator = operator + c;
                result = result + c;
                continue;
            }
            element = element + c;
            result = result + c;
        }
        if (element.length() > 0) {
            booleanResult = ExpressionParser.appendBooleanMatch(value, element, booleanResult);
        }
        return booleanResult;
    }

    private static String appendBooleanMatch(String value, String element, String booleanResult) {
        StringBuilder result = new StringBuilder(booleanResult);
        if (ExpressionParser.areExpressionsEquivalent(value, element)) {
            result.append(true).append(ONE_SPACE);
        } else {
            result.append(element).append(ONE_SPACE);
        }
        return result.toString();
    }

    public static String convertToBooleanExpression(Collection<String> elements, String expression) {
        StringBuilder builder = new StringBuilder(expression);
        for (String element : elements) {
            builder.replace(0, builder.length(), ExpressionParser.convertToBooleanExpressionAux(element, builder.toString()));
        }
        String[] booleanElements = builder.toString().split(ONE_SPACE);
        builder.delete(0, builder.length());
        for (String be : booleanElements) {
            if (!be.equals(OPEN_PARENTHESIS) && !be.equals(CLOSE_PARENTHESIS) && ExpressionParser.containsNoOperator(be) && !be.equalsIgnoreCase(TRUE)) {
                builder.append(FALSE);
                continue;
            }
            builder.append(be);
        }
        return builder.toString();
    }

    private static boolean containsNoOperator(String element) {
        return !element.contains(OR_CHAR) && !element.contains(AND_CHAR) && !element.contains(NOT_CHAR) && !element.contains(XOR_CHAR);
    }

    private static boolean isOperator(char element) {
        return OPERATORS.contains(Character.valueOf(element));
    }

    private static boolean isOpenParenthesis(char element) {
        return element == OPEN_PARENTHESIS.charAt(0);
    }

    private static boolean isCloseParenthesis(char element) {
        return element == CLOSE_PARENTHESIS.charAt(0);
    }

    public static boolean areExpressionsEquivalent(String expression1, String expression2) {
        return Pattern.matches(WildcardToRegexUtility.wildcardToRegex(expression1), expression2) || Pattern.matches(WildcardToRegexUtility.wildcardToRegex(expression2), expression1);
    }

    static {
        OPERATORS.add(Character.valueOf(EQUAL_CHAR.charAt(0)));
        OPERATORS.add(Character.valueOf(XOR_CHAR.charAt(0)));
        OPERATORS.add(Character.valueOf(NOT_CHAR.charAt(0)));
        OPERATORS.add(Character.valueOf(AND_CHAR.charAt(0)));
        OPERATORS.add(Character.valueOf(OR_CHAR.charAt(0)));
    }
}

