/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.rec.impl.i18n;

import com.linkare.net.protocols.Protocols;
import com.linkare.rec.impl.i18n.ClassloaderDelegate;
import com.linkare.rec.impl.i18n.ReCPropertyResourceBundle;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public abstract class ReCResourceBundle
extends ResourceBundle {
    private static final Logger LOGGER = Logger.getLogger(ReCResourceBundle.class.getName());
    private static Map<String, ReCResourceBundle> bundles = new HashMap<String, ReCResourceBundle>();
    private static ClassloaderDelegate CLASSLOADER_DELEGATE;

    public static String findString(String bundleName, String key) throws MissingResourceException {
        ArrayList<String> bundleNames = ReCResourceBundle.calculateLanguageVariants(bundleName, Locale.getDefault());
        ResourceBundle bundle = null;
        for (int i = 0; i < bundleNames.size() && bundle == null; ++i) {
            bundle = bundles.get(bundleNames.get(i));
        }
        if (bundle == null) {
            throw new MissingResourceException("No bundle here by the name " + bundleName, ReCResourceBundle.class.getName(), key);
        }
        return bundle.getString(key);
    }

    public static ImageIcon findImageIcon(String bundleName, String key) throws MissingResourceException, MalformedURLException {
        String location = ReCResourceBundle.findString(bundleName, key);
        URL url = Protocols.getURL((String)location);
        ImageIcon iconImage = new ImageIcon(url);
        return iconImage;
    }

    public static Object findObject(String bundleName, String key) throws MissingResourceException, IOException, ClassNotFoundException {
        String location = ReCResourceBundle.findString(bundleName, key);
        Object o = ReCResourceBundle.beansInstantiate(null, location);
        return o;
    }

    public static void setClassLoaderDelegate(ClassloaderDelegate classLoaderDelegate) {
        CLASSLOADER_DELEGATE = classLoaderDelegate;
    }

    private static Object beansInstantiate(ClassLoader classLoader, String factoryLocation) throws IOException, ClassNotFoundException {
        if (CLASSLOADER_DELEGATE != null) {
            return CLASSLOADER_DELEGATE.beansInstantiate(classLoader, factoryLocation);
        }
        return Beans.instantiate(classLoader, factoryLocation);
    }

    public static String findStringOrDefault(String bundleName, String key, String defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findString(bundleName, key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on bundle " + bundleName, e);
            return defaultValue;
        }
    }

    public static ImageIcon findImageIconOrDefault(String bundleName, String key, ImageIcon defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findImageIcon(bundleName, key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on bundle " + bundleName, e);
            return defaultValue;
        }
    }

    public static Object findObjectOrDefault(String bundleName, String key, Object defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findObject(bundleName, key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on bundle " + bundleName, e);
            return defaultValue;
        }
    }

    public static ImageIcon findImageIcon(String key) throws MissingResourceException, MalformedURLException {
        String location = ReCResourceBundle.findString(key);
        URL url = Protocols.getURL((String)location);
        ImageIcon iconImage = new ImageIcon(url);
        return iconImage;
    }

    public static Object findObject(String key) throws MissingResourceException, IOException, ClassNotFoundException {
        String location = ReCResourceBundle.findString(key);
        Object o = ReCResourceBundle.beansInstantiate(null, location);
        return o;
    }

    public static String findString(String key) throws MissingResourceException {
        if (key != null && key.indexOf(36) != -1) {
            int loc = key.indexOf(36);
            String bundleName = key.substring(0, loc);
            String bundleKey = key.substring(loc + 1);
            return ReCResourceBundle.findString(bundleName, bundleKey);
        }
        for (ReCResourceBundle bundle : bundles.values()) {
            try {
                if (!bundle.containsKey(key)) continue;
                return bundle.getString(key);
            }
            catch (Exception exception) {
            }
        }
        throw new MissingResourceException("Key '" + key + "' not found in any bundle here", ReCResourceBundle.class.getName(), key);
    }

    public static String findStringOrDefault(String key, String defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findString(key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on any bundle!", e);
            return defaultValue;
        }
    }

    public static ImageIcon findImageIconOrDefault(String key, ImageIcon defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findImageIcon(key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on any bundle!", e);
            return defaultValue;
        }
    }

    public static Object findObjectOrDefault(String key, Object defaultValue) throws MissingResourceException {
        try {
            if (key == null) {
                return defaultValue;
            }
            return ReCResourceBundle.findObject(key);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Couldn't find key '" + key + "' on any bundle!", e);
            return defaultValue;
        }
    }

    public static ReCResourceBundle loadResourceBundle(String bundleName, String bundleLocation) {
        return ReCResourceBundle.loadResourceBundle(bundleName, bundleLocation, Locale.getDefault());
    }

    public static ReCResourceBundle loadResourceBundle(String bundleName, String bundleLocation, Locale locale) {
        ArrayList<String> bundleKeys = ReCResourceBundle.calculateLanguageVariants(bundleName, locale);
        String bundleNameKey = bundleKeys.get(0);
        if (bundles.containsKey(bundleNameKey)) {
            return bundles.get(bundleNameKey);
        }
        ArrayList<String> bundleLocations = ReCResourceBundle.calculateLanguageVariants(bundleLocation, locale);
        for (int i = 0; i < bundleLocations.size(); ++i) {
            String bundleLocationCurrent = bundleLocations.get(i);
            ReCResourceBundle bundle = ReCResourceBundle.loadFromURL(bundleLocationCurrent);
            if (bundle != null) {
                bundles.put(bundleKeys.get(i), bundle);
                ReCResourceBundle.propagateBundle(bundle, bundleLocationCurrent, bundleKeys.get(i));
                return bundle;
            }
            bundle = ReCResourceBundle.loadFromClassName(bundleLocationCurrent);
            if (bundle == null) continue;
            bundles.put(bundleKeys.get(i), bundle);
            ReCResourceBundle.propagateBundle(bundle, bundleLocationCurrent, bundleKeys.get(i));
            return bundle;
        }
        return null;
    }

    private static void propagateBundle(ReCResourceBundle bundle, String bundleLocation, String bundleName) {
        ReCResourceBundle childBundle = bundle;
        String temp = bundleLocation;
        int fileExtLoc = temp.lastIndexOf(".properties");
        if (fileExtLoc != -1) {
            temp = temp.substring(0, fileExtLoc);
        }
        int loc = temp.lastIndexOf(95);
        String bundleNameTemp = bundleName;
        while (loc != -1) {
            temp = temp.substring(0, loc);
            bundleNameTemp = bundleNameTemp.substring(0, bundleNameTemp.lastIndexOf(95));
            ReCResourceBundle bundleParent = ReCResourceBundle.loadFromURL(temp);
            if (bundleParent != null) {
                bundles.put(bundleNameTemp, bundleParent);
                childBundle.parent = bundleParent;
                childBundle = bundleParent;
            } else {
                bundleParent = ReCResourceBundle.loadFromClassName(temp);
                if (bundleParent != null) {
                    bundles.put(bundleNameTemp, bundleParent);
                    childBundle.parent = bundleParent;
                    childBundle = bundleParent;
                }
            }
            loc = temp.lastIndexOf(95);
        }
    }

    private static ReCResourceBundle loadFromClassName(String className) {
        try {
            if (className == null || className.contains("://")) {
                return null;
            }
            Object oBundle = ReCResourceBundle.findClass(className, ClassLoader.getSystemClassLoader()).newInstance();
            if (oBundle instanceof ReCResourceBundle) {
                return (ReCResourceBundle)oBundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Class<?> findClass(String className, ClassLoader contextClassLoader) throws ClassNotFoundException {
        if (CLASSLOADER_DELEGATE != null) {
            return CLASSLOADER_DELEGATE.findClass(className, contextClassLoader);
        }
        return Class.forName(className, false, contextClassLoader);
    }

    private static ReCResourceBundle loadFromURL(String strUrl) {
        try {
            URL url;
            if (strUrl.indexOf(".properties") == -1) {
                strUrl = strUrl + ".properties";
            }
            if ((url = Protocols.getURL((String)strUrl)) != null) {
                URLConnection con = url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(false);
                con.connect();
                InputStream is = con.getInputStream();
                ReCPropertyResourceBundle bundle = new ReCPropertyResourceBundle(is);
                return bundle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ArrayList<String> calculateLanguageVariants(String base, Locale locale) {
        String language1 = locale.getLanguage();
        String country1 = locale.getCountry();
        String variant1 = locale.getVariant();
        Locale defLocale = Locale.getDefault();
        String language2 = defLocale.getLanguage();
        String country2 = defLocale.getCountry();
        String variant2 = defLocale.getVariant();
        ArrayList<String> retVal = new ArrayList<String>(7);
        String temp = "";
        if (language1 != null && !language1.equals("")) {
            temp = temp + "_" + language1;
            retVal.add(base + temp);
            if (country1 != null && !country1.equals("")) {
                temp = temp + "_" + country1;
                retVal.add(0, base + temp);
                if (variant1 != null && !variant1.equals("")) {
                    temp = temp + "_" + variant1;
                    retVal.add(0, base + temp);
                }
            }
        }
        if (!(language1 != null && language2 != null && language1.equals(language2) && country1 != null && country2 != null && country1.equals(country2) && variant1 != null && variant2 != null && variant1.equals(variant2))) {
            temp = "";
            int locationInsert = retVal.size();
            if (language2 != null && !language2.equals("")) {
                temp = temp + "_" + language2;
                retVal.add(base + temp);
                if (country2 != null && !country2.equals("")) {
                    temp = temp + "_" + country2;
                    retVal.add(locationInsert, base + temp);
                    if (variant2 != null && !variant2.equals("")) {
                        temp = temp + "_" + variant2;
                        retVal.add(locationInsert, base + temp);
                    }
                }
            }
        }
        retVal.add(base);
        return retVal;
    }
}

